/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.preferences;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.python.pydev.core.docutils.WrapAndCaseUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.AbstractPydevPrefs;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class PydevTypingPrefs
extends AbstractPydevPrefs {
    public PydevTypingPrefs() {
        this.setDescription("Editor");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        Button b = this.addCheckBox(appearanceComposite, "Enable link on automatic parenthesis or literals closing", "AUTO_LINK", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Enabling this option will enable the linking mode after a parenthesis or literal is auto-closed.", (int)80));
        b = this.addCheckBox(appearanceComposite, "Automatic parentheses insertion", "AUTO_PAR", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Enabling this option will enable automatic insertion of parentheses.  Specifically, whenever you hit a brace such as '(', '{', or '[', its related peer will be inserted and your cursor will be placed between the two braces.", (int)80));
        b = this.addCheckBox(appearanceComposite, "After '(' indent to its level (indents by tabs if unchecked)", "AUTO_INDENT_TO_PAR_LEVEL", 0);
        Control c = this.addTextField(appearanceComposite, "Number of indentation levels to add:", "AUTO_INDENT_AFTER_PAR_WIDTH", 3, 20, true);
        this.createInverseDependency(b, "AUTO_INDENT_AFTER_PAR_WIDTH", c);
        b = this.addCheckBox(appearanceComposite, "Automatic dedent of 'else:' and 'elif:'", "AUTO_DEDENT_ELSE", 0);
        b = this.addCheckBox(appearanceComposite, "Automatically skip matching braces when typing", "AUTO_BRACES", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Enabling this option will enable automatically skipping matching braces if you try to insert them.  For example, if you have the following code:\n\ndef function(self):\n\n...with your cursor before the end parenthesis (after the 'f' in \"self\"), typing a ')' will simply move the cursor to the position after the ')' without inserting a new one.", (int)80));
        b = this.addCheckBox(appearanceComposite, "Use smart-indent?", "SMART_INDENT_PAR", 0);
        b = this.addCheckBox(appearanceComposite, "Automatic colon detection", "AUTO_COLON", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Enabling this feature will enable the editor to detect if you are trying to enter a colon which is already there.  Instead of inserting another colon, the editor will simply move your cursor to the next position after the colon.", (int)80));
        b = this.addCheckBox(appearanceComposite, "Automatic literal closing", "AUTO_LITERALS", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Automatically close literals (when ' or \" is added, another one is added to close it).", (int)80));
        b = this.addCheckBox(appearanceComposite, "Automatic insertion of the 'import' string on 'from xxx' ", "AUTO_WRITE_IMPORT_STR", 0);
        b.setToolTipText(WrapAndCaseUtils.wrap((String)"Enabling this will allow the editor to automatically write the'import' string when you write a space after you've written 'from xxx '.", (int)80));
        this.addCheckBox(appearanceComposite, "Add 'self' automatically when declaring methods?", "AUTO_ADD_SELF", 0);
        KeySequence down = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineDown");
        KeySequence up = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineUp");
        String downKey = down != null ? down.format() : "Alt+Down";
        String upKey = up != null ? up.format() : "Alt+Up";
        this.addCheckBox(appearanceComposite, StringUtils.format((String)"Smart move for line up  (%s) and line down (%s)?.", (Object[])new Object[]{upKey, downKey}), "SMART_LINE_MOVE", 0);
        this.addLabel(appearanceComposite, "Note: smart move line up/down change applied on editor restart.", 20);
        return appearanceComposite;
    }
}

