/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.string.StringUtils;

public class ProcessCreationInfo {
    public final String[] parameters;
    public final String[] envp;
    public final File workingDir;
    public final Process process;
    private ThreadStreamReader stdReader;
    private ThreadStreamReader errReader;

    public ProcessCreationInfo(String[] parameters, String[] envp, File workingDir, Process process) {
        this.parameters = parameters;
        if (envp != null) {
            Arrays.sort(envp);
        }
        this.envp = envp;
        this.workingDir = workingDir;
        this.process = process;
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {}
        this.stdReader = new ThreadStreamReader(process.getInputStream());
        this.errReader = new ThreadStreamReader(process.getErrorStream());
        this.stdReader.setName("Shell reader (stdout)");
        this.errReader.setName("Shell reader (stderr)");
        this.stdReader.start();
        this.errReader.start();
    }

    public String getProcessLog() {
        String osName;
        String joinedParams = StringUtils.join((String)" ", (String[])this.parameters);
        String environment = "EMPTY ENVIRONMENT";
        if (this.envp != null) {
            environment = StringUtils.join((String)"\n", (String[])this.envp);
        }
        String workDir = "NULL WORK DIR";
        if (this.workingDir != null) {
            workDir = this.workingDir.toString();
        }
        if ((osName = System.getProperty("os.name")) == null) {
            osName = "Unknown OS!";
        }
        String stdContents = this.stdReader.getContents();
        String errContents = this.errReader.getContents();
        String[] splitted = new String[]{"ProcessInfo:\n\n - Executed: ", joinedParams, "\n\n - Environment:\n", environment, "\n\n - Working Dir:\n", workDir, "\n\n - OS:\n", osName, "\n\n - Std output:\n", stdContents, "\n\n - Err output:\n", errContents};
        return StringUtils.join((String)"", (String[])splitted);
    }
}

