/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerWithBuild;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.PredefinedSourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemModulesManager
extends ModulesManagerWithBuild
implements ISystemModulesManager {
    private transient IPythonNature nature;
    private InterpreterInfo info;
    private final LRUCache<String, String> builtinsNotConsidered = new LRUCache(500);
    private transient Map<File, Long> predefinedFilesNotParsedToTimestamp;

    public SystemModulesManager(InterpreterInfo info) {
        this.info = info;
    }

    public void setInfo(InterpreterInfo info) {
        this.info = info;
    }

    public void endProcessing() {
        this.save();
    }

    public String[] getBuiltins() {
        return this.info.getBuiltins();
    }

    public void setPythonNature(IPythonNature nature) {
        Assert.isTrue((boolean)(nature instanceof SystemPythonNature));
        Assert.isTrue((((SystemPythonNature)nature).info == this.info ? 1 : 0) != 0);
        this.nature = nature;
    }

    public IPythonNature getNature() {
        if (this.nature == null) {
            IInterpreterManager manager = this.getInterpreterManager();
            this.nature = new SystemPythonNature(manager, this.info);
        }
        return this.nature;
    }

    public IInterpreterManager getInterpreterManager() {
        int interpreterType = this.info.getInterpreterType();
        switch (interpreterType) {
            case 1: {
                return PydevPlugin.getJythonInterpreterManager();
            }
            case 0: {
                return PydevPlugin.getPythonInterpreterManager();
            }
            case 2: {
                return PydevPlugin.getIronpythonInterpreterManager();
            }
        }
        throw new RuntimeException("Don't know how to handle: " + interpreterType);
    }

    public ISystemModulesManager getSystemModulesManager() {
        return this;
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        return this.getModule(name, nature, dontSearchInit);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        return super.resolveModule(full);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (interpreter == null) {
            throw new RuntimeException("The interpreter must be specified (received null)");
        }
        return interpreter.getPythonPath();
    }

    public IModule getRelativeModule(String name, IPythonNature nature) {
        return super.getModule(name, nature, true);
    }

    @Override
    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
        String[] builtins = this.getBuiltins();
        if (builtins != null) {
            int i = 0;
            while (i < builtins.length) {
                String name = builtins[i];
                ModulesKey k = new ModulesKey(name, null);
                keys.put(k, k);
                ++i;
            }
        }
    }

    private boolean contains(IToken[] tokens, String rep) {
        IToken[] iTokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken token = iTokenArray[n2];
            if (token.getRepresentation().equals(rep)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public AbstractModule getBuiltinModule(String name, boolean dontSearchInit) {
        AbstractModule n = null;
        String[] builtins = this.getBuiltins();
        if (builtins == null || this.info == null) {
            return null;
        }
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        File predefinedModule = this.info.getPredefinedModule(name);
        if (predefinedModule != null && predefinedModule.exists()) {
            PredefinedSourceModule predefinedSourceModule;
            keyForCacheAccess.name = name;
            keyForCacheAccess.file = predefinedModule;
            n = cache.getObj(keyForCacheAccess, this);
            if (n instanceof PredefinedSourceModule && (predefinedSourceModule = (PredefinedSourceModule)n).isSynched()) {
                return n;
            }
            boolean tryToParse = true;
            Long lastModified = null;
            if (this.predefinedFilesNotParsedToTimestamp == null) {
                this.predefinedFilesNotParsedToTimestamp = new HashMap<File, Long>();
            } else {
                Long lastTimeChanged = this.predefinedFilesNotParsedToTimestamp.get(predefinedModule);
                if (lastTimeChanged != null) {
                    lastModified = predefinedModule.lastModified();
                    if (lastTimeChanged.equals(lastModified)) {
                        tryToParse = false;
                    } else {
                        this.predefinedFilesNotParsedToTimestamp.remove(predefinedModule);
                    }
                }
            }
            if (tryToParse) {
                try {
                    IDocument doc = FileUtilsFileBuffer.getDocFromFile((File)predefinedModule);
                    IGrammarVersionProvider provider = new IGrammarVersionProvider(){

                        public int getGrammarVersion() throws MisconfigurationException {
                            return 99;
                        }
                    };
                    Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, provider, name, predefinedModule));
                    if (obj.o2 != null) {
                        if (lastModified == null) {
                            lastModified = predefinedModule.lastModified();
                        }
                        this.predefinedFilesNotParsedToTimestamp.put(predefinedModule, lastModified);
                        Log.log((String)("Unable to parse: " + predefinedModule), (Throwable)((Throwable)obj.o2));
                    } else if (obj.o1 != null) {
                        n = new PredefinedSourceModule(name, predefinedModule, (SimpleNode)obj.o1, (Throwable)obj.o2);
                        this.doAddSingleModule(keyForCacheAccess, n);
                        return n;
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        boolean foundStartingWithBuiltin = false;
        FastStringBuffer buffer = null;
        int i = 0;
        while (i < builtins.length) {
            String forcedBuiltin = builtins[i];
            if (name.startsWith(forcedBuiltin)) {
                if (name.length() > forcedBuiltin.length() && name.charAt(forcedBuiltin.length()) == '.') {
                    foundStartingWithBuiltin = true;
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null && !dontSearchInit) {
                        if (buffer == null) {
                            buffer = new FastStringBuffer();
                        } else {
                            buffer.clear();
                        }
                        keyForCacheAccess.name = buffer.append(name).append(".__init__").toString();
                        n = cache.getObj(keyForCacheAccess, this);
                    }
                    if (n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, this);
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (name.equals(forcedBuiltin)) {
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null || n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, this);
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (n instanceof CompiledModule) {
                    return n;
                }
            }
            ++i;
        }
        if (foundStartingWithBuiltin) {
            if (this.builtinsNotConsidered.getObj((Object)name) != null) {
                return null;
            }
            n = new CompiledModule(name, this);
            IToken[] globalTokens = n.getGlobalTokens();
            if (globalTokens.length > 0 && this.contains(globalTokens, "__file__")) {
                this.doAddSingleModule(new ModulesKey(name, null), n);
                return n;
            }
            this.builtinsNotConsidered.add((Object)name, (Object)name);
            return null;
        }
        return null;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        AbstractModule n = this.getBuiltinModule(name, dontSearchInit);
        if (n != null) {
            return n;
        }
        return super.getModule(name, nature, dontSearchInit);
    }

    public IModule getModuleWithoutBuiltins(String name, IPythonNature nature, boolean dontSearchInit) {
        return super.getModule(name, nature, dontSearchInit);
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        IModule module = this.getModule(name, nature, checkSystemManager, dontSearchInit);
        if (module != null) {
            return new Tuple((Object)module, (Object)this);
        }
        return null;
    }

    public void load() throws IOException {
        File workspaceMetadataFile = this.getIoDirectory();
        ModulesManager.loadFromFile(this, workspaceMetadataFile);
        try {
            this.deltaSaver = new DeltaSaver(this.getIoDirectory(), "v1_sys_astdelta", readFromFileMethod, toFileMethod);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        this.deltaSaver.processDeltas((IDeltaProcessor)this);
    }

    public void save() {
        File workspaceMetadataFile = this.getIoDirectory();
        if (this.deltaSaver != null) {
            this.deltaSaver.clearAll();
        }
        this.saveToFile(workspaceMetadataFile);
        this.deltaSaver = new DeltaSaver(this.getIoDirectory(), "v1_sys_astdelta", readFromFileMethod, toFileMethod);
    }

    public File getIoDirectory() {
        File workspaceMetadataFile = PydevPlugin.getWorkspaceMetadataFile(this.info.getExeAsFileSystemValidPath());
        return workspaceMetadataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeysAndSave(PyPublicTreeMap<ModulesKey, ModulesKey> keysFound) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.clear();
            this.modulesKeys.putAll(keysFound);
        }
        this.save();
    }
}

