/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyCodeCompletionVisitor
extends PyDevBuilderVisitor {
    public static final int PRIORITY_CODE_COMPLETION = 5;

    @Override
    protected int getPriority() {
        return 5;
    }

    @Override
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        ICodeCompletionASTManager astManager;
        PythonNature pythonNature = this.getPythonNature(resource);
        if (pythonNature != null && (astManager = pythonNature.getAstManager()) != null) {
            IPath location = resource.getLocation();
            astManager.rebuildModule(new File(location.toOSString()), document, resource.getProject(), (IProgressMonitor)new NullProgressMonitor(), (IPythonNature)pythonNature);
        }
    }

    @Override
    public void visitAddedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor);
        if (PythonPathHelper.isValidInitFile(resource.getName())) {
            Long originalTime = (Long)this.memo.get("DOCUMENT_TIME");
            try {
                IResource[] initDependents = this.getInitDependents(resource);
                int i = 0;
                while (i < initDependents.length) {
                    IResource dependent = initDependents[i];
                    this.memo.put("DOCUMENT_TIME", System.currentTimeMillis());
                    this.visitChangedResource(dependent, (ICallback0<IDocument>)FileUtilsFileBuffer.getDocOnCallbackFromResource((IResource)dependent), monitor);
                    ++i;
                }
            }
            finally {
                this.memo.put("DOCUMENT_TIME", originalTime);
            }
        }
    }

    @Override
    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        ICodeCompletionASTManager astManager;
        PythonNature pythonNature = this.getPythonNature(resource);
        if (pythonNature != null && (astManager = pythonNature.getAstManager()) != null) {
            IPath location = resource.getLocation();
            astManager.removeModule(new File(location.toOSString()), resource.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected IResource[] getInitDependents(IResource initResource) {
        ArrayList<IResource> toRet = new ArrayList<IResource>();
        IContainer parent = initResource.getParent();
        try {
            IResource[] members = parent.members();
            ArrayList<IResource> lst = new ArrayList<IResource>(members.length - 1);
            int i = 0;
            while (i < members.length) {
                IResource resource = members[i];
                if (!PythonPathHelper.isValidInitFile(resource.getName())) {
                    lst.add(resource);
                }
                ++i;
            }
            this.fillWithMembers(toRet, parent, lst.toArray(new IResource[lst.size()]));
        }
        catch (CoreException coreException) {}
        return toRet.toArray(new IResource[0]);
    }

    private void fillWithMembers(List<IResource> toRet, IContainer parent, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                if (PythonPathHelper.isValidSourceFile(resource.getName())) {
                    toRet.add(resource);
                }
            } else if (resource.getType() == 2) {
                IFolder folder = (IFolder)resource;
                try {
                    IResource[] members = folder.members();
                    int j = 0;
                    while (j < members.length) {
                        if (PythonPathHelper.isValidInitFile(members[j].getName())) {
                            this.fillWithMembers(toRet, (IContainer)folder, members);
                            break;
                        }
                        ++j;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }
}

