/*
 * Decompiled with CFR 0.152.
 */
package org.python.copiedfromeclipsesrc;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PythonListEditor
extends FieldEditor {
    public static boolean USE_ICONS = true;
    private Tree treeWithInterpreters;
    private Composite buttonBox;
    private Button addButton;
    protected Button autoConfigButton;
    protected Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;
    private Image imageInterpreter;

    protected PythonListEditor() {
        if (USE_ICONS) {
            this.imageInterpreter = PydevPlugin.getImageCache().get("icons/python_16x16.png");
        }
    }

    protected PythonListEditor(String name, String labelText, Composite parent) {
        this();
        this.init(name, labelText);
        this.createControl(parent);
    }

    public void autoConfigPressed() {
        Tuple<String, String> input = this.getNewInputObject(true);
        if (input != null) {
            this.addNewInput((String)input.o1, (String)input.o2);
        }
    }

    protected void addPressed() {
        Tuple<String, String> input = this.getNewInputObject(false);
        if (input != null) {
            this.addNewInput((String)input.o1, (String)input.o2);
        }
    }

    private void addNewInput(String name, String executable) {
        if (name != null && executable != null) {
            this.setPresentsDefaultValue(false);
            TreeItem item = this.createInterpreterItem(name, executable);
            try {
                this.treeWithInterpreters.setSelection(item);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            this.selectionChanged();
            this.updateTree();
        }
    }

    protected abstract void updateTree();

    protected TreeItem createInterpreterItem(String name, String executable) {
        TreeItem item = new TreeItem(this.treeWithInterpreters, 0);
        item.setText(new String[]{name, executable});
        item.setImage(this.imageInterpreter);
        return item;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.treeWithInterpreters.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.autoConfigButton = this.createPushButton(box, "Auto Config");
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
        this.upButton = this.createPushButton(box, "ListEditor.up");
        this.downButton = this.createPushButton(box, "ListEditor.down");
    }

    protected String createList(String[] items) {
        throw new RuntimeException("doLoad/doStore should be overridden (so that it's not needed)");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == PythonListEditor.this.addButton) {
                    PythonListEditor.this.addPressed();
                } else if (widget == PythonListEditor.this.autoConfigButton) {
                    PythonListEditor.this.autoConfigPressed();
                } else if (widget == PythonListEditor.this.removeButton) {
                    PythonListEditor.this.removePressed();
                } else if (widget == PythonListEditor.this.upButton) {
                    PythonListEditor.this.upPressed();
                } else if (widget == PythonListEditor.this.downButton) {
                    PythonListEditor.this.downPressed();
                } else if (widget == PythonListEditor.this.treeWithInterpreters) {
                    PythonListEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.treeWithInterpreters = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.treeWithInterpreters.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected abstract void doLoad();

    protected abstract void doLoadDefault();

    protected abstract void doStore();

    protected void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PythonListEditor.this.addButton = null;
                    PythonListEditor.this.autoConfigButton = null;
                    PythonListEditor.this.removeButton = null;
                    PythonListEditor.this.upButton = null;
                    PythonListEditor.this.downButton = null;
                    PythonListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Tree getListControl(Composite parent) {
        if (this.treeWithInterpreters == null) {
            this.treeWithInterpreters = new Tree(parent, 2820);
            this.treeWithInterpreters.setHeaderVisible(true);
            TreeColumn column1 = new TreeColumn(this.treeWithInterpreters, 16384);
            column1.setText("Name");
            column1.setWidth(200);
            TreeColumn column2 = new TreeColumn(this.treeWithInterpreters, 16384);
            column2.setText("Location");
            column2.setWidth(200);
            this.treeWithInterpreters.setFont(parent.getFont());
            this.treeWithInterpreters.addSelectionListener(this.getSelectionListener());
            this.treeWithInterpreters.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PythonListEditor.this.treeWithInterpreters = null;
                }
            });
        } else {
            this.checkParent((Control)this.treeWithInterpreters, parent);
        }
        return this.treeWithInterpreters;
    }

    protected abstract Tuple<String, String> getNewInputObject(boolean var1);

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected String[] parseString(String stringList) {
        throw new RuntimeException("doLoad/doStore should be overridden (so that it's not needed)");
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        TreeItem[] selection = this.treeWithInterpreters.getSelection();
        if (selection != null && selection.length > 0) {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem t = treeItemArray[n2];
                this.disposeOfTreeItem(t);
                ++n2;
            }
            this.selectionChanged();
            this.updateTree();
        }
    }

    protected void disposeOfTreeItem(TreeItem t) {
        t.dispose();
    }

    protected void selectionChanged() {
        int index = this.getSelectionIndex();
        int size = this.treeWithInterpreters.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.treeWithInterpreters != null) {
            this.treeWithInterpreters.setFocus();
        }
    }

    protected int getSelectionIndex() {
        if (this.treeWithInterpreters.getSelectionCount() != 1) {
            return -1;
        }
        TreeItem[] selection = this.treeWithInterpreters.getSelection();
        int index = -1;
        if (selection != null && selection.length > 0) {
            index = this.treeWithInterpreters.indexOf(selection[0]);
        }
        return index;
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            TreeItem curr = this.treeWithInterpreters.getItem(index);
            TreeItem replace = this.treeWithInterpreters.getItem(target);
            String col0 = replace.getText(0);
            String col1 = replace.getText(1);
            replace.setText(new String[]{curr.getText(0), curr.getText(1)});
            curr.setText(new String[]{col0, col1});
            this.treeWithInterpreters.setSelection(this.treeWithInterpreters.getItem(target));
        }
        this.selectionChanged();
    }

    protected void upPressed() {
        this.swap(true);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.autoConfigButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }
}

