/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.fastparser.TabNannyDocIterator;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public class ScopesParser {
    private Scopes scopes;
    private SortedMap<Integer, Integer> lineOffsetToIndent = new TreeMap<Integer, Integer>();
    private IDocument doc;

    public static Scopes createScopes(IDocument doc) {
        ScopesParser scopesParser = new ScopesParser(doc);
        try {
            return scopesParser.createScopes();
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    private ScopesParser(IDocument doc) {
        this.scopes = new Scopes();
        this.doc = doc;
        try {
            TabNannyDocIterator nannyDocIterator = new TabNannyDocIterator(doc, true, false);
            while (nannyDocIterator.hasNext()) {
                Tuple3<String, Integer, Boolean> next = nannyDocIterator.next();
                this.lineOffsetToIndent.put((Integer)next.o2, ((String)next.o1).length());
            }
        }
        catch (BadLocationException e1) {
            throw new RuntimeException(e1);
        }
    }

    private Scopes createScopes() throws SyntaxErrorException {
        int globalScope = this.scopes.startScope(0, 4);
        int offset = this.createInternalScopes(ParsingUtils.create((Object)this.doc, (boolean)true), 0);
        this.scopes.endScope(globalScope, offset, 4);
        return this.scopes;
    }

    private int createInternalScopes(ParsingUtils parsingUtils, int offsetDelta) {
        int docLen = parsingUtils.len();
        int offset = 0;
        FastStringBuffer buf = new FastStringBuffer();
        FastStringBuffer lineMemo = new FastStringBuffer();
        int memoStart = 0;
        while (offset < docLen) {
            char ch = parsingUtils.charAt(offset);
            switch (ch) {
                case '#': {
                    int id = this.scopes.startScope(offsetDelta + offset, Scopes.TYPE_COMMENT);
                    offset = parsingUtils.eatComments(buf.clear(), offset);
                    this.scopes.endScope(id, offsetDelta + offset, Scopes.TYPE_COMMENT);
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    int id;
                    int baseOffset = offset;
                    try {
                        offset = parsingUtils.eatPar(offset, buf.clear(), ch);
                        id = this.scopes.startScope(offsetDelta + baseOffset + 1, 2);
                        try {
                            String cs = this.doc.get(offsetDelta + baseOffset + 1, offset - baseOffset - 1);
                            this.createInternalScopes(ParsingUtils.create((Object)cs, (boolean)true), offsetDelta + baseOffset + 1);
                        }
                        catch (BadLocationException e1) {
                            Log.log((Throwable)e1);
                        }
                        this.scopes.endScope(id, offsetDelta + offset, 2);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {}
                    break;
                }
                case '\"': 
                case '\'': {
                    int id;
                    int baseOffset = offset;
                    try {
                        offset = parsingUtils.eatLiterals(buf.clear(), offset);
                        id = this.scopes.startScope(offsetDelta + baseOffset, 3);
                        this.scopes.endScope(id, offsetDelta + offset + 1, 3);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {}
                    break;
                }
                case ':': {
                    if (!PySelection.startsWithIndentToken((String)lineMemo.toString().trim())) break;
                    SortedMap<Integer, Integer> subMap = this.lineOffsetToIndent.tailMap(offsetDelta + memoStart + 1);
                    Integer level = (Integer)this.lineOffsetToIndent.get(offsetDelta + memoStart);
                    if (level == null) break;
                    Set<Map.Entry<Integer, Integer>> entrySet = subMap.entrySet();
                    boolean found = false;
                    int id = this.scopes.startScope(memoStart + level, 5);
                    int id2 = -1;
                    int j = offset + 1;
                    while (j < docLen) {
                        char c = parsingUtils.charAt(j);
                        if (!Character.isWhitespace(c)) {
                            if (c == '#') {
                                j = parsingUtils.eatComments(null, j);
                            } else {
                                id2 = this.scopes.startScope(offsetDelta + j, 5);
                                break;
                            }
                        }
                        ++j;
                    }
                    for (Map.Entry<Integer, Integer> entry : entrySet) {
                        if (level < entry.getValue()) continue;
                        found = true;
                        Integer scopeEndOffset = entry.getKey();
                        try {
                            int line = this.doc.getLineOfOffset(scopeEndOffset.intValue());
                            if (line > 0) {
                                IRegion lineInformation = this.doc.getLineInformation(line - 1);
                                scopeEndOffset = lineInformation.getOffset() + lineInformation.getLength();
                            }
                        }
                        catch (BadLocationException e) {
                            Log.log((Throwable)e);
                        }
                        this.scopes.endScope(id, scopeEndOffset, 5);
                        if (id2 <= 0) break;
                        this.scopes.endScope(id2, scopeEndOffset, 5);
                        break;
                    }
                    if (found) break;
                    this.scopes.endScope(id, offsetDelta + parsingUtils.len(), 5);
                    if (id2 <= 0) break;
                    this.scopes.endScope(id2, offsetDelta + parsingUtils.len(), 5);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (lineMemo.length() <= 0 || lineMemo.lastChar() == '\\') break;
                    lineMemo.clear();
                    break;
                }
                default: {
                    if (lineMemo.length() == 0) {
                        memoStart = offset;
                    }
                    lineMemo.append(ch);
                }
            }
            ++offset;
        }
        return offset;
    }

    public static class ScopeEntry {
        public final int type;
        public final boolean open;
        public final int id;
        public final int offset;

        public ScopeEntry(int id, int type, boolean open, int offset) {
            this.type = type;
            this.open = open;
            this.id = id;
            this.offset = offset;
        }

        public void toString(FastStringBuffer temp) {
            if (this.open) {
                temp.append('[');
                temp.append(this.id);
                temp.append(' ');
            } else {
                temp.append(' ');
                temp.append(this.id);
                temp.append(']');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Scopes {
        public static int TYPE_COMMENT = 1;
        public static final int TYPE_PEER = 2;
        public static final int TYPE_STRING = 3;
        public static final int TYPE_MODULE = 4;
        public static final int TYPE_SUITE = 5;
        private Map<Integer, List<ScopeEntry>> offsetToEntries = new HashMap<Integer, List<ScopeEntry>>();
        private int scopeId = 0;
        private Map<Integer, Tuple<ScopeEntry, ScopeEntry>> idToStartEnd = new HashMap<Integer, Tuple<ScopeEntry, ScopeEntry>>();

        private List<ScopeEntry> getAtOffset(int offset) {
            List<ScopeEntry> list = this.offsetToEntries.get(offset);
            if (list == null) {
                list = new ArrayList<ScopeEntry>();
                this.offsetToEntries.put(offset, list);
            }
            return list;
        }

        public IRegion getScopeForSelection(int offset, int len) {
            int endOffset = offset + len - 1;
            int i = offset;
            while (i >= 0) {
                List<ScopeEntry> list = this.offsetToEntries.get(i);
                if (list != null) {
                    ListIterator<ScopeEntry> listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        ScopeEntry scopeEntry = listIterator.previous();
                        if (!scopeEntry.open) continue;
                        Tuple<ScopeEntry, ScopeEntry> tup = this.idToStartEnd.get(scopeEntry.id);
                        if (i == offset && endOffset == ((ScopeEntry)tup.o2).offset || endOffset > ((ScopeEntry)tup.o2).offset) continue;
                        return new Region(((ScopeEntry)tup.o1).offset, ((ScopeEntry)tup.o2).offset - ((ScopeEntry)tup.o1).offset + 1);
                    }
                }
                --i;
            }
            return null;
        }

        public int startScope(int offset, int type) {
            ++this.scopeId;
            List<ScopeEntry> list = this.getAtOffset(offset);
            ScopeEntry startEntry = new ScopeEntry(this.scopeId, type, true, offset);
            list.add(startEntry);
            this.idToStartEnd.put(this.scopeId, (Tuple<ScopeEntry, ScopeEntry>)new Tuple((Object)startEntry, null));
            return this.scopeId;
        }

        public void endScope(int id, int offset, int type) {
            List<ScopeEntry> list = this.getAtOffset(--offset);
            ScopeEntry endEntry = new ScopeEntry(id, type, false, offset);
            this.idToStartEnd.get((Object)Integer.valueOf((int)id)).o2 = endEntry;
            list.add(endEntry);
        }

        public FastStringBuffer debugString(Object doc) {
            ParsingUtils utils = ParsingUtils.create((Object)doc);
            FastStringBuffer temp = new FastStringBuffer(utils.len() + utils.len() / 10);
            int len = utils.len();
            int i = 0;
            while (i < len) {
                char c = utils.charAt(i);
                this.printEntries(temp, i, true);
                temp.append(c);
                this.printEntries(temp, i, false);
                ++i;
            }
            return temp;
        }

        private void printEntries(FastStringBuffer temp, int i, boolean opening) {
            List<ScopeEntry> list = this.offsetToEntries.get(i);
            if (list != null) {
                for (ScopeEntry e : list) {
                    if (e.open != opening) continue;
                    e.toString(temp);
                }
            }
        }
    }
}

