/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.IPyParser;
import org.python.pydev.parser.IGrammar;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.grammar24.PythonGrammar24;
import org.python.pydev.parser.grammar25.PythonGrammar25;
import org.python.pydev.parser.grammar26.PythonGrammar26;
import org.python.pydev.parser.grammar27.PythonGrammar27;
import org.python.pydev.parser.grammar30.PythonGrammar30;
import org.python.pydev.parser.grammarcommon.AbstractPythonGrammar;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_core.parsing.IParserObserver2;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyParser
extends BaseParser
implements IPyParser {
    public static boolean DEBUG_SHOW_PARSE_ERRORS = false;
    public static boolean USE_FAST_STREAM = true;
    public static boolean ENABLE_TRACING = false;
    private final IGrammarVersionProvider grammarVersionProvider;
    public static final List<ICallback<Object, Tuple3<ISimpleNode, Throwable, ParserInfo>>> successfulParseListeners = new ArrayList<ICallback<Object, Tuple3<ISimpleNode, Throwable, ParserInfo>>>();

    public static String getGrammarVersionStr(int grammarVersion) {
        if (grammarVersion == 10) {
            return "grammar: Python 2.4";
        }
        if (grammarVersion == 11) {
            return "grammar: Python 2.5";
        }
        if (grammarVersion == 12) {
            return "grammar: Python 2.6";
        }
        if (grammarVersion == 13) {
            return "grammar: Python 2.7";
        }
        if (grammarVersion == 99) {
            return "grammar: Python 3.0";
        }
        if (grammarVersion == 777) {
            return "grammar: Cython";
        }
        return "grammar: unrecognized: " + grammarVersion;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        return this.grammarVersionProvider.getGrammarVersion();
    }

    public PyParser(IGrammarVersionProvider grammarVersionProvider) {
        super((BaseParserManager)PyParserManager.getPyParserManager((IPreferenceStore)new PreferenceStore()));
        if (grammarVersionProvider == null) {
            grammarVersionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() {
                    return 13;
                }
            };
        }
        this.grammarVersionProvider = grammarVersionProvider;
    }

    public PyParser(IPyEdit editorView) {
        this(PyParser.getGrammarProviderFromEdit(editorView));
    }

    private static IGrammarVersionProvider getGrammarProviderFromEdit(IPyEdit editorView) {
        return editorView.getGrammarVersionProvider();
    }

    public void notifySaved() {
        this.forceReparse(new Object[0]);
    }

    public boolean forceReparse(Object ... argsToReparse) {
        if (this.disposed) {
            return true;
        }
        return this.scheduler.parseNow(true, argsToReparse);
    }

    protected void fireParserChanged(ChangedParserInfoForObservers info) {
        super.fireParserChanged(info);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
        for (IParserObserver observer : participants) {
            try {
                if (observer instanceof IParserObserver3) {
                    ((IParserObserver3)observer).parserChanged(info);
                    continue;
                }
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserChanged(info.root, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                observer.parserChanged(info.root, info.file, info.doc);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected void fireParserError(ErrorParserInfoForObservers info) {
        super.fireParserError(info);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
        for (IParserObserver observer : participants) {
            if (observer instanceof IParserObserver3) {
                ((IParserObserver3)observer).parserError(info);
                continue;
            }
            if (observer instanceof IParserObserver2) {
                ((IParserObserver2)observer).parserError(info.error, info.file, info.doc, info.argsToReparse);
                continue;
            }
            observer.parserError(info.error, info.file, info.doc);
        }
    }

    public Tuple<ISimpleNode, Throwable> reparseDocument(Object ... argsToReparse) {
        ChangedParserInfoForObservers info;
        int version;
        try {
            version = this.grammarVersionProvider.getGrammarVersion();
        }
        catch (MisconfigurationException misconfigurationException) {
            version = 13;
        }
        long documentTime = System.currentTimeMillis();
        Tuple<ISimpleNode, Throwable> obj = PyParser.reparseDocument(new ParserInfo(this.document, version, true));
        IFile original = null;
        Object adaptable = null;
        if (this.input == null) {
            return obj;
        }
        original = this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
        adaptable = original != null ? original : (IAdaptable)this.input;
        if (original != null) {
            try {
                PyParser.deleteErrorMarkers((IResource)original);
            }
            catch (ResourceException e) {
                if (original.exists()) {
                    Log.log((Throwable)e);
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        } else if (adaptable == null && !ACCEPT_NULL_INPUT_EDITOR) {
            throw new RuntimeException("Null input editor received in parser!");
        }
        if (this.disposed) {
            return new Tuple(null, null);
        }
        if (obj.o1 != null) {
            info = new ChangedParserInfoForObservers((ISimpleNode)obj.o1, (IAdaptable)adaptable, this.document, documentTime, argsToReparse);
            this.fireParserChanged(info);
        }
        if (obj.o2 instanceof ParseException || obj.o2 instanceof TokenMgrError) {
            info = new ErrorParserInfoForObservers((Throwable)obj.o2, (IAdaptable)adaptable, this.document, argsToReparse);
            this.fireParserError((ErrorParserInfoForObservers)info);
        }
        return obj;
    }

    private static char[] createCharArrayToParse(String startDoc) {
        int length = startDoc.length();
        int skipAtStart = 0;
        if (startDoc.startsWith(FileUtils.BOM_UTF8)) {
            skipAtStart = FileUtils.BOM_UTF8.length();
        } else if (startDoc.startsWith(FileUtils.BOM_UNICODE)) {
            skipAtStart = FileUtils.BOM_UNICODE.length();
        }
        int addAtEnd = 0;
        if (!startDoc.endsWith("\n") && !startDoc.endsWith("\r")) {
            addAtEnd = 1;
        }
        char[] charArray = new char[length - skipAtStart + addAtEnd];
        startDoc.getChars(skipAtStart, length, charArray, 0);
        if (addAtEnd > 0) {
            charArray[charArray.length - 1] = 10;
        }
        return charArray;
    }

    private static IGrammar createGrammar(boolean generateTree, int grammarVersion, char[] charArray) {
        AbstractPythonGrammar grammar;
        FastCharStream in = new FastCharStream(charArray);
        switch (grammarVersion) {
            case 10: {
                grammar = new PythonGrammar24(generateTree, in);
                break;
            }
            case 11: {
                grammar = new PythonGrammar25(generateTree, in);
                break;
            }
            case 12: {
                grammar = new PythonGrammar26(generateTree, in);
                break;
            }
            case 13: {
                grammar = new PythonGrammar27(generateTree, in);
                break;
            }
            case 99: {
                grammar = new PythonGrammar30(generateTree, in);
                break;
            }
            default: {
                throw new RuntimeException("The grammar specified for parsing is not valid: " + grammarVersion);
            }
        }
        if (ENABLE_TRACING) {
            grammar.enable_tracing();
        }
        return grammar;
    }

    public static Tuple<SimpleNode, IGrammar> reparseDocumentInternal(IDocument doc, boolean generateTree, int grammarVersion) throws ParseException {
        char[] charArray = PyParser.createCharArrayToParse(doc.get());
        IGrammar grammar = PyParser.createGrammar(generateTree, grammarVersion, charArray);
        return new Tuple((Object)grammar.file_input(), (Object)grammar);
    }

    public static Tuple<ISimpleNode, Throwable> reparseDocument(ParserInfo info) {
        Tuple returnVar;
        block13: {
            if (info.grammarVersion == 777) {
                IDocument doc = info.document;
                return PyParser.createCythonAst(doc);
            }
            String startDoc = info.document.get();
            if (startDoc.trim().length() == 0) {
                return new Tuple((Object)new Module(new stmtType[0]), null);
            }
            char[] charArray = PyParser.createCharArrayToParse(startDoc);
            startDoc = null;
            returnVar = new Tuple(null, null);
            IGrammar grammar = null;
            try {
                grammar = PyParser.createGrammar(info.generateTree, info.grammarVersion, charArray);
                SimpleNode newRoot = grammar.file_input();
                returnVar.o1 = newRoot;
                if (successfulParseListeners.size() > 0) {
                    Tuple3 param = new Tuple3((Object)((ISimpleNode)returnVar.o1), (Object)((Throwable)returnVar.o2), (Object)info);
                    for (ICallback<Object, Tuple3<ISimpleNode, Throwable, ParserInfo>> callback : successfulParseListeners) {
                        callback.call((Object)param);
                    }
                }
                returnVar.o2 = grammar.getErrorOnParsing();
            }
            catch (Throwable e) {
                if (DEBUG_SHOW_PARSE_ERRORS) {
                    e.printStackTrace();
                }
                if (grammar == null) {
                    throw new RuntimeException(e);
                }
                Throwable errorOnParsing = grammar.getErrorOnParsing();
                if (errorOnParsing != null) {
                    e = errorOnParsing;
                } else if (DEBUG_SHOW_PARSE_ERRORS) {
                    System.out.println("Unhandled error");
                    e.printStackTrace();
                }
                grammar = null;
                if (e instanceof ParseException || e instanceof TokenMgrError) {
                    returnVar = new Tuple(null, (Object)e);
                }
                if (e.getClass().getName().indexOf("LookaheadSuccess") != -1) break block13;
                Log.log((Throwable)e);
            }
        }
        if (DEBUG_SHOW_PARSE_ERRORS && returnVar.o1 == null) {
            System.out.println("Unable to parse " + info);
        }
        return returnVar;
    }

    public static Tuple<ISimpleNode, Throwable> createCythonAst(IDocument doc) {
        List<stmtType> classesAndFunctions = FastParser.parseCython(doc);
        return new Tuple((Object)new Module(classesAndFunctions.toArray(new stmtType[classesAndFunctions.size()])), null);
    }

    public static ErrorDescription createParserErrorMarkers(Throwable error, IAdaptable resource, IDocument doc) throws BadLocationException, CoreException {
        if (resource == null) {
            return null;
        }
        IResource fileAdapter = (IResource)resource.getAdapter(IResource.class);
        if (fileAdapter == null) {
            return null;
        }
        ErrorDescription errDesc = PyParser.createErrorDesc(error, doc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", errDesc.message);
        map.put("severity", 2);
        map.put("lineNumber", errDesc.errorLine);
        map.put("charStart", errDesc.errorStart);
        map.put("charEnd", errDesc.errorEnd);
        map.put("transient", true);
        MarkerUtilities.createMarker((IResource)fileAdapter, map, (String)"org.eclipse.core.resources.problemmarker");
        return errDesc;
    }

    private static ErrorDescription createErrorDesc(Throwable error, IDocument doc) throws BadLocationException {
        int errorStart = -1;
        int errorEnd = -1;
        int errorLine = -1;
        String message = null;
        if (error instanceof ParseException) {
            ParseException parseErr = (ParseException)error;
            if (parseErr.currentToken == null) {
                IRegion endLine = doc.getLineInformationOfOffset(doc.getLength());
                errorStart = endLine.getOffset();
                errorEnd = endLine.getOffset() + endLine.getLength();
            } else {
                Token errorToken = parseErr.currentToken.next != null ? parseErr.currentToken.next : parseErr.currentToken;
                IRegion startLine = doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.beginLine));
                IRegion endLine = errorToken.endLine == 0 ? startLine : doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.endLine));
                errorStart = startLine.getOffset() + PyParser.getDocPosFromAstPos(errorToken.beginColumn);
                errorEnd = endLine.getOffset() + errorToken.endColumn;
            }
            message = parseErr.getMessage();
        } else if (error instanceof TokenMgrError) {
            TokenMgrError tokenErr = (TokenMgrError)error;
            IRegion startLine = doc.getLineInformation(tokenErr.errorLine - 1);
            errorStart = startLine.getOffset();
            errorEnd = startLine.getOffset() + tokenErr.errorColumn;
            message = tokenErr.getMessage();
        } else {
            Log.log((String)("Error, expecting ParseException or TokenMgrError. Received: " + error));
            return new ErrorDescription(null, 0, 0, 0);
        }
        errorLine = doc.getLineOfOffset(errorStart);
        if (message != null) {
            message = message.replaceAll("\\r\\n", " ");
            message = message.replaceAll("\\r", " ");
            message = message.replaceAll("\\n", " ");
        }
        return new ErrorDescription(message, errorLine, errorStart, errorEnd);
    }

    private static int getDocPosFromAstPos(int astPos) {
        if (astPos > 0) {
            --astPos;
        }
        return astPos;
    }

    public static final class ParserInfo {
        public IDocument document;
        public final Set<Integer> linesChanged = new HashSet<Integer>();
        public final int grammarVersion;
        public final String moduleName;
        public final File file;
        public final boolean generateTree;

        public ParserInfo(IDocument document, int grammarVersion) {
            this(document, grammarVersion, null, null, true);
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider nature) throws MisconfigurationException {
            this(document, nature.getGrammarVersion());
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider nature, String moduleName, File file) throws MisconfigurationException {
            this(document, nature.getGrammarVersion(), moduleName, file, true);
        }

        public ParserInfo(IDocument document, int grammarVersion, String name, File f, boolean generateTree) {
            this.document = document;
            this.grammarVersion = grammarVersion;
            this.moduleName = name;
            this.file = f;
            this.generateTree = generateTree;
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider grammarProvider, boolean generateTree) throws MisconfigurationException {
            this(document, grammarProvider.getGrammarVersion(), null, null, generateTree);
        }

        public ParserInfo(IDocument document, int grammarVersion, boolean generateTree) {
            this(document, grammarVersion, null, null, generateTree);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("ParserInfo [");
            buf.append("file:");
            buf.append(this.file);
            buf.append("\nmoduleName:");
            buf.append(this.moduleName);
            if (!this.generateTree) {
                buf.append(" NOT GENERATING TREE");
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

