/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import org.python.pydev.shared_core.string.FastStringBuffer;

public class WrapAndCaseUtils {
    public static String wrap(String str, int wrapLength) {
        return WrapAndCaseUtils.wrap(str, wrapLength, null, false);
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        FastStringBuffer wrappedLine = new FastStringBuffer(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static String capitalize(String str) {
        return WrapAndCaseUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char[] delimiters) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int strLen = str.length();
        StringBuffer buffer = new StringBuffer(strLen);
        int delimitersLen = 0;
        if (delimiters != null) {
            delimitersLen = delimiters.length;
        }
        boolean capitalizeNext = true;
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            boolean isDelimiter = false;
            if (delimiters == null) {
                isDelimiter = Character.isWhitespace(ch);
            } else {
                int j = 0;
                while (j < delimitersLen) {
                    if (ch == delimiters[j]) {
                        isDelimiter = true;
                        break;
                    }
                    ++j;
                }
            }
            if (isDelimiter) {
                buffer.append(ch);
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String capitalizeFully(String str) {
        return WrapAndCaseUtils.capitalizeFully(str, null);
    }

    public static String capitalizeFully(String str, char[] delimiters) {
        if (str == null || str.length() == 0) {
            return str;
        }
        str = str.toLowerCase();
        return WrapAndCaseUtils.capitalize(str, delimiters);
    }

    public static String uncapitalize(String str) {
        return WrapAndCaseUtils.uncapitalize(str, null);
    }

    public static String uncapitalize(String str, char[] delimiters) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int strLen = str.length();
        int delimitersLen = 0;
        if (delimiters != null) {
            delimitersLen = delimiters.length;
        }
        StringBuffer buffer = new StringBuffer(strLen);
        boolean uncapitalizeNext = true;
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            boolean isDelimiter = false;
            if (delimiters == null) {
                isDelimiter = Character.isWhitespace(ch);
            } else {
                int j = 0;
                while (j < delimitersLen) {
                    if (ch == delimiters[j]) {
                        isDelimiter = true;
                        break;
                    }
                    ++j;
                }
            }
            if (isDelimiter) {
                buffer.append(ch);
                uncapitalizeNext = true;
            } else if (uncapitalizeNext) {
                buffer.append(Character.toLowerCase(ch));
                uncapitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String swapCase(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(strLen);
        boolean whitespace = true;
        char ch = '\u0000';
        char tmp = '\u0000';
        int i = 0;
        while (i < strLen) {
            ch = str.charAt(i);
            tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
            ++i;
        }
        return buffer.toString();
    }
}

