/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.IOException;
import java.io.Reader;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class FastBufferedReader {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected int availableSize;
    protected final char[] buf;
    protected int pos;
    protected Reader r;
    public final FastStringBuffer stringBuf;

    public FastBufferedReader(Reader r) {
        this(r, 16384);
    }

    public FastBufferedReader(Reader r, int bufSize) {
        this.r = r;
        this.buf = new char[bufSize];
        this.stringBuf = new FastStringBuffer(1024);
    }

    public void close() throws IOException {
        if (this.r == null) {
            return;
        }
        this.r.close();
        this.r = null;
    }

    public FastStringBuffer readLine() throws IOException {
        char c = '\u0000';
        this.stringBuf.clear();
        if (this.availableSize == 0) {
            this.availableSize = this.r.read(this.buf);
            if (this.availableSize <= 0) {
                this.availableSize = 0;
                return null;
            }
            this.pos = 0;
        }
        do {
            int i = 0;
            while (i < this.availableSize && (c = this.buf[this.pos + i]) != '\n' && c != '\r') {
                ++i;
            }
            this.stringBuf.append(this.buf, this.pos, i);
            this.pos += i;
            this.availableSize -= i;
            if (this.availableSize > 0) {
                if (c == '\n') {
                    ++this.pos;
                    --this.availableSize;
                } else if (this.availableSize > 1) {
                    if (this.buf[this.pos + 1] == '\n') {
                        this.pos += 2;
                        this.availableSize -= 2;
                    } else {
                        ++this.pos;
                        --this.availableSize;
                    }
                } else {
                    this.pos = 0;
                    this.availableSize = this.r.read(this.buf);
                    if (this.availableSize <= 0) {
                        this.availableSize = 0;
                    } else if (this.buf[0] == '\n') {
                        ++this.pos;
                        --this.availableSize;
                    }
                }
                return this.stringBuf;
            }
            this.pos = 0;
            this.availableSize = this.r.read(this.buf);
        } while (this.availableSize > 0);
        this.availableSize = 0;
        return this.stringBuf;
    }
}

