/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.dialogs;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class DialogMemento {
    private IDialogSettings fSettings;
    private Point fLocation;
    private Point fSize;
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";

    public DialogMemento(Shell parent, String dialogSettings) {
        IDialogSettings settings = SharedUiPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(dialogSettings);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(dialogSettings);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 480);
            this.fSettings.put(HEIGHT, 320);
        }
    }

    public Point getInitialSize(Point initialSize, Shell shell) {
        if (this.fSize != null) {
            initialSize.x = Math.max(initialSize.x, this.fSize.x);
            initialSize.y = Math.max(initialSize.y, this.fSize.y);
            Rectangle display = shell.getDisplay().getClientArea();
            initialSize.x = Math.min(initialSize.x, display.width);
            initialSize.y = Math.min(initialSize.y, display.height);
        }
        return initialSize;
    }

    public Point getInitialLocation(Point initialSize, Point initialLocation, Shell shell) {
        if (this.fLocation != null) {
            int ye;
            initialLocation.x = this.fLocation.x;
            initialLocation.y = this.fLocation.y;
            Rectangle display = shell.getDisplay().getClientArea();
            int xe = initialLocation.x + initialSize.x;
            if (xe > display.width) {
                initialLocation.x -= xe - display.width;
            }
            if ((ye = initialLocation.y + initialSize.y) > display.height) {
                initialLocation.y -= ye - display.height;
            }
        }
        return initialLocation;
    }

    public void readSettings() {
        try {
            int x = this.fSettings.getInt("x");
            int y = this.fSettings.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = this.fSettings.getInt(WIDTH);
            int height = this.fSettings.getInt(HEIGHT);
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
    }

    public void writeSettings(Shell shell) {
        Point location = shell.getLocation();
        this.fSettings.put("x", location.x);
        this.fSettings.put("y", location.y);
        Point size = shell.getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
    }
}

