/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import java.util.Iterator;
import org.python.pydev.shared_core.string.TextSelectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocIterator
implements Iterator<String> {
    private int startingLine;
    private boolean forward;
    private boolean isFirst = true;
    private int numberOfLines;
    private int lastReturnedLine = -1;
    private TextSelectionUtils ps;

    public DocIterator(boolean forward, TextSelectionUtils ps) {
        this(forward, ps, ps.getCursorLine(), true);
    }

    public DocIterator(boolean forward, TextSelectionUtils ps, int startingLine, boolean considerFirst) {
        this.startingLine = startingLine;
        this.forward = forward;
        this.numberOfLines = ps.getDoc().getNumberOfLines();
        this.ps = ps;
        if (!considerFirst) {
            this.isFirst = false;
        }
    }

    public int getCurrentLine() {
        return this.startingLine;
    }

    @Override
    public boolean hasNext() {
        if (this.forward) {
            return this.startingLine < this.numberOfLines;
        }
        return this.startingLine >= 0;
    }

    @Override
    public String next() {
        try {
            String line;
            if (this.forward) {
                line = this.ps.getLine(this.startingLine);
                this.lastReturnedLine = this.startingLine++;
            } else {
                if (this.isFirst) {
                    line = this.ps.getLineContentsToCursor();
                    this.isFirst = false;
                } else {
                    line = this.ps.getLine(this.startingLine);
                }
                this.lastReturnedLine = this.startingLine--;
            }
            return line;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove not implemented.");
    }

    public int getLastReturnedLine() {
        return this.lastReturnedLine;
    }
}

