/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParser;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_core.parsing.IParserObserver2;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.parsing.ParserScheduler;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParser
implements IParser {
    public static boolean ACCEPT_NULL_INPUT_EDITOR = false;
    protected volatile IDocument document;
    protected ISimpleNode root = null;
    protected IDocumentListener documentListener;
    protected ArrayList<IParserObserver> parserListeners = new ArrayList();
    protected ParserScheduler scheduler;
    protected boolean useAnalysisOnlyOnDocSave;
    protected volatile boolean disposed = false;
    protected Object input;

    protected BaseParser(BaseParserManager parseManager) {
        this.scheduler = new ParserScheduler(this, parseManager);
        this.documentListener = new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (BaseParser.this.useAnalysisOnlyOnDocSave) {
                    return;
                }
                String text = event.getText();
                boolean parseNow = true;
                if (event == null || text == null) {
                    parseNow = false;
                }
                if (parseNow && text.indexOf("\n") == -1 && text.indexOf("\r") == -1) {
                    parseNow = false;
                }
                if (!parseNow) {
                    BaseParser.this.scheduler.parseLater();
                } else {
                    BaseParser.this.scheduler.parseNow();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.disposed = true;
        this.scheduler.dispose();
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.clear();
        }
    }

    public ISimpleNode getRoot() {
        return this.root;
    }

    @Override
    public void notifySaved() {
        this.forceReparse(new Object[0]);
    }

    @Override
    public boolean forceReparse(Object ... argsToReparse) {
        if (this.disposed) {
            return true;
        }
        return this.scheduler.parseNow(true, argsToReparse);
    }

    @Override
    public void setDocument(IDocument document, Object input) {
        this.setDocument(document, true, input);
    }

    public synchronized void setDocument(IDocument doc, boolean addToScheduler, Object input) {
        this.input = input;
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = doc;
        if (doc == null) {
            Log.log("No document in PyParser::setDocument?");
            return;
        }
        doc.addDocumentListener(this.documentListener);
        if (addToScheduler) {
            this.scheduler.parseNow(true, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            if (!this.parserListeners.contains(listener)) {
                this.parserListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserChanged(ChangedParserInfoForObservers info) {
        ArrayList<IParserObserver> temp;
        this.root = info.root;
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            temp = new ArrayList<IParserObserver>(this.parserListeners);
        }
        for (IParserObserver l : temp) {
            try {
                if (l instanceof IParserObserver3) {
                    ((IParserObserver3)((Object)l)).parserChanged(info);
                    continue;
                }
                if (l instanceof IParserObserver2) {
                    ((IParserObserver2)((Object)l)).parserChanged(info.root, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                l.parserChanged(info.root, info.file, info.doc);
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserError(ErrorParserInfoForObservers info) {
        ArrayList<IParserObserver> temp;
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            temp = new ArrayList<IParserObserver>(this.parserListeners);
        }
        for (IParserObserver l : temp) {
            if (l instanceof IParserObserver3) {
                ((IParserObserver3)((Object)l)).parserError(info);
                continue;
            }
            if (l instanceof IParserObserver2) {
                ((IParserObserver2)((Object)l)).parserError(info.error, info.file, info.doc, info.argsToReparse);
                continue;
            }
            l.parserError(info.error, info.file, info.doc);
        }
    }

    @Override
    public abstract Tuple<ISimpleNode, Throwable> reparseDocument(Object ... var1);

    public static void deleteErrorMarkers(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        if (markers.length > 0) {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
    }

    @Override
    public void resetTimeoutPreferences(boolean useAnalysisOnlyOnDocSave) {
        this.useAnalysisOnlyOnDocSave = useAnalysisOnlyOnDocSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IParserObserver> getObservers() {
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            return new ArrayList<IParserObserver>(this.parserListeners);
        }
    }
}

