/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.refactoring.tdd.AbstractPyCreateClassOrMethodOrField;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyCreateClass
extends AbstractPyCreateClassOrMethodOrField {
    private static final String baseClassStr = "class %s(${object}):\n    ${pass}${cursor}\n\n\n";
    private static final String baseClassWithInitStr = "class %s(${object}):\n    \n    def __init__(self, %s):\n        ${pass}${cursor}\n\n\n";

    @Override
    public String getCreationStr() {
        return "class";
    }

    @Override
    public ICompletionProposal createProposal(RefactoringInfo refactoringInfo, String actTok, int locationStrategy, List<String> parametersAfterCall) {
        String source;
        PySelection pySelection = refactoringInfo.getPySelection();
        ModuleAdapter moduleAdapter = refactoringInfo.getModuleAdapter();
        if (parametersAfterCall == null || parametersAfterCall.size() == 0) {
            source = StringUtils.format((String)baseClassStr, (Object[])new Object[]{actTok});
        } else {
            FastStringBuffer params = PyCreateClass.createParametersList(parametersAfterCall);
            source = StringUtils.format((String)baseClassWithInitStr, (Object[])new Object[]{actTok, params});
        }
        Tuple<Integer, String> offsetAndIndent = this.getLocationOffset(locationStrategy, pySelection, moduleAdapter);
        return this.createProposal(pySelection, source, offsetAndIndent);
    }
}

