/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.actions.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.ModInfo;
import com.python.pydev.analysis.additionalinfo.NameInfo;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IMemento;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

public class InfoFactory {
    private static final String TAG_MODULE_NAME = "module_name";
    private static final String TAG_PATH = "path";
    private static final String TAG_NAME = "name";
    private static final String TAG_TYPE = "type";
    private static final String TAG_PROJECT_NAME = "project";
    private static final String TAG_MANAGER_IS_PYTHON = "is_python";
    private static final String TAG_MANAGER_INTERPRETER_TYPE = "interpreter_type";
    private static final String TAG_MANAGER_INTERPRETER = "interpreter";
    private AdditionalInfoAndIInfo info;

    public InfoFactory() {
    }

    public InfoFactory(AdditionalInfoAndIInfo input) {
        this.info = input;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdditionalInfoAndIInfo createElement(IMemento memento) {
        String[] attributeKeys = null;
        try {
            AbstractAdditionalDependencyInfo additionalInfo;
            Boolean isTagPython;
            void var11_17;
            attributeKeys = memento.getAttributeKeys();
            HashSet<String> keys = new HashSet<String>(Arrays.asList(attributeKeys));
            if (!keys.contains(TAG_NAME)) return null;
            if (!keys.contains(TAG_MODULE_NAME)) return null;
            if (!keys.contains(TAG_PATH)) return null;
            if (!keys.contains(TAG_TYPE)) {
                return null;
            }
            String name = memento.getString(TAG_NAME);
            String moduleName = memento.getString(TAG_MODULE_NAME);
            String path = memento.getString(TAG_PATH);
            int type = memento.getInteger(TAG_TYPE);
            String infoName = null;
            String infoModule = null;
            String infoPath = null;
            if (name != null && name.length() > 0) {
                infoName = name;
            }
            if (moduleName != null && moduleName.length() > 0) {
                infoModule = moduleName;
            }
            if (path != null && path.length() > 0) {
                infoPath = path;
            }
            if (type == 3) {
                AttrInfo attrInfo = new AttrInfo(infoName, infoModule, infoPath);
            } else if (type == 1) {
                ClassInfo classInfo = new ClassInfo(infoName, infoModule, infoPath);
            } else if (type == 2) {
                FuncInfo funcInfo = new FuncInfo(infoName, infoModule, infoPath);
            } else if (type == 4) {
                NameInfo nameInfo = new NameInfo(infoName, infoModule, infoPath);
            } else {
                if (type != 5) throw new AssertionError((Object)("Cannot restore type: " + type));
                ModInfo modInfo = new ModInfo(infoModule);
            }
            String projectName = null;
            if (keys.contains(TAG_PROJECT_NAME)) {
                projectName = memento.getString(TAG_PROJECT_NAME);
            }
            IInterpreterManager manager = null;
            if (projectName != null) {
                PythonNature nature;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && (nature = PythonNature.getPythonNature((IProject)project)) != null) {
                    try {
                        AbstractAdditionalDependencyInfo additionalInfo2 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
                        return new AdditionalInfoAndIInfo(additionalInfo2, (IInfo)var11_17);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            } else if (keys.contains(TAG_MANAGER_INTERPRETER_TYPE) && keys.contains(TAG_MANAGER_INTERPRETER)) {
                Integer interpreterType = memento.getInteger(TAG_MANAGER_INTERPRETER_TYPE);
                if (interpreterType != null) {
                    switch (interpreterType) {
                        case 0: {
                            manager = PydevPlugin.getPythonInterpreterManager();
                            break;
                        }
                        case 1: {
                            manager = PydevPlugin.getJythonInterpreterManager();
                            break;
                        }
                        case 2: {
                            manager = PydevPlugin.getIronpythonInterpreterManager();
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (keys.contains(TAG_MANAGER_IS_PYTHON) && keys.contains(TAG_MANAGER_INTERPRETER) && (isTagPython = memento.getBoolean(TAG_MANAGER_IS_PYTHON)) != null) {
                manager = isTagPython != false ? PydevPlugin.getPythonInterpreterManager() : PydevPlugin.getJythonInterpreterManager();
            }
            if (manager == null) return null;
            String interpreter = memento.getString(TAG_MANAGER_INTERPRETER);
            try {
                additionalInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter);
            }
            catch (Exception exception) {
                return null;
            }
            if (additionalInfo == null) return null;
            return new AdditionalInfoAndIInfo(additionalInfo, (IInfo)var11_17);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void saveState(IMemento memento) {
        if (this.info.info == null) {
            return;
        }
        String declaringModuleName = this.info.info.getDeclaringModuleName();
        if (declaringModuleName == null) {
            declaringModuleName = "";
        }
        memento.putString(TAG_MODULE_NAME, declaringModuleName);
        String path = this.info.info.getPath();
        if (path == null) {
            path = "";
        }
        memento.putString(TAG_PATH, path);
        String name = this.info.info.getName();
        if (name == null) {
            name = "";
        }
        memento.putString(TAG_NAME, name);
        memento.putString(TAG_TYPE, String.valueOf(this.info.info.getType()));
        if (this.info.additionalInfo instanceof AdditionalProjectInterpreterInfo) {
            AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)this.info.additionalInfo;
            memento.putString(TAG_PROJECT_NAME, projectInterpreterInfo.getProject().getName());
        } else if (this.info.additionalInfo instanceof AdditionalSystemInterpreterInfo) {
            AdditionalSystemInterpreterInfo systemInterpreterInfo = (AdditionalSystemInterpreterInfo)this.info.additionalInfo;
            IInterpreterManager manager = systemInterpreterInfo.getManager();
            memento.putInteger(TAG_MANAGER_INTERPRETER_TYPE, manager.getInterpreterType());
            memento.putString(TAG_MANAGER_INTERPRETER, systemInterpreterInfo.getAdditionalInfoInterpreter());
        }
    }
}

