/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui;

import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.Reflection;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleInterpreter;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ScriptConsoleHistory;
import org.python.pydev.shared_interactive_console.console.ScriptConsolePrompt;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleListener;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleSession;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsolePartitioner;
import org.python.pydev.shared_interactive_console.console.ui.internal.ICommandHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.IHandleScriptAutoEditStrategy;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsolePage;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleSession;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.AbstractHandleBackspaceAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptConsole
extends TextConsole
implements ICommandHandler {
    protected ScriptConsolePage page;
    protected ScriptConsolePartitioner partitioner;
    protected IScriptConsoleInterpreter interpreter;
    protected ScriptConsoleSession session;
    protected ListenerList consoleListeners;
    protected ScriptConsolePrompt prompt;
    protected ScriptConsoleHistory history;
    private WeakReference<ScriptConsoleViewer> viewer;
    private Color fPydevConsoleBackground;

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsole(String consoleName, String consoleType, IScriptConsoleInterpreter interpreterArg) {
        super(consoleName, consoleType, null, true);
        this.interpreter = interpreterArg;
        this.consoleListeners = new ListenerList(1);
        this.prompt = this.createConsolePrompt();
        this.history = new ScriptConsoleHistory();
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
    }

    protected abstract IContentAssistProcessor createConsoleCompletionProcessor(ContentAssistant var1);

    protected abstract IQuickAssistProcessor createConsoleQuickAssistProcessor(QuickAssistAssistant var1);

    protected abstract ITextHover createHover();

    protected abstract ScriptConsolePrompt createConsolePrompt();

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setInterpreter(IScriptConsoleInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        this.page = new ScriptConsolePage(this, view, this.createSourceViewerConfiguration());
        return this.page;
    }

    protected abstract SourceViewerConfiguration createSourceViewerConfiguration();

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    @Override
    public void handleCommand(String userInput, final ICallback<Object, InterpreterResponse> onResponseReceived, ICallback<Object, Tuple<String, String>> onContentsReceived) {
        Object[] listeners;
        Object[] objectArray = listeners = this.consoleListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IScriptConsoleListener)listener).userRequest(userInput, this.prompt);
            ++n2;
        }
        this.interpreter.exec(userInput, new ICallback<Object, InterpreterResponse>(){

            public Object call(InterpreterResponse response) {
                ScriptConsole.this.prompt.setMode(!response.more);
                ScriptConsole.this.prompt.setNeedInput(response.need_input);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IScriptConsoleListener)listener).interpreterResponse(response, ScriptConsole.this.prompt);
                    ++n2;
                }
                onResponseReceived.call((Object)response);
                return null;
            }
        }, onContentsReceived);
    }

    public void terminate() {
        try {
            this.interpreter.close();
        }
        catch (Exception exception) {}
        this.interpreter = null;
    }

    public void setViewer(ScriptConsoleViewer scriptConsoleViewer) {
        this.viewer = new WeakReference<ScriptConsoleViewer>(scriptConsoleViewer);
    }

    public ScriptConsoleViewer getViewer() {
        if (this.viewer != null) {
            return (ScriptConsoleViewer)this.viewer.get();
        }
        return null;
    }

    public abstract IConsoleStyleProvider createStyleProvider();

    public abstract List<IConsoleLineTracker> getLineTrackers();

    public abstract String getInitialCommands();

    public Color getPydevConsoleBackground() {
        try {
            Color ret = (Color)Reflection.invoke((Object)this, (String)"getBackground", (Object[])new Object[0]);
            return ret;
        }
        catch (Throwable throwable) {
            return this.fPydevConsoleBackground;
        }
    }

    public void setPydevConsoleBackground(Color color) {
        try {
            Reflection.invoke((Object)this, (String)"setBackground", (Object[])new Object[]{color});
        }
        catch (Throwable throwable) {
            this.fPydevConsoleBackground = color;
        }
    }

    public Object getInterpreterInfo() {
        return this.interpreter.getInterpreterInfo();
    }

    public abstract boolean getFocusOnStart();

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.interpreter.linkWithDebugSelection(isLinkedWithDebug);
    }

    public abstract AbstractHandleBackspaceAction getBackspaceAction();

    public abstract void createActions(IToolBarManager var1);

    public abstract IHandleScriptAutoEditStrategy getAutoEditStrategy();
}

