/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.net.LocalHost;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_interactive_console.console.IXmlRpcClient;

public class ScriptXmlRpcClient
implements IXmlRpcClient {
    private XmlRpcClient impl = new XmlRpcClient();
    private Process process;
    private ThreadStreamReader stdErrReader;
    private ThreadStreamReader stdOutReader;

    public ScriptXmlRpcClient(Process process, ThreadStreamReader stdErrReader, ThreadStreamReader stdOutReader) {
        this.process = process;
        this.stdErrReader = stdErrReader;
        this.stdOutReader = stdOutReader;
    }

    public void setPort(int port) throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL("http://" + LocalHost.getLocalHost() + ":" + port));
        this.impl.setConfig((XmlRpcClientConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String command, Object[] args) throws XmlRpcException {
        final Object[] result = new Object[1];
        this.impl.executeAsync(command, args, new AsyncCallback(){

            public void handleError(XmlRpcRequest request, Throwable error) {
                result[0] = new Object[]{error.getMessage()};
            }

            public void handleResult(XmlRpcRequest request, Object receivedResult) {
                result[0] = receivedResult;
            }
        });
        while (result[0] == null) {
            try {
                if (this.process == null) continue;
                String errStream = this.stdErrReader.getContents();
                if (errStream.indexOf("sys.exit called. Interactive console finishing.") != -1) {
                    result[0] = new Object[]{errStream};
                    break;
                }
                int exitValue = this.process.exitValue();
                result[0] = new Object[]{StringUtils.format((String)("Console already exited with value: %s while waiting for an answer.\nError stream: " + errStream + "\n" + "Output stream: " + this.stdOutReader.getContents()), (Object[])new Object[]{exitValue})};
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                ScriptXmlRpcClient scriptXmlRpcClient = this;
                synchronized (scriptXmlRpcClient) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return result[0];
    }
}

