/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractlocal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalRequestProcessor;
import org.python.pydev.refactoring.core.base.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.core.validator.NameValidator;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.utils.ListUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractLocalRefactoring
extends AbstractPythonRefactoring {
    private ExtractLocalRequestProcessor requestProcessor;

    public ExtractLocalRefactoring(RefactoringInfo info) {
        super(info);
        this.requestProcessor = new ExtractLocalRequestProcessor(info);
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ExtractLocalChangeProcessor changeProcessor = new ExtractLocalChangeProcessor(this.getName(), this.info, this.requestProcessor);
        return ListUtils.wrap(changeProcessor);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        LinkedList<Tuple> selections = new LinkedList<Tuple>();
        selections.add(new Tuple((Object)this.info.getUserSelection(), (Object)this.info.getParsedUserSelection()));
        selections.add(new Tuple((Object)this.info.getExtendedSelection(), (Object)this.info.getParsedExtendedSelection()));
        selections.add(new Tuple((Object)this.info.getUserSelection(), (Object)this.getParsedMultilineSelection(this.info.getUserSelection())));
        ITextSelection selection = null;
        exprType expression = null;
        for (Tuple s : selections) {
            if (s == null) continue;
            expression = this.extractExpression((ModuleAdapter)s.o2);
            selection = (ITextSelection)s.o1;
            if (expression != null) break;
        }
        if (expression == null) {
            this.status.addFatalError(Messages.extractLocalNoExpressionSelected);
        }
        AbstractScopeNode<?> scopeAdapter = this.info.getModuleAdapter().getScopeAdapter(selection);
        this.requestProcessor.setDuplicates(scopeAdapter.getDuplicates(selection, expression));
        this.requestProcessor.setSelection(selection);
        this.requestProcessor.setExpression(expression);
        return this.status;
    }

    private ModuleAdapter getParsedMultilineSelection(ITextSelection selection) {
        String source = selection.getText();
        source = source.replaceAll("\n", "");
        source = source.replaceAll("\r", "");
        try {
            ModuleAdapter node = VisitorFactory.createModuleAdapter(null, null, (IDocument)new Document(source), null, this.info.getVersionProvider());
            return node;
        }
        catch (TokenMgrError tokenMgrError) {
            return null;
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    private exprType extractExpression(ModuleAdapter node) {
        if (node == null) {
            return null;
        }
        Module astNode = (Module)node.getASTNode();
        if (astNode == null) {
            return null;
        }
        stmtType[] body = astNode.body;
        if (body.length > 0 && body[0] instanceof Expr) {
            Expr expr = (Expr)body[0];
            return expr.value;
        }
        return null;
    }

    public String getName() {
        return Messages.extractLocalLabel;
    }

    public ExtractLocalRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    public RefactoringStatus checkVarName(String variableName) {
        RefactoringStatus status = new RefactoringStatus();
        NameValidator nameValidator = new NameValidator(status, this.info.getScopeAdapter());
        nameValidator.validateVariableName(variableName);
        nameValidator.validateUniqueVariable(variableName);
        return status;
    }
}

