/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.rewriter;

import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;

public final class Rewriter {
    public static String reparsed(String source, AdapterPrefs adapterPrefs) {
        try {
            SimpleNode root = VisitorFactory.getRootNodeFromString(source, adapterPrefs.versionProvider);
            return Rewriter.createSourceFromAST(root, adapterPrefs);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String createSourceFromAST(SimpleNode root, AdapterPrefs adapterPrefs) {
        return Rewriter.createSourceFromAST(root, false, adapterPrefs);
    }

    public static String createSourceFromAST(SimpleNode root, String endLineDelim, IGrammarVersionProvider versionProvider) {
        return Rewriter.createSourceFromAST(root, false, new AdapterPrefs(endLineDelim, versionProvider));
    }

    public static String createSourceFromAST(SimpleNode root, boolean ignoreComments, AdapterPrefs adapterPrefs) {
        IGrammarVersionProvider versionProvider = adapterPrefs.versionProvider;
        IIndentPrefs indentPrefs = DefaultIndentPrefs.get();
        String endLineDelim = adapterPrefs.endLineDelim;
        PrettyPrinterPrefsV2 prettyPrinterPrefs = PrettyPrinterV2.createDefaultPrefs((IGrammarVersionProvider)versionProvider, (IIndentPrefs)indentPrefs, (String)endLineDelim);
        PrettyPrinterV2 printer = new PrettyPrinterV2((IPrettyPrinterPrefs)prettyPrinterPrefs);
        try {
            return printer.print(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

