/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.debug.ui.launching.PythonRunner;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.EditorUtils;

public abstract class AbstractLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private IProject[] fOrderedProjects;

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject project;
        this.fOrderedProjects = null;
        String projName = configuration.getAttribute("org.python.pydev.debug.ATTR_PROJECT", "");
        if (projName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName)) != null) {
            this.fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{project});
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Preparing configuration", 3);
        try {
            PythonRunnerConfig runConfig = new PythonRunnerConfig(conf, mode, this.getRunnerConfigRun(conf, mode, launch));
            monitor.worked(1);
            try {
                PythonRunner.run(runConfig, launch, monitor);
            }
            catch (IOException e) {
                Log.log((Throwable)e);
                this.finishLaunchWithError(launch);
                throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected IO Exception in Pydev debugger", null));
            }
        }
        catch (InvalidRunException e) {
            this.handleError(launch, e);
        }
        catch (MisconfigurationException e) {
            this.handleError(launch, (Exception)((Object)e));
        }
    }

    private void handleError(ILaunch launch, final Exception e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Invalid launch configuration", (String)"Unable to make launch because launch configuration is not valid", (IStatus)PydevPlugin.makeStatus((int)4, (String)e.getMessage(), (Throwable)e));
            }
        });
        this.finishLaunchWithError(launch);
    }

    private void finishLaunchWithError(ILaunch launch) {
        try {
            launch.terminate();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        catch (Throwable x) {
            Log.log((Throwable)x);
        }
    }

    protected abstract String getRunnerConfigRun(ILaunchConfiguration var1, String var2, ILaunch var3);
}

