/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.ui.actions.AbstractBreakpointRulerAction;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public static final String PYDEV_BREAKPOINT = "PyDev breakpoint";
    private List<IMarker> fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;

    public PyBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo ruler) {
        this.setInfo(ruler);
        this.setTextEditor(editor);
        this.setText("Breakpoint &Properties...");
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getMarkersFromCurrentFile(true);
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            PyBreakpointRulerAction.removeMarkers(this.fMarkers);
        }
    }

    protected void addMarker() {
        IDocument document = this.getDocument();
        int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
        PyBreakpointRulerAction.addBreakpointMarker(document, rulerLine + 1, this.fTextEditor);
    }

    public static void addBreakpointMarker(IDocument document, int lineNumber, ITextEditor textEditor) {
        try {
            File file;
            if (lineNumber < 0) {
                return;
            }
            try {
                document.getLineInformation(lineNumber - 1);
            }
            catch (Exception exception) {
                return;
            }
            final IResource resource = PyMarkerUtils.getResourceForTextEditor((ITextEditor)textEditor);
            final HashMap<String, Object> map = new HashMap<String, Object>();
            IEditorInput externalFileEditorInput = PyBreakpointRulerAction.getExternalFileEditorInput(textEditor);
            if (externalFileEditorInput == null && resource instanceof IWorkspaceRoot) {
                return;
            }
            map.put("message", PYDEV_BREAKPOINT);
            map.put("lineNumber", new Integer(lineNumber));
            map.put("org.eclipse.debug.core.enabled", new Boolean(true));
            map.put("org.eclipse.debug.core.id", PyDebugModelPresentation.PY_DEBUG_MODEL_ID);
            if (externalFileEditorInput != null && (file = PydevFileEditorInput.getFile((IEditorInput)externalFileEditorInput)) != null) {
                map.put("org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID", FileUtils.getFileAbsolutePath((File)file));
            }
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = resource.createMarker("org.python.pydev.debug.pyStopBreakpointMarker");
                    marker.setAttributes(map);
                    PyBreakpoint br = new PyBreakpoint();
                    br.setMarker(marker);
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    breakpointManager.addBreakpoint((IBreakpoint)br);
                }
            };
            resource.getWorkspace().run(runnable, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static void removeMarkers(List<IMarker> markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator<IMarker> e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint(e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, "error removing markers", e);
        }
    }
}

