/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.pyunit.HistoryAction;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.PydevPlugin;

public class RelaunchInBackgroundAction
extends Action
implements IResourceChangeListener {
    private WeakReference<PyUnitView> view;
    RelaunchJob relaunchJob = new RelaunchJob();
    private boolean listeningChanges;

    public RelaunchInBackgroundAction(PyUnitView pyUnitView) {
        this.view = new WeakReference<PyUnitView>(pyUnitView);
        this.setMenuCreator(new RelaunchInBackgroundOptionsMenuCreator());
        this.listeningChanges = false;
        this.setImageDescriptor(PydevPlugin.getImageCache().getDescriptor("icons/relaunch_background_disabled.png"));
        this.setInitialTooltipText();
    }

    private void setInitialTooltipText() {
        this.setToolTipText("Click to rerun the current test suite whenever any Python file changes.\n\nNote that a new run will only be done after the current test run finishes.");
    }

    private void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void run() {
        boolean bl = this.listeningChanges = !this.listeningChanges;
        if (this.listeningChanges) {
            this.setImageDescriptor(PydevPlugin.getImageCache().getDescriptor("icons/relaunch_background_enabled.png"));
            this.startListening();
        } else {
            this.setImageDescriptor(PydevPlugin.getImageCache().getDescriptor("icons/relaunch_background_disabled.png"));
            this.stopListening();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        PyUnitTestRun currentTestRun;
        if (this.view == null) {
            this.stopListening();
            return;
        }
        PyUnitView pyUnitView = (PyUnitView)((Object)this.view.get());
        if (pyUnitView == null) {
            this.stopListening();
            return;
        }
        final boolean[] run = new boolean[1];
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    switch (delta.getKind()) {
                        case 4: {
                            int flags;
                            IResource resource = delta.getResource();
                            if (!(resource instanceof IFile) || !PythonPathHelper.isValidSourceFile((IFile)((IFile)resource)) || ((flags = delta.getFlags()) & 0x100) == 0) break;
                            run[0] = true;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        if (run[0] && (currentTestRun = pyUnitView.getCurrentTestRun()) != null) {
            this.relaunchJob.setTestToRun(currentTestRun);
            this.relaunchJob.schedule(200L);
        }
    }

    public class RelaunchInBackgroundOptionsMenuCreator
    implements IMenuCreator {
        private Menu fMenu;

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(final IMenuManager manager2) {
                    RelaunchInBackgroundOptionsMenuCreator.this.fillMenuManager(new HistoryAction.IActionsMenu(){

                        public void add(IAction action) {
                            manager2.add(action);
                        }
                    });
                }
            });
            this.fMenu = manager.createContextMenu(parent);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void fillMenuManager(HistoryAction.IActionsMenu actionsMenu) {
            actionsMenu.add((IAction)new RelaunchOnlyErrorsOnBackgroundRelaunch());
        }
    }

    private final class RelaunchJob
    extends Job {
        private PyUnitTestRun currentTestRun;

        private RelaunchJob() {
            super("Relaunch test suite");
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.currentTestRun.getFinished()) {
                this.schedule(300L);
                return Status.OK_STATUS;
            }
            if (PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("PYUNIT_VIEW_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS")) {
                this.currentTestRun.relaunchOnlyErrors();
            } else {
                this.currentTestRun.relaunch();
            }
            return Status.OK_STATUS;
        }

        public void setTestToRun(PyUnitTestRun currentTestRun) {
            this.currentTestRun = currentTestRun;
        }
    }

    private class RelaunchOnlyErrorsOnBackgroundRelaunch
    extends Action {
        public RelaunchOnlyErrorsOnBackgroundRelaunch() {
            this.setText("Run only failed tests when relaunching due to file changes?");
            this.setToolTipText("If checked, a relaunch will relaunch only the errors in the current test run.\n\nIf no errors are found, the full test suite is run again.");
            this.setChecked(PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("PYUNIT_VIEW_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS"));
        }

        public void run() {
            PydevDebugPlugin.getDefault().getPreferenceStore().setValue("PYUNIT_VIEW_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS", this.isChecked());
        }
    }
}

