/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ListenerList;
import org.python.pydev.debug.core.ConfigureExceptionsFileUtils;
import org.python.pydev.debug.model.IExceptionsBreakpointListener;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.interpreters.ChooseInterpreterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyExceptionBreakPointManager {
    private static final String EXCEPTION_FILE_NAME = "python_exceptions.prefs";
    private static final String CUSTOM_EXCEPTION_FILE_NAME = "custom_exceptions.prefs";
    private static final String BREAK_ON_CAUGHT_EXCEPTION = "caught_exception_state.prefs";
    private static final String BREAK_ON_UNCAUGHT_EXCEPTION = "uncaught_exception_state.prefs";
    private static PyExceptionBreakPointManager pyExceptionBreakPointManager;
    private static final Object lock;
    private ListenerList<IExceptionsBreakpointListener> listeners = new ListenerList(IExceptionsBreakpointListener.class);

    static {
        lock = new Object();
    }

    private PyExceptionBreakPointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyExceptionBreakPointManager getInstance() {
        if (pyExceptionBreakPointManager == null) {
            Object object = lock;
            synchronized (object) {
                if (pyExceptionBreakPointManager == null) {
                    pyExceptionBreakPointManager = new PyExceptionBreakPointManager();
                }
            }
        }
        return pyExceptionBreakPointManager;
    }

    public void addListener(IExceptionsBreakpointListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IExceptionsBreakpointListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setBreakOn(boolean breakOnCaught, boolean breakOnUncaught, String[] exceptionArray) {
        ConfigureExceptionsFileUtils.writeToFile(BREAK_ON_CAUGHT_EXCEPTION, Boolean.toString(breakOnCaught), false);
        ConfigureExceptionsFileUtils.writeToFile(BREAK_ON_UNCAUGHT_EXCEPTION, Boolean.toString(breakOnUncaught), false);
        String pyExceptionsStr = StringUtils.join((String)ConfigureExceptionsFileUtils.DELIMITER, (String[])exceptionArray);
        ConfigureExceptionsFileUtils.writeToFile(EXCEPTION_FILE_NAME, pyExceptionsStr, false);
        IExceptionsBreakpointListener[] iExceptionsBreakpointListenerArray = (IExceptionsBreakpointListener[])this.listeners.getListeners();
        int n = iExceptionsBreakpointListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionsBreakpointListener listener = iExceptionsBreakpointListenerArray[n2];
            listener.onSetConfiguredExceptions();
            ++n2;
        }
    }

    public void addUserConfiguredException(String userConfiguredException) {
        boolean isAppend = false;
        IPath path = ConfigureExceptionsFileUtils.getFilePathFromMetadata(CUSTOM_EXCEPTION_FILE_NAME);
        if (path.toFile().exists()) {
            isAppend = true;
            userConfiguredException = String.valueOf(ConfigureExceptionsFileUtils.DELIMITER) + userConfiguredException;
        }
        ConfigureExceptionsFileUtils.writeToFile(CUSTOM_EXCEPTION_FILE_NAME, userConfiguredException, isAppend);
    }

    public String getBreakOnUncaughtExceptions() {
        return ConfigureExceptionsFileUtils.readFromMetadataFile(BREAK_ON_UNCAUGHT_EXCEPTION);
    }

    public String getBreakOnCaughtExceptions() {
        return ConfigureExceptionsFileUtils.readFromMetadataFile(BREAK_ON_CAUGHT_EXCEPTION);
    }

    public String getExceptionsString() {
        return ConfigureExceptionsFileUtils.readFromMetadataFile(EXCEPTION_FILE_NAME);
    }

    public List<String> getExceptionsList() {
        return ConfigureExceptionsFileUtils.getConfiguredExceptions(EXCEPTION_FILE_NAME);
    }

    public List<String> getUserConfiguredExceptions() {
        List<String> configuredExceptions = ConfigureExceptionsFileUtils.getConfiguredExceptions(CUSTOM_EXCEPTION_FILE_NAME);
        Collections.sort(configuredExceptions);
        return configuredExceptions;
    }

    public List<String> getBuiltinExceptions() {
        ArrayList<String> list = new ArrayList<String>();
        IInterpreterManager useManager = ChooseInterpreterManager.chooseInterpreterManager();
        if (useManager != null) {
            IToken[] pythonTokens;
            IToken[] iTokenArray = pythonTokens = useManager.getBuiltinMod("Default").getGlobalTokens();
            int n = pythonTokens.length;
            int n2 = 0;
            while (n2 < n) {
                IToken token = iTokenArray[n2];
                String pyToken = token.getRepresentation();
                String lower = pyToken.toLowerCase();
                if (lower.contains("error") || lower.contains("exception") || lower.contains("warning")) {
                    list.add(pyToken.trim());
                }
                ++n2;
            }
            Collections.sort(list);
        }
        return list;
    }
}

