/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.tooltips.presenter.StyleRangeWithCustomData;
import org.python.pydev.debug.codecoverage.FileNode;
import org.python.pydev.debug.codecoverage.PyCoverage;
import org.python.pydev.debug.codecoverage.PyCoveragePreferences;
import org.python.pydev.debug.codecoverage.RemoveCoverageMarkersListener;
import org.python.pydev.debug.ui.launching.PythonRunnerCallbacks;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.FontUtils;
import org.python.pydev.shared_ui.tree.PyFilteredTree;
import org.python.pydev.shared_ui.utils.IViewWithControls;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.tree.AllowValidPathsFilter;
import org.python.pydev.tree.FileTreeLabelProvider;
import org.python.pydev.tree.FileTreePyFilesProvider;
import org.python.pydev.ui.IViewCreatedObserver;
import org.python.pydev.ui.ViewPartWithOrientation;
import org.python.pydev.utils.ProgressAction;
import org.python.pydev.utils.ProgressOperation;

public class PyCodeCoverageView
extends ViewPartWithOrientation
implements IViewWithControls {
    public static final String PYCOVERAGE_VIEW_ORIENTATION = "PYCOVERAGE_VIEW_ORIENTATION";
    public static String PY_COVERAGE_VIEW_ID = "org.python.pydev.views.PyCodeCoverageView";
    private Composite leftComposite;
    private DoubleClickTreeAction doubleClickAction = new DoubleClickTreeAction();
    private SelectionChangedTreeAction selectionChangedAction = new SelectionChangedTreeAction();
    private ProgressAction chooseAction = new ChooseAction();
    protected Action openCoverageFolderAction = new OpenCoverageFolderAction();
    protected ProgressAction clearAction = new ClearAction();
    protected Action selectColumnsAction = new SelectColumnsAction();
    protected RefreshAction refreshAction = new RefreshAction();
    private Button chooseButton;
    private StyledText text;
    private TreeViewer viewer;
    private SashForm sash;
    Button allRunsGoThroughCoverage;
    Button clearCoverageInfoOnNextLaunch;
    Button refreshCoverageInfoOnNextLaunch;
    private Label labelErrorFolderNotSelected;
    private final ICallbackListener<Process> afterCreatedProcessListener = new ICallbackListener<Process>(){

        public Object call(final Process obj) {
            if (PyCodeCoverageView.this.viewer == null) {
                return null;
            }
            new Thread(){

                public void run() {
                    boolean finished = false;
                    while (!finished) {
                        try {
                            obj.waitFor();
                            finished = true;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (PyCoveragePreferences.getRefreshAfterNextLaunch()) {
                        RunInUiThread.async((Runnable)new Runnable(){

                            public void run() {
                                ProgressOperation.startAction((Shell)PyCodeCoverageView.this.getSite().getShell(), (ProgressAction)((this).this).PyCodeCoverageView.this.refreshAction, (boolean)true);
                            }
                        });
                    }
                }
            }.start();
            return null;
        }
    };
    private final ICallbackListener<PythonRunnerCallbacks.CreatedCommandLineParams> onCreatedCommandLineListener = new ICallbackListener<PythonRunnerCallbacks.CreatedCommandLineParams>(){

        public Object call(PythonRunnerCallbacks.CreatedCommandLineParams arg) {
            if (PyCodeCoverageView.this.viewer == null) {
                return null;
            }
            if (arg.coverageRun && PyCoveragePreferences.getClearCoverageInfoOnNextLaunch()) {
                try {
                    PyCoverage.getPyCoverage().clearInfo();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };
    private File lastSelectedFile;
    public static final String PYDEV_COVERAGE_MARKER = "org.python.pydev.debug.pydev_coverage_marker";

    public String getOrientationPreferencesKey() {
        return PYCOVERAGE_VIEW_ORIENTATION;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    void executeRefreshAction(IProgressMonitor monitor) {
        StructuredSelection current;
        Object firstElement;
        IContainer lastChosenDir;
        if (this.viewer == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((lastChosenDir = PyCoveragePreferences.getLastChosenDir()) == null) {
            return;
        }
        PyCoverage.getPyCoverage().refreshCoverageInfo(lastChosenDir, monitor);
        File input = lastChosenDir.getLocation().toFile();
        this.viewer.refresh();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof StructuredSelection && (firstElement = (current = (StructuredSelection)selection).getFirstElement()) != null) {
            this.onSelectedFileInTree(firstElement);
            return;
        }
        Object[] children = contentProvider.getChildren((Object)input);
        if (children.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(children[0]));
        } else {
            this.onSelectedFileInTree(null);
        }
    }

    public static IContainer getChosenDir() {
        return PyCoveragePreferences.getLastChosenDir();
    }

    private void onSelectedFileInTree(Object obj) {
        if (obj == null) {
            this.text.setText("");
        } else {
            File realFile = new File(obj.toString());
            if (realFile.exists()) {
                this.lastSelectedFile = realFile;
                Tuple<String, List<StyleRange>> statistics = PyCoverage.getPyCoverage().cache.getStatistics(realFile.toString(), realFile);
                this.text.setText((String)statistics.o1);
                this.text.setStyleRanges(((List)statistics.o2).toArray(new StyleRange[((List)statistics.o2).size()]));
            } else {
                this.text.setText("Selection no longer exists in disk: " + obj.toString());
            }
        }
    }

    public void setSelectedContainer(IContainer container) {
        this.lastSelectedFile = null;
        PyCoveragePreferences.setLastChosenDir(container);
        this.updateErrorMessages();
        File input = container.getLocation().toFile();
        this.viewer.setInput((Object)input);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        Object[] children = contentProvider.getChildren((Object)input);
        if (children.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(children[0]));
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection());
        }
        ProgressOperation.startAction((Shell)this.getSite().getShell(), (ProgressAction)this.refreshAction, (boolean)true);
    }

    public PyCodeCoverageView() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_view_created_observer");
        for (IViewCreatedObserver iViewCreatedObserver : participants) {
            iViewCreatedObserver.notifyViewCreated((IViewWithControls)this);
        }
    }

    public void refresh() {
        this.viewer.refresh();
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    protected void setNewOrientation(int orientation) {
        if (this.sash != null && !this.sash.isDisposed() && this.fParent != null && !this.fParent.isDisposed()) {
            GridLayout layout = (GridLayout)this.fParent.getLayout();
            if (orientation == 1) {
                this.sash.setOrientation(256);
                layout.numColumns = 2;
            } else {
                this.sash.setOrientation(512);
                layout.numColumns = 1;
            }
            this.fParent.layout();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.sash = new SashForm(parent, 256);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.sash.setLayoutData((Object)layoutData);
        parent = this.sash;
        this.leftComposite = new Composite(parent, 2);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.leftComposite.setLayoutData((Object)layoutData);
        this.leftComposite.setLayout((Layout)layout);
        this.text = new StyledText(parent, 2818);
        this.onControlCreated.call((Object)this.text);
        try {
            this.text.setFont(new Font(null, FontUtils.getFontData((int)2, (boolean)false)));
        }
        catch (Exception exception) {}
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int offset;
                try {
                    offset = PyCodeCoverageView.this.text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                StyleRange r = PyCodeCoverageView.this.text.getStyleRangeAtOffset(offset);
                if (r instanceof StyleRangeWithCustomData) {
                    StyleRangeWithCustomData styleRangeWithCustomData = (StyleRangeWithCustomData)r;
                    Object o = styleRangeWithCustomData.customData;
                    if (o instanceof FileNode) {
                        FileNode fileNode = (FileNode)o;
                        if (fileNode.node != null && fileNode.node.exists()) {
                            PyCodeCoverageView.this.openFileWithCoverageMarkers(fileNode.node);
                        }
                    }
                }
            }
        });
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        parent = this.leftComposite;
        this.allRunsGoThroughCoverage = new Button(parent, 32);
        this.allRunsGoThroughCoverage.setText("Enable code coverage for new launches?");
        this.allRunsGoThroughCoverage.setSelection(PyCoveragePreferences.getInternalAllRunsDoCoverage());
        this.allRunsGoThroughCoverage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyCoveragePreferences.setInternalAllRunsDoCoverage(PyCodeCoverageView.this.allRunsGoThroughCoverage.getSelection());
                PyCodeCoverageView.this.updateErrorMessages();
            }
        });
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.horizontalSpan = 2;
        this.allRunsGoThroughCoverage.setLayoutData((Object)layoutData);
        this.clearCoverageInfoOnNextLaunch = new Button(parent, 32);
        this.clearCoverageInfoOnNextLaunch.setText("Auto clear on a new launch?");
        this.clearCoverageInfoOnNextLaunch.setSelection(PyCoveragePreferences.getClearCoverageInfoOnNextLaunch());
        this.clearCoverageInfoOnNextLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyCoveragePreferences.setClearCoverageInfoOnNextLaunch(PyCodeCoverageView.this.clearCoverageInfoOnNextLaunch.getSelection());
            }
        });
        PythonRunnerCallbacks.onCreatedCommandLine.registerListener(this.onCreatedCommandLineListener);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.clearCoverageInfoOnNextLaunch.setLayoutData((Object)layoutData);
        Button button = new Button(parent, 8);
        button.setText("Clear");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressOperation.startAction((Shell)PyCodeCoverageView.this.getSite().getShell(), (ProgressAction)PyCodeCoverageView.this.clearAction, (boolean)true);
            }
        });
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = false;
        layoutData.widthHint = 50;
        layoutData.horizontalAlignment = 3;
        button.setLayoutData((Object)layoutData);
        this.refreshCoverageInfoOnNextLaunch = new Button(parent, 32);
        this.refreshCoverageInfoOnNextLaunch.setText("Auto refresh on new launch?");
        this.refreshCoverageInfoOnNextLaunch.setSelection(PyCoveragePreferences.getRefreshAfterNextLaunch());
        this.refreshCoverageInfoOnNextLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyCoveragePreferences.setRefreshAfterNextLaunch(PyCodeCoverageView.this.refreshCoverageInfoOnNextLaunch.getSelection());
            }
        });
        PythonRunnerCallbacks.afterCreatedProcess.registerListener(this.afterCreatedProcessListener);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.refreshCoverageInfoOnNextLaunch.setLayoutData((Object)layoutData);
        button = new Button(parent, 8);
        button.setText("Refresh");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressOperation.startAction((Shell)PyCodeCoverageView.this.getSite().getShell(), (ProgressAction)PyCodeCoverageView.this.refreshAction, (boolean)true);
            }
        });
        layoutData = new GridData();
        layoutData.widthHint = 50;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 3;
        button.setLayoutData((Object)layoutData);
        this.chooseButton = new Button(parent, 8);
        this.createButton(parent, this.chooseButton, "Choose folder to analyze", this.chooseAction);
        PatternFilter patternFilter = new PatternFilter();
        PyFilteredTree filter = PyFilteredTree.create((Composite)parent, (PatternFilter)patternFilter, (boolean)true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalSpan = 2;
        filter.setLayoutData((Object)layoutData);
        this.viewer = filter.getViewer();
        this.onControlCreated.call((Object)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new FileTreePyFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.viewer.addFilter((ViewerFilter)new AllowValidPathsFilter());
        this.hookViewerActions();
        Tree tree = (Tree)this.viewer.getControl();
        TreeItem item = new TreeItem(tree, 0);
        item.setText("Altenatively, to select a folder, drag it to this area.");
        item = new TreeItem(tree, 0);
        item = new TreeItem(tree, 0);
        item.setText("Note: Only the sources under the folder selected");
        item = new TreeItem(tree, 0);
        item.setText("will have coverage information collected.");
        int operations = 19;
        DropTarget target = new DropTarget((Control)tree, operations);
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                while (i < event.dataTypes.length) {
                    if (fileTransfer.isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        if (event.detail == 1) break;
                        event.detail = 0;
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                if (fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
                    event.detail = 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                PySourceLocatorBase locator;
                IContainer container;
                File file;
                String[] files;
                if (fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length == 1 && (file = new File(files[0])).isDirectory() && (container = (locator = new PySourceLocatorBase()).getWorkspaceContainer(file)) != null && container.exists()) {
                    PyCodeCoverageView.this.setSelectedContainer(container);
                }
            }
        });
        this.configureToolbar();
        this.updateErrorMessages();
    }

    private void configureToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.selectColumnsAction);
        if (FileUtils.getSupportsOpenDirectory()) {
            menuManager.add((IAction)this.openCoverageFolderAction);
        }
        this.addOrientationPreferences(menuManager);
    }

    private void createButton(Composite parent, Button button, String txt, final ProgressAction action) {
        button.setText(txt);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgressOperation.startAction((Shell)PyCodeCoverageView.this.getSite().getShell(), (ProgressAction)action, (boolean)true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.horizontalSpan = 2;
        button.setLayoutData((Object)layoutData);
    }

    private void hookViewerActions() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PyCodeCoverageView.this.doubleClickAction.runWithEvent(event);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PyCodeCoverageView.this.selectionChangedAction.runWithEvent(event);
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        try {
            PythonRunnerCallbacks.afterCreatedProcess.unregisterListener(this.afterCreatedProcessListener);
            PythonRunnerCallbacks.onCreatedCommandLine.unregisterListener(this.onCreatedCommandLineListener);
            PyCoveragePreferences.setInternalAllRunsDoCoverage(false);
            PyCoveragePreferences.setLastChosenDir(null);
            if (this.text != null) {
                this.onControlDisposed.call((Object)this.text);
                this.text.dispose();
                this.text = null;
            }
            if (this.viewer != null) {
                this.onControlDisposed.call((Object)this.viewer);
                this.viewer.getTree().dispose();
                this.viewer = null;
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        super.dispose();
    }

    private void updateErrorMessages() {
        boolean showError = false;
        if (PyCoveragePreferences.getInternalAllRunsDoCoverage() && PyCoveragePreferences.getLastChosenDir() == null) {
            showError = true;
        }
        if (showError) {
            if (this.labelErrorFolderNotSelected == null) {
                this.labelErrorFolderNotSelected = new Label(this.leftComposite, 0);
                this.labelErrorFolderNotSelected.setForeground(PydevPlugin.getColorCache().getColor("RED"));
                this.labelErrorFolderNotSelected.setText("Folder must be selected for launching with coverage.");
                GridData layoutData = new GridData();
                layoutData.grabExcessHorizontalSpace = true;
                layoutData.horizontalSpan = 2;
                layoutData.horizontalAlignment = 4;
                this.labelErrorFolderNotSelected.setLayoutData((Object)layoutData);
            }
        } else if (this.labelErrorFolderNotSelected != null) {
            this.labelErrorFolderNotSelected.dispose();
            this.labelErrorFolderNotSelected = null;
        }
        this.leftComposite.layout();
    }

    public static PyCodeCoverageView getView(boolean createIfNotThere) {
        IWorkbenchWindow workbenchWindow;
        block5: {
            workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null) break block5;
            return null;
        }
        try {
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (createIfNotThere) {
                return (PyCodeCoverageView)page.showView(PY_COVERAGE_VIEW_ID, null, 1);
            }
            IViewReference viewReference = page.findViewReference(PY_COVERAGE_VIEW_ID);
            if (viewReference != null) {
                return (PyCodeCoverageView)viewReference.getView(false);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public String getCoverageText() {
        return this.text.getText();
    }

    private void openFileWithCoverageMarkers(File realFile) {
        IEditorPart editor = PyOpenEditor.doOpenEditor((File)realFile);
        if (editor instanceof PyEdit) {
            IFile original;
            PyEdit e = (PyEdit)editor;
            IEditorInput input = e.getEditorInput();
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original == null) {
                return;
            }
            final IDocument document = e.getDocumentProvider().getDocument((Object)e.getEditorInput());
            new RemoveCoverageMarkersListener(document, e, original);
            final FileNode cache = (FileNode)PyCoverage.getPyCoverage().cache.getFile(realFile);
            if (cache != null) {
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            original.deleteMarkers(PyCodeCoverageView.PYDEV_COVERAGE_MARKER, false, 1);
                        }
                        catch (CoreException e1) {
                            Log.log((Throwable)e1);
                        }
                        Iterator<Tuple<Integer, Integer>> it = cache.notExecutedIterator();
                        while (it.hasNext()) {
                            try {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                Tuple<Integer, Integer> startEnd = it.next();
                                IRegion region = document.getLineInformation((Integer)startEnd.o1 - 1);
                                int errorStart = region.getOffset();
                                region = document.getLineInformation((Integer)startEnd.o2 - 1);
                                int errorEnd = region.getOffset() + region.getLength();
                                map.put("message", "Not Executed");
                                map.put("severity", new Integer(2));
                                map.put("charStart", errorStart);
                                map.put("charEnd", errorEnd);
                                map.put("transient", true);
                                map.put("priority", new Integer(2));
                                MarkerUtilities.createMarker((IResource)original, map, (String)PyCodeCoverageView.PYDEV_COVERAGE_MARKER);
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                            }
                        }
                    }
                };
                try {
                    original.getWorkspace().run(r, null, 1, null);
                }
                catch (CoreException e1) {
                    Log.log((Throwable)e1);
                }
            }
        }
    }

    public ICallbackWithListeners getOnControlCreated() {
        return this.onControlCreated;
    }

    public ICallbackWithListeners getOnControlDisposed() {
        return this.onControlDisposed;
    }

    private final class ChooseAction
    extends ProgressAction {
        private ChooseAction() {
        }

        public void run() {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(PyCodeCoverageView.this.getSite().getShell(), null, false, "Choose folder to be analyzed in the code-coverage");
            dialog.showClosedProjects(false);
            if (dialog.open() != 0) {
                return;
            }
            Object[] objects = dialog.getResult();
            if (objects.length == 1 && objects[0] instanceof IPath) {
                IPath p = (IPath)objects[0];
                IWorkspace w = ResourcesPlugin.getWorkspace();
                IContainer folderForLocation = (IContainer)w.getRoot().findMember(p);
                PyCodeCoverageView.this.setSelectedContainer(folderForLocation);
            }
        }
    }

    private final class ClearAction
    extends ProgressAction {
        public ClearAction() {
            this.setText("Clear coverage information");
        }

        public void run() {
            PyCoverage.getPyCoverage().clearInfo();
            MessageDialog.openInformation((Shell)PyCodeCoverageView.this.getSite().getShell(), (String)"Cleared", (String)"All the coverage data has been cleared!");
            PyCodeCoverageView.this.text.setText("Data cleared (NOT REFRESHED).");
        }
    }

    private final class DoubleClickTreeAction
    extends ProgressAction {
        private DoubleClickTreeAction() {
        }

        public void run() {
            this.run(PyCodeCoverageView.this.viewer.getSelection());
        }

        public void runWithEvent(DoubleClickEvent event) {
            this.run(event.getSelection());
        }

        public void run(ISelection selection) {
            try {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                File realFile = new File(obj.toString());
                if (realFile.exists() && !realFile.isDirectory()) {
                    PyCodeCoverageView.this.openFileWithCoverageMarkers(realFile);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private final class OpenCoverageFolderAction
    extends Action {
        public OpenCoverageFolderAction() {
            this.setText("Open folder with .coverage files.");
        }

        public void run() {
            try {
                FileUtils.openDirectory((File)PyCoverage.getCoverageDirLocation());
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private final class RefreshAction
    extends ProgressAction {
        public RefreshAction() {
            this.setText("Refresh coverage information");
        }

        public void run() {
            try {
                PyCodeCoverageView.this.executeRefreshAction(this.monitor);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private final class SelectColumnsAction
    extends Action {
        public SelectColumnsAction() {
            this.setText("Select the number of columns for the name.");
        }

        public void run() {
            InputDialog d = new InputDialog(EditorUtils.getShell(), "Enter number of columns", "Enter the number of columns to be used for the name.", "" + PyCoveragePreferences.getNameNumberOfColumns(), new IInputValidator(){

                public String isValid(String newText) {
                    int i;
                    block5: {
                        if (newText.trim().length() == 0) {
                            return "Please enter a number > 5";
                        }
                        try {
                            i = Integer.parseInt(newText);
                            if (i >= 6) break block5;
                            return "Please enter a number > 5";
                        }
                        catch (NumberFormatException numberFormatException) {
                            return "Please enter a number > 5";
                        }
                    }
                    if (i > 256) {
                        return "Please enter a number <= 256";
                    }
                    return null;
                }
            });
            int retCode = d.open();
            if (retCode == 0) {
                PyCoveragePreferences.setNameNumberOfColumns(Integer.parseInt(d.getValue()));
                PyCodeCoverageView.this.onSelectedFileInTree(PyCodeCoverageView.this.lastSelectedFile);
            }
        }
    }

    private final class SelectionChangedTreeAction
    extends Action {
        private SelectionChangedTreeAction() {
        }

        public void run() {
            this.run((IStructuredSelection)PyCodeCoverageView.this.viewer.getSelection());
        }

        public void runWithEvent(SelectionChangedEvent event) {
            this.run((IStructuredSelection)event.getSelection());
        }

        public void run(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (obj == null) {
                return;
            }
            PyCodeCoverageView.this.onSelectedFileInTree(obj);
        }
    }
}

