/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.simpleassist;

import com.python.pydev.codecompletion.simpleassist.SimpleAssistProposal;
import com.python.pydev.codecompletion.ui.CodeCompletionPreferencesPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.simpleassist.ISimpleAssistParticipant;
import org.python.pydev.editor.simpleassist.ISimpleAssistParticipant2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordsSimpleAssist
implements ISimpleAssistParticipant,
ISimpleAssistParticipant2 {
    private static String cache;
    private static String[] cacheRet;

    public static String defaultKeywordsAsString() {
        String[] KEYWORDS = new String[]{"and", "assert", "break", "class", "continue", "def", "del", "finally:", "for", "from", "global", "import", "lambda", "not", "pass", "print", "raise", "return", "while", "with", "yield", "self", "__init__", "False", "None", "object", "True"};
        return KeywordsSimpleAssist.wordsAsString(KEYWORDS);
    }

    public static String[] stringAsWords(String keywords) {
        if (cache != null && cache.equals(keywords)) {
            return cacheRet;
        }
        StringTokenizer tokenizer = new StringTokenizer(keywords);
        ArrayList<String> strs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            strs.add(tokenizer.nextToken());
        }
        cache = keywords;
        cacheRet = strs.toArray(new String[0]);
        return cacheRet;
    }

    public static String wordsAsString(String[] keywords) {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buf.append(string);
            buf.append("\n");
            ++n2;
        }
        return buf.toString();
    }

    public Collection<ICompletionProposal> computeCompletionProposals(String activationToken, String qualifier, PySelection ps, IPySyntaxHighlightingAndCodeCompletionEditor edit, int offset) {
        boolean isPy3Syntax = false;
        if (CodeCompletionPreferencesPage.forcePy3kPrintOnPy2()) {
            isPy3Syntax = true;
        } else {
            try {
                IPythonNature nature = edit.getPythonNature();
                if (nature != null) {
                    isPy3Syntax = nature.getGrammarVersion() >= 99;
                }
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        return this.innerComputeProposals(activationToken, qualifier, offset, false, isPy3Syntax);
    }

    public Collection<ICompletionProposal> computeConsoleProposals(String activationToken, String qualifier, int offset) {
        return this.innerComputeProposals(activationToken, qualifier, offset, true, false);
    }

    private Collection<ICompletionProposal> innerComputeProposals(String activationToken, String qualifier, int offset, boolean buildForConsole, boolean isPy3Syntax) {
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        if (!CodeCompletionPreferencesPage.useKeywordsCodeCompletion()) {
            return results;
        }
        int qlen = qualifier.length();
        if (activationToken.equals("") && !qualifier.equals("")) {
            String[] stringArray = CodeCompletionPreferencesPage.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyw = stringArray[n2];
                if (keyw.startsWith(qualifier) && !keyw.equals(qualifier)) {
                    if (buildForConsole) {
                        results.add((ICompletionProposal)new PyCompletionProposal(keyw, offset - qlen, qlen, keyw.length(), 10));
                    } else {
                        if (isPy3Syntax && "print".equals(keyw)) {
                            keyw = "print()";
                        }
                        results.add((ICompletionProposal)new SimpleAssistProposal(keyw, offset - qlen, qlen, keyw.length(), 10));
                    }
                }
                ++n2;
            }
        }
        return results;
    }
}

