/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.visitors.ArgumentsChecker;
import com.python.pydev.analysis.visitors.DuplicationChecker;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.NoSelfChecker;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.callbacks.ICallbackListener;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.stmtType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OccurrencesVisitor
extends AbstractScopeAnalyzerVisitor {
    public final MessagesManager messagesManager;
    private final DuplicationChecker duplicationChecker;
    private final NoSelfChecker noSelfChecker;
    private final ArgumentsChecker argumentsChecker;
    private final boolean analyzeArgumentsMismatch;
    private int isInTestScope = 0;
    private final FastStack<TokenFoundStructure> recordedFounds = new FastStack(4);
    private int recordFounds = 0;

    public OccurrencesVisitor(IPythonNature nature, String moduleName, IModule current, IAnalysisPreferences prefs, IDocument document, IProgressMonitor monitor) {
        super(nature, moduleName, current, document, monitor);
        this.messagesManager = new MessagesManager(prefs, moduleName, document);
        this.analyzeArgumentsMismatch = prefs.getSeverityForType(16) > 0;
        this.argumentsChecker = this.analyzeArgumentsMismatch ? new ArgumentsChecker(this) : null;
        this.duplicationChecker = new DuplicationChecker(this);
        this.noSelfChecker = new NoSelfChecker(this);
    }

    public Object visitCompare(Compare node) throws Exception {
        Object ret = super.visitCompare(node);
        if (this.isInTestScope == 0) {
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName);
            this.messagesManager.addMessage(11, (IToken)token);
        }
        return ret;
    }

    public void traverse(If node) throws Exception {
        this.checkStop();
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)this);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)this);
        }
    }

    public Object visitTuple(Tuple node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitTuple(node);
        --this.isInTestScope;
        return ret;
    }

    public void traverse(While node) throws Exception {
        this.checkStop();
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)this);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)this);
        }
    }

    public Object visitRaise(Raise node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitRaise(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitComprehension(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitAssert(Assert node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssert(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitPrint(Print node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitPrint(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAssign(Assign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssign(node);
        --this.isInTestScope;
        if (this.analyzeArgumentsMismatch) {
            this.argumentsChecker.visitAssign(node);
        }
        return r;
    }

    public Object visitYield(Yield node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitYield(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAugAssign(AugAssign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAugAssign(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitCall(Call node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitCall(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitReturn(Return node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitReturn(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    protected void handleDecorator(decoratorsType dec) throws Exception {
        ++this.isInTestScope;
        dec.accept((VisitorIF)this);
        --this.isInTestScope;
    }

    @Override
    public Object visitLambda(Lambda node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitLambda(node);
        --this.isInTestScope;
        return ret;
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        if (node instanceof If) {
            this.traverse((If)node);
        } else if (node instanceof While) {
            this.traverse((While)node);
        } else if (node instanceof ListComp) {
            this.visitListComp((ListComp)node);
        } else {
            super.traverse(node);
        }
    }

    public List<IMessage> getMessages() {
        this.endScope(null);
        return this.messagesManager.getMessages();
    }

    @Override
    protected void onAddUndefinedVarInImportMessage(IToken foundTok, Found foundAs) {
        this.messagesManager.addUndefinedVarInImportMessage(foundTok, foundTok.getRepresentation());
    }

    @Override
    protected void onAddAssignmentToBuiltinMessage(IToken foundTok, String representation) {
        this.messagesManager.onAddAssignmentToBuiltinMessage(foundTok, representation);
    }

    @Override
    protected void onAddUndefinedMessage(IToken token, Found foundAs) {
        if ("...".equals(token.getRepresentation())) {
            return;
        }
        this.messagesManager.addUndefinedMessage(token);
    }

    @Override
    protected void onLastScope(ScopeItems m) {
        for (Found n : this.probablyNotDefined) {
            Map<String, org.python.pydev.core.Tuple<IToken, Found>> lastInStack;
            String rep = n.getSingle().tok.getRepresentation();
            if (this.scope.findInNamesToIgnore(rep, lastInStack = m.namesToIgnore) != null) continue;
            this.onAddUndefinedMessage(n.getSingle().tok, n);
        }
    }

    @Override
    protected void onAfterEndScope(SimpleNode node, ScopeItems m) {
        boolean reportUnused = true;
        if (node != null && node instanceof FunctionDef) {
            boolean bl = reportUnused = !this.isVirtual((FunctionDef)node);
        }
        if (reportUnused) {
            int scopeType = m.getScopeType();
            for (List<Found> list : m.getAll()) {
                int len = list.size();
                int i = 0;
                while (i < len) {
                    Found f = list.get(i);
                    if (!f.isUsed() && ((scopeType & 0x12) != 0 || f.isImport())) {
                        this.messagesManager.addUnusedMessage(node, f);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isVirtual(FunctionDef node) {
        if (node.body != null) {
            int len = node.body.length;
            int i = 0;
            while (i < len) {
                stmtType n = node.body[i];
                if (!(n instanceof Raise || n instanceof Expr && ((Expr)n).value instanceof Str)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected void onAfterStartScope(int newScopeType, SimpleNode node) {
        if (newScopeType == 4) {
            this.duplicationChecker.beforeClassDef((ClassDef)node);
            this.noSelfChecker.beforeClassDef((ClassDef)node);
        } else if ((newScopeType & 2) != 0) {
            this.duplicationChecker.beforeFunctionDef((FunctionDef)node);
            this.noSelfChecker.beforeFunctionDef((FunctionDef)node);
        }
    }

    @Override
    protected void onBeforeEndScope(SimpleNode node) {
        if (node instanceof ClassDef) {
            this.noSelfChecker.afterClassDef((ClassDef)node);
            this.duplicationChecker.afterClassDef((ClassDef)node);
        } else if (node instanceof FunctionDef) {
            this.duplicationChecker.afterFunctionDef((FunctionDef)node);
            this.noSelfChecker.afterFunctionDef((FunctionDef)node);
        }
    }

    @Override
    public void onAddUnusedMessage(SimpleNode node, Found found) {
        this.messagesManager.addUnusedMessage(node, found);
    }

    @Override
    public void onAddReimportMessage(Found newFound) {
        this.messagesManager.addReimportMessage(newFound);
    }

    @Override
    public void onAddUnresolvedImport(IToken token) {
        this.messagesManager.addMessage(6, token);
    }

    @Override
    protected void onAfterVisitAssign(Assign node) {
        this.noSelfChecker.visitAssign(node);
    }

    @Override
    protected void onVisitCallFunc(final Call callNode) throws Exception {
        if (!this.analyzeArgumentsMismatch) {
            super.onVisitCallFunc(callNode);
        } else if (callNode.func instanceof Name) {
            Name name = (Name)callNode.func;
            this.startRecordFound();
            this.visitName(name);
            TokenFoundStructure found = this.popFound();
            if (found != null && found.token instanceof SourceToken) {
                SourceToken sourceToken = (SourceToken)found.token;
                if (found.defined) {
                    this.argumentsChecker.checkNameFound(callNode, sourceToken);
                } else if (found.found != null) {
                    found.found.registerCallOnDefined(new ICallbackListener<Found>(){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public Object call(Found f) {
                            try {
                                SourceToken sourceToken2;
                                GenAndTok genAndTok;
                                List<GenAndTok> all = f.getAll();
                                Iterator<GenAndTok> iterator = all.iterator();
                                do {
                                    if (!iterator.hasNext()) {
                                        return null;
                                    }
                                    genAndTok = iterator.next();
                                } while (!(genAndTok.tok instanceof SourceToken) || !((sourceToken2 = (SourceToken)genAndTok.tok).getAst() instanceof FunctionDef) && !(sourceToken2.getAst() instanceof ClassDef));
                                OccurrencesVisitor.this.argumentsChecker.checkNameFound(callNode, sourceToken2);
                                return null;
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            }
        } else {
            this.startRecordFound();
            callNode.func.accept((VisitorIF)this);
            TokenFoundStructure found = this.popFound();
            this.argumentsChecker.checkAttrFound(callNode, found);
        }
    }

    private void onPushToRecordedFounds(IToken o1) {
        if (this.recordFounds > 0) {
            this.recordedFounds.push((Object)new TokenFoundStructure(o1, true, null));
        }
    }

    @Override
    protected void onAddToProbablyNotDefined(IToken token, Found foundForProbablyNotDefined) {
        if (this.recordFounds > 0) {
            this.recordedFounds.push((Object)new TokenFoundStructure(token, false, foundForProbablyNotDefined));
        }
    }

    protected TokenFoundStructure popFound() {
        --this.recordFounds;
        if (this.recordedFounds.size() > 0) {
            TokenFoundStructure ret = (TokenFoundStructure)this.recordedFounds.peek();
            this.recordedFounds.clear();
            return ret;
        }
        return null;
    }

    protected void startRecordFound() {
        ++this.recordFounds;
    }

    @Override
    protected void onFoundTokenAs(IToken token, Found foundAs) {
        if (this.analyzeArgumentsMismatch) {
            boolean reportFound;
            block6: {
                reportFound = true;
                try {
                    IDefinition[] definition;
                    if (foundAs.importInfo == null) break block6;
                    IDefinition[] iDefinitionArray = definition = foundAs.importInfo.getDefinitions(this.nature, this.completionCache);
                    int n = definition.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDefinition iDefinition = iDefinitionArray[n2];
                        Definition d = (Definition)iDefinition;
                        if (d.ast instanceof FunctionDef || d.ast instanceof ClassDef) {
                            SourceToken tok = AbstractVisitor.makeToken((SimpleNode)d.ast, (String)token.getRepresentation(), (String)(d.module != null ? d.module.getName() : ""));
                            tok.setDefinition(d);
                            this.onPushToRecordedFounds((IToken)tok);
                            reportFound = false;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            if (reportFound) {
                this.onPushToRecordedFounds(token);
            }
        }
    }

    @Override
    protected void onFoundInNamesToIgnore(IToken token, IToken tokenInNamesToIgnore) {
        if (this.analyzeArgumentsMismatch && tokenInNamesToIgnore instanceof SourceToken) {
            SourceToken sourceToken = (SourceToken)tokenInNamesToIgnore;
            this.onPushToRecordedFounds((IToken)AbstractVisitor.makeToken((SimpleNode)sourceToken.getAst(), (String)token.getRepresentation(), (String)sourceToken.getParentPackage()));
        }
    }

    public static final class TokenFoundStructure {
        public final IToken token;
        public final boolean defined;
        public final Found found;

        public TokenFoundStructure(IToken token, boolean defined, Found found) {
            this.token = token;
            this.defined = defined;
            this.found = found;
        }
    }
}

