/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyObjectArray;
import org.python.core.PySequenceList;

public class PyObjectList
extends AbstractList
implements Cloneable,
Serializable {
    protected PyObjectArray array;

    public PyObjectList() {
        this.array = new PyObjectArray();
    }

    public PyObjectList(PyObject[] pyObjArr) {
        this.array = new PyObjectArray(pyObjArr);
        this.array.baseArray = pyObjArr;
    }

    public PyObjectList(Collection c) {
        this.array = new PyObjectArray();
        this.array.appendArray(c.toArray());
    }

    public PyObjectList(int size) {
        this.array = new PyObjectArray(size);
    }

    public void add(int index, Object element) {
        this.array.add(index, Py.java2py(element));
        this.modCount += this.array.getModCountIncr();
    }

    public void pyadd(int index, PyObject element) {
        this.array.add(index, element);
        this.modCount += this.array.getModCountIncr();
    }

    public boolean add(Object o) {
        this.array.add(Py.java2py(o));
        this.modCount += this.array.getModCountIncr();
        return true;
    }

    public boolean pyadd(PyObject o) {
        this.array.add(o);
        this.modCount += this.array.getModCountIncr();
        return true;
    }

    public Object clone() {
        try {
            PyObjectList tol = (PyObjectList)super.clone();
            tol.array = (PyObjectArray)this.array.clone();
            this.modCount = 0;
            return tol;
        }
        catch (CloneNotSupportedException eCNSE) {
            throw new InternalError("Unexpected CloneNotSupportedException.\n" + eCNSE.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PyObjectList) {
            return this.array.equals(((PyObjectList)o).array);
        }
        return false;
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    public Object get(int index) {
        PyObject obj = this.array.get(index);
        return obj.__tojava__(Object.class);
    }

    PyObject pyget(int index) {
        return this.array.get(index);
    }

    public Object remove(int index) {
        ++this.modCount;
        PyObject existing = this.array.get(index);
        this.array.remove(index);
        return existing;
    }

    public void remove(int start, int stop) {
        ++this.modCount;
        this.array.remove(start, stop);
    }

    public Object set(int index, Object element) {
        return this.array.set(index, Py.java2py(element)).__tojava__(Object.class);
    }

    PyObject pyset(int index, PyObject element) {
        return this.array.set(index, element);
    }

    public int size() {
        return this.array.getSize();
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(int index, Collection c) {
        if (c instanceof PySequenceList) {
            PySequenceList cList = (PySequenceList)c;
            PyObject[] cArray = cList.getArray();
            int cOrigSize = cList.size();
            this.array.makeInsertSpace(index, cOrigSize);
            this.array.replaceSubArray(index, index + cOrigSize, cArray, 0, cOrigSize);
        } else {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
        return c.size() > 0;
    }

    protected PyObject[] getArray() {
        return (PyObject[])this.array.getArray();
    }

    void ensureCapacity(int minCapacity) {
        this.array.ensureCapacity(minCapacity);
    }

    void replaceSubArray(int destStart, int destStop, Object srcArray, int srcStart, int srcStop) {
        this.array.replaceSubArray(destStart, destStop, srcArray, srcStart, srcStop);
    }

    void setSize(int count) {
        this.array.setSize(count);
    }
}

