/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyException;
import org.python.core.PyGetSetDescr;
import org.python.core.PyList;
import org.python.core.PyMethodDescr;
import org.python.core.PyModuleDerived;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.__builtin__;
import org.python.core.imp;

public class PyModule
extends PyObject {
    public static final String exposed_name = "module";
    private final PyObject module_doc = new PyString("module(name[, doc])\n\nCreate a module object.\nThe name must be a string; the optional doc argument can have any type.");
    public PyObject __dict__;
    private static PyObject silly_list = null;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        dict.__setitem__("__dict__", (PyObject)new PyGetSetDescr("__dict__", PyModule.class, "getDict", "setDict", "delDict"));
        dict.__setitem__("__doc__", (PyObject)new PyGetSetDescr("__doc__", PyModule.class, "getDoc", null, null));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___repr__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyModule)this.self).module_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyModule.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___setattr__
        extends PyBuiltinMethodNarrow {
            Exposed___setattr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___setattr__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    ((PyModule)this.self).module___setattr__(arg0.asName(0), arg1);
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "attribute name must be a string";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("__setattr__", (PyObject)new PyMethodDescr("__setattr__", PyModule.class, 2, 2, new Exposed___setattr__(null, null)));
        class Exposed___delattr__
        extends PyBuiltinMethodNarrow {
            Exposed___delattr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___delattr__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    ((PyModule)this.self).module___delattr__(arg0.asName(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "attribute name must be a string";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("__delattr__", (PyObject)new PyMethodDescr("__delattr__", PyModule.class, 1, 1, new Exposed___delattr__(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PyModule)this.self).module_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyModule.class, -1, -1, new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyModule.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PyModule newobj;
                if (this.for_type == subtype) {
                    newobj = new PyModule();
                    if (init) {
                        newobj.module_init(args, keywords);
                    }
                } else {
                    newobj = new PyModuleDerived(subtype);
                }
                return newobj;
            }
        });
    }

    public PyModule() {
    }

    public PyModule(PyType subType) {
        super(subType);
    }

    public PyModule(PyType subType, String name) {
        super(subType);
        this.module_init(new PyString(name), Py.None);
    }

    public PyModule(String name) {
        this(name, null);
    }

    public PyModule(String name, PyObject dict) {
        this.__dict__ = dict;
        this.module_init(new PyString(name), Py.None);
    }

    final void module_init(PyObject name, PyObject doc) {
        this.ensureDict();
        this.__dict__.__setitem__("__name__", name);
        this.__dict__.__setitem__("__doc__", doc);
    }

    final void module_init(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("__init__", args, keywords, new String[]{"name", "doc"});
        PyObject name = ap.getPyObject(0);
        PyObject docs = ap.getPyObject(1, Py.None);
        this.module_init(name, docs);
    }

    public PyObject fastGetDict() {
        return this.__dict__;
    }

    public PyObject getDict() {
        if (this.__dict__ == null) {
            return Py.None;
        }
        return this.__dict__;
    }

    public void setDict(PyObject newDict) {
        throw Py.TypeError("readonly attribute");
    }

    public void delDict() {
        throw Py.TypeError("readonly attribute");
    }

    public PyObject getDoc() {
        PyObject doc;
        PyObject d = this.fastGetDict();
        if (d != null && (doc = d.__finditem__("__doc__")) != null) {
            return doc;
        }
        return this.module_doc;
    }

    protected PyObject impAttr(String attr) {
        PyObject path = this.__dict__.__finditem__("__path__");
        PyObject pyname = this.__dict__.__finditem__("__name__");
        if (path == null || pyname == null) {
            return null;
        }
        String name = pyname.__str__().toString();
        String fullName = (String.valueOf(name) + '.' + attr).intern();
        PyObject ret = null;
        if (path != Py.None) {
            if (path instanceof PyList) {
                ret = imp.find_module(attr, fullName, (PyList)path);
            } else {
                throw Py.TypeError("__path__ must be list or None");
            }
        }
        if (ret == null) {
            ret = PySystemState.packageManager.lookupName(fullName);
        }
        if (ret != null) {
            PyObject tmp = Py.getSystemState().modules.__finditem__(fullName);
            if (tmp != null) {
                ret = tmp;
            }
            this.__dict__.__setitem__(attr, ret);
            return ret;
        }
        return null;
    }

    public PyObject __findattr__(String attr) {
        return this.module___findattr__(attr);
    }

    final PyObject module___findattr__(String attr) {
        PyObject ret;
        if (this.__dict__ != null && (ret = this.__dict__.__finditem__(attr)) != null) {
            return ret;
        }
        ret = super.__findattr__(attr);
        if (ret != null) {
            return ret;
        }
        if (this.__dict__ == null) {
            return null;
        }
        PyObject pyname = this.__dict__.__finditem__("__name__");
        if (pyname == null) {
            return null;
        }
        return PyModule.impHook(String.valueOf(pyname.__str__().toString()) + '.' + attr);
    }

    public void __setattr__(String attr, PyObject value) {
        this.module___setattr__(attr, value);
    }

    final void module___setattr__(String attr, PyObject value) {
        if (attr != "__dict__") {
            this.ensureDict();
        }
        super.__setattr__(attr, value);
    }

    public void __delattr__(String attr) {
        this.module___delattr__(attr);
    }

    final void module___delattr__(String attr) {
        super.__delattr__(attr);
    }

    public String toString() {
        return this.module_toString();
    }

    final String module_toString() {
        PyObject name = null;
        PyObject filename = null;
        if (this.__dict__ != null) {
            name = this.__dict__.__finditem__("__name__");
            filename = this.__dict__.__finditem__("__file__");
        }
        if (name == null) {
            name = new PyString("?");
        }
        filename = filename == null ? new PyString("(built-in)") : new PyString("from '" + filename + "'");
        return "<module '" + name + "' " + filename + ">";
    }

    public PyObject __dir__() {
        if (this.__dict__ == null) {
            throw Py.TypeError("module.__dict__ is not a dictionary");
        }
        return this.__dict__.invoke("keys");
    }

    private void ensureDict() {
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
    }

    private static PyObject impHook(String name) {
        if (silly_list == null) {
            silly_list = new PyTuple(new PyString[]{Py.newString("__doc__")});
        }
        try {
            return __builtin__.__import__(name, null, null, silly_list);
        }
        catch (PyException e) {
            if (Py.matchException(e, Py.ImportError)) {
                return null;
            }
            throw e;
        }
    }
}

