/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Hashtable;
import java.util.Stack;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expression;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Return;
import org.python.parser.ast.Yield;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private Stack scopes;
    private ScopeInfo cur = null;
    private Hashtable nodeScopes;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext code_compiler, Hashtable nodeScopes) {
        this.code_compiler = code_compiler;
        this.nodeScopes = nodeScopes;
        this.scopes = new Stack();
    }

    public void beginScope(String name, int kind, SimpleNode node, ArgListCompiler ac) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (kind == 1) {
            ++this.func_level;
        }
        this.cur = new ScopeInfo(name, node, this.level++, kind, this.func_level, ac);
        this.nodeScopes.put(node, this.cur);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo up = !this.scopes.empty() ? (ScopeInfo)this.scopes.pop() : null;
        int dist = 1;
        ScopeInfo referenceable = up;
        int i = this.scopes.size() - 1;
        while (i >= 0 && referenceable.kind == 2) {
            referenceable = (ScopeInfo)this.scopes.get(i);
            --i;
            ++dist;
        }
        this.cur.cook(referenceable, dist, this.code_compiler);
        this.cur.dump();
        this.cur = up;
    }

    public void parse(SimpleNode node) throws Exception {
        try {
            this.visit(node);
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, this.code_compiler.getFilename());
        }
    }

    public Object visitInteractive(Interactive node) throws Exception {
        this.beginScope("<single-top>", 0, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.beginScope("<file-top>", 0, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitExpression(Expression node) throws Exception {
        this.beginScope("<eval-top>", 0, node, null);
        this.visit(new Return(node.body));
        this.endScope();
        return null;
    }

    private void def(String name) {
        this.cur.addBound(name);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.def(node.name);
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.args);
        exprType[] defaults = ac.getDefaults();
        int defc = defaults.length;
        int i = 0;
        while (i < defc) {
            this.visit(defaults[i]);
            ++i;
        }
        this.beginScope(node.name, 1, node, ac);
        int n = ac.names.size();
        int i2 = 0;
        while (i2 < n) {
            this.cur.addParam((String)ac.names.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < ac.init_code.size()) {
            this.visit((stmtType)ac.init_code.elementAt(i2));
            ++i2;
        }
        this.cur.markFromParam();
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.args);
        exprType[] defaults = ac.getDefaults();
        int defc = defaults.length;
        int i = 0;
        while (i < defc) {
            this.visit(defaults[i]);
            ++i;
        }
        this.beginScope("<lambda>", 1, node, ac);
        int n = ac.names.size();
        int i2 = 0;
        while (i2 < n) {
            this.cur.addParam((String)ac.names.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < ac.init_code.size()) {
            this.visit((stmtType)ac.init_code.elementAt(i2));
            ++i2;
        }
        this.cur.markFromParam();
        this.visit(node.body);
        this.endScope();
        return null;
    }

    public void suite(stmtType[] stmts) throws Exception {
        int n = stmts.length;
        int i = 0;
        while (i < n) {
            this.visit(stmts[i]);
            ++i;
        }
    }

    public Object visitImport(Import node) throws Exception {
        int n = node.names.length;
        int i = 0;
        while (i < n) {
            if (node.names[i].asname != null) {
                this.cur.addBound(node.names[i].asname);
            } else {
                String name = node.names[i].name;
                if (name.indexOf(46) > 0) {
                    name = name.substring(0, name.indexOf(46));
                }
                this.cur.addBound(name);
            }
            ++i;
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        Future.checkFromFuture(node);
        int n = node.names.length;
        if (n == 0) {
            this.cur.from_import_star = true;
            return null;
        }
        int i = 0;
        while (i < n) {
            if (node.names[i].asname != null) {
                this.cur.addBound(node.names[i].asname);
            } else {
                this.cur.addBound(node.names[i].name);
            }
            ++i;
        }
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        int n = node.names.length;
        int i = 0;
        while (i < n) {
            String name = node.names[i];
            int prev = this.cur.addGlobal(name);
            if (prev >= 0) {
                if ((prev & 8) != 0) {
                    this.code_compiler.error("name '" + name + "' is local and global", true, node);
                }
                if ((prev & 0x42) == 0) {
                    String what = (prev & 1) != 0 ? "assignment" : "use";
                    this.code_compiler.error("name '" + name + "' declared global after " + what, false, node);
                }
            }
            ++i;
        }
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        this.cur.exec = true;
        if (node.globals == null && node.locals == null) {
            this.cur.unqual_exec = true;
        }
        this.traverse(node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.def(node.name);
        int n = node.bases.length;
        int i = 0;
        while (i < n) {
            this.visit(node.bases[i]);
            ++i;
        }
        this.beginScope(node.name, 2, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitName(Name node) throws Exception {
        String name = node.id;
        if (node.ctx != 1) {
            if (name.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", true, node);
            }
            this.cur.addBound(name);
        } else {
            this.cur.addUsed(name);
        }
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        String tmp = "_[" + ++this.cur.list_comprehension_count + "]";
        this.cur.addBound(tmp);
        this.traverse(node);
        return null;
    }

    public Object visitYield(Yield node) throws Exception {
        this.cur.generator = true;
        ++this.cur.yield_count;
        this.traverse(node);
        return null;
    }
}

