/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Vector;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.Visitor;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Name;
import org.python.parser.ast.Suite;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.argumentsType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class ArgListCompiler
extends Visitor
implements PythonGrammarTreeConstants {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public exprType[] defaults = null;
    public Vector names = new Vector();
    public Vector fpnames = new Vector();
    public Vector init_code = new Vector();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.removeAllElements();
        this.init_code.removeAllElements();
    }

    public void appendInitCode(Suite node) {
        int n = node.body.length;
        Object[] newtree = new stmtType[this.init_code.size() + n];
        this.init_code.copyInto(newtree);
        System.arraycopy(node.body, 0, newtree, this.init_code.size(), n);
        node.body = newtree;
    }

    public exprType[] getDefaults() {
        return this.defaults;
    }

    public void visitArgs(argumentsType args) throws Exception {
        int i = 0;
        while (i < args.args.length) {
            String name = (String)this.visit(args.args[i]);
            this.names.addElement(name);
            if (args.args[i] instanceof Tuple) {
                Assign ass = new Assign(new exprType[]{args.args[i]}, new Name(name, 1, args.args[i]), args.args[i]);
                this.init_code.addElement(ass);
            }
            ++i;
        }
        if (args.vararg != null) {
            this.arglist = true;
            this.names.addElement(args.vararg);
        }
        if (args.kwarg != null) {
            this.keywordlist = true;
            this.names.addElement(args.kwarg);
        }
        this.defaults = args.defaults;
        i = 0;
        while (i < this.defaults.length) {
            if (this.defaults[i] == null) {
                throw new ParseException("non-default argument follows default argument", args.args[args.args.length - this.defaults.length + i]);
            }
            ++i;
        }
    }

    public Object visitName(Name node) throws Exception {
        if (node.ctx != 2) {
            return null;
        }
        if (this.fpnames.contains(node.id)) {
            throw new ParseException("duplicate argument name found: " + node.id, node);
        }
        this.fpnames.addElement(node.id);
        return node.id;
    }

    public Object visitTuple(Tuple node) throws Exception {
        StringBuffer name = new StringBuffer("(");
        int n = node.elts.length;
        int i = 0;
        while (i < n - 1) {
            name.append(this.visit(node.elts[i]));
            name.append(", ");
            ++i;
        }
        name.append(this.visit(node.elts[n - 1]));
        name.append(")");
        return name.toString();
    }
}

