/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.python.pydev.core.log.Log;
import org.python.pydev.dltk.console.IScriptConsoleShell;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.editor.codecompletion.AbstractCompletionProcessorWithCycling;
import org.python.pydev.editor.codecompletion.CompletionError;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PyContextInformationValidator;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.editor.simpleassist.SimpleAssistProcessor;

public class PydevConsoleCompletionProcessor
extends AbstractCompletionProcessorWithCycling
implements ICompletionListener {
    private PyContextInformationValidator contextInformationValidator;
    private IScriptConsoleShell interpreterShell;
    private String errorMessage = null;
    private int lastActivationCount = -1;

    public PydevConsoleCompletionProcessor(IScriptConsoleShell interpreterShell, PyContentAssistant pyContentAssistant) {
        super(pyContentAssistant);
        pyContentAssistant.addCompletionListener((ICompletionListener)this);
        this.interpreterShell = interpreterShell;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return SimpleAssistProcessor.getStaticAutoActivationCharacters((char[])PythonCompletionProcessor.getStaticCompletionProposalAutoActivationCharacters(), (int)0);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer v, int offset) {
        boolean cycleRequest;
        if (this.lastActivationCount == -1) {
            this.lastActivationCount = this.pyContentAssistant.lastActivationCount;
            cycleRequest = false;
            this.updateStatus();
        } else {
            boolean bl = cycleRequest = this.pyContentAssistant.lastActivationCount != this.lastActivationCount;
        }
        if (cycleRequest) {
            this.lastActivationCount = this.pyContentAssistant.lastActivationCount;
            this.doCycle();
            this.updateStatus();
        }
        IScriptConsoleViewer viewer = (IScriptConsoleViewer)v;
        try {
            if (!PyCodeCompletionPreferencesPage.useCodeCompletion()) {
                return new ICompletionProposal[0];
            }
            String commandLine = viewer.getCommandLine();
            int cursorPosition = offset - viewer.getCommandLineOffset();
            return this.interpreterShell.getCompletions(viewer, commandLine, cursorPosition, offset, this.whatToShow);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            CompletionError completionError = new CompletionError((Throwable)e);
            this.errorMessage = completionError.getErrorMessage();
            return new ICompletionProposal[]{completionError};
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer v, int offset) {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.contextInformationValidator == null) {
            this.contextInformationValidator = new PyContextInformationValidator();
        }
        return this.contextInformationValidator;
    }

    public String getErrorMessage() {
        String msg = this.errorMessage;
        this.errorMessage = null;
        return msg;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.lastActivationCount = -1;
        this.startCycle();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

