/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.changes.PyRenameResourceChange;
import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.modules.ASTEntryWithSourceModule;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.refactoring.core.base.PyDocumentChange;
import org.python.pydev.refactoring.core.base.PyTextFileChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextEditCreation {
    private String inputName;
    private String initialName;
    private String moduleName;
    private IDocument currentDoc;
    private List<IRefactorRenameProcess> processes;
    private CompositeChange fChange;
    private RefactoringStatus status;
    private Map<Tuple<String, File>, HashSet<ASTEntry>> fileOccurrences;
    private HashSet<ASTEntry> docOccurrences;
    private IFile currentFile;
    private static final int AST_ENTRIES_FILTER_TEXT = 1;
    private static final int AST_ENTRIES_FILTER_FILE = 2;

    public TextEditCreation(String initialName, String inputName, String moduleName, IDocument currentDoc, List<IRefactorRenameProcess> processes, RefactoringStatus status, CompositeChange fChange, IFile currentFile) {
        this.initialName = initialName;
        this.inputName = inputName;
        this.moduleName = moduleName;
        this.currentDoc = currentDoc;
        this.processes = processes;
        this.fChange = fChange;
        this.status = status;
        this.currentFile = currentFile;
    }

    public void fillRefactoringChangeObject(RefactoringRequest request, CheckConditionsContext context) {
        for (IRefactorRenameProcess p : this.processes) {
            if (this.status.hasFatalError() || request.getMonitor().isCanceled()) break;
            HashSet<ASTEntry> occurrences = p.getOccurrences();
            if (this.docOccurrences == null) {
                this.docOccurrences = occurrences;
            } else {
                this.docOccurrences.addAll(occurrences);
            }
            Map<Tuple<String, File>, HashSet<ASTEntry>> occurrencesInOtherFiles = p.getOccurrencesInOtherFiles();
            if (this.fileOccurrences == null) {
                this.fileOccurrences = occurrencesInOtherFiles;
                continue;
            }
            for (Map.Entry<Tuple<String, File>, HashSet<ASTEntry>> entry : new HashMap<Tuple<String, File>, HashSet<ASTEntry>>(occurrencesInOtherFiles).entrySet()) {
                HashSet<ASTEntry> set = occurrencesInOtherFiles.get(entry.getKey());
                if (set == null) {
                    occurrencesInOtherFiles.put(entry.getKey(), entry.getValue());
                    continue;
                }
                set.addAll((Collection<ASTEntry>)entry.getValue());
            }
        }
        this.createCurrModuleChange();
        this.createOtherFileChanges();
    }

    private void createOtherFileChanges() {
        for (Map.Entry<Tuple<String, File>, HashSet<ASTEntry>> entry : this.fileOccurrences.entrySet()) {
            Tuple<String, File> tup = entry.getKey();
            IFile workspaceFile = null;
            try {
                workspaceFile = new PySourceLocatorBase().getWorkspaceFile((File)tup.o2);
                if (workspaceFile == null) {
                    this.status.addWarning(StringUtils.format((String)"Error. Unable to resolve the file:\n%s\nto a file in the Eclipse workspace.", (Object[])new Object[]{tup.o2}));
                    continue;
                }
            }
            catch (IllegalStateException e) {
                String message = e.getMessage();
                if (message != null && message.equals("Workspace is closed.")) continue;
                throw e;
            }
            HashSet<ASTEntry> astEntries = this.filterAstEntries(entry.getValue(), 1);
            if (astEntries.size() > 0) {
                IDocument docFromResource = REF.getDocFromResource((IResource)workspaceFile);
                PyTextFileChange fileChange = new PyTextFileChange("RenameChange: " + this.inputName, workspaceFile);
                MultiTextEdit rootEdit = new MultiTextEdit();
                fileChange.setEdit((TextEdit)rootEdit);
                fileChange.setKeepPreviewEdits(true);
                List<Tuple<TextEdit, String>> renameEdits = this.getAllRenameEdits(docFromResource, astEntries);
                this.fillEditsInDocChange((TextChange)fileChange, rootEdit, renameEdits);
            }
            if ((astEntries = this.filterAstEntries(entry.getValue(), 2)).size() <= 0) continue;
            IFile resourceToRename = workspaceFile;
            String newName = String.valueOf(this.inputName) + ".py";
            if (((String)tup.o1).endsWith(".__init__") && !this.initialName.equals("__init__")) {
                resourceToRename = resourceToRename.getParent();
                newName = this.inputName;
                if (!resourceToRename.getName().equals(this.initialName)) {
                    this.status.addFatalError(StringUtils.format((String)"Error. The package that was found (%s) for renaming does not match the initial token found (%s)", (Object[])new Object[]{resourceToRename.getName(), this.initialName}));
                    return;
                }
            }
            this.fChange.add((Change)new PyRenameResourceChange((IResource)resourceToRename, newName, StringUtils.format((String)"Renaming %s to %s", (Object[])new Object[]{resourceToRename.getName(), this.inputName})));
        }
    }

    private HashSet<ASTEntry> filterAstEntries(HashSet<ASTEntry> value, int astEntryFilter) {
        HashSet<ASTEntry> ret = new HashSet<ASTEntry>();
        for (ASTEntry entry : value) {
            if (entry instanceof ASTEntryWithSourceModule) {
                if ((astEntryFilter & 2) == 0) continue;
                ret.add(entry);
                continue;
            }
            if ((astEntryFilter & 1) == 0) continue;
            ret.add(entry);
        }
        return ret;
    }

    private void createCurrModuleChange() {
        Object docChange = this.currentFile != null ? new PyTextFileChange("Current module: " + this.moduleName, this.currentFile) : PyDocumentChange.create((String)("Current module: " + this.moduleName), (IDocument)this.currentDoc);
        if (this.docOccurrences.size() == 0) {
            this.status.addFatalError("No occurrences found.");
            return;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        docChange.setEdit((TextEdit)rootEdit);
        docChange.setKeepPreviewEdits(true);
        List<Tuple<TextEdit, String>> renameEdits = this.getAllRenameEdits(this.currentDoc, this.docOccurrences);
        this.fillEditsInDocChange((TextChange)docChange, rootEdit, renameEdits);
    }

    private void fillEditsInDocChange(TextChange docChange, MultiTextEdit rootEdit, List<Tuple<TextEdit, String>> renameEdits) {
        boolean addedEdit = false;
        for (Tuple<TextEdit, String> t : renameEdits) {
            addedEdit = true;
            rootEdit.addChild((TextEdit)t.o1);
            docChange.addTextEditGroup(new TextEditGroup((String)t.o2, (TextEdit)t.o1));
        }
        if (addedEdit) {
            this.fChange.add((Change)docChange);
        }
    }

    protected TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.initialName.length(), this.inputName);
    }

    protected List<Tuple<TextEdit, String>> getAllRenameEdits(IDocument doc, HashSet<ASTEntry> occurrences) {
        HashSet<Integer> s = new HashSet<Integer>();
        ArrayList<Tuple<TextEdit, String>> ret = new ArrayList<Tuple<TextEdit, String>>();
        FastStringBuffer entryBuf = new FastStringBuffer();
        for (ASTEntry entry : occurrences) {
            entryBuf.clear();
            Integer loc = (Integer)entry.getAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)0);
            if (loc == 2) {
                entryBuf.append("Change (comment): ");
            } else if (loc == 1) {
                entryBuf.append("Change (string): ");
            } else {
                entryBuf.append("Change: ");
            }
            entryBuf.append(this.initialName);
            entryBuf.append(" >> ");
            entryBuf.append(this.inputName);
            entryBuf.append(" (line:");
            entryBuf.append(entry.node.beginLine);
            entryBuf.append(")");
            int offset = AbstractRenameRefactorProcess.getOffset(doc, entry);
            if (s.contains(offset)) continue;
            s.add(offset);
            ret.add((Tuple<TextEdit, String>)new Tuple((Object)this.createRenameEdit(offset), (Object)entryBuf.toString()));
        }
        return ret;
    }
}

