/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalysis;
import com.python.pydev.refactoring.wizards.rename.PyRenameFunctionProcess;
import com.python.pydev.refactoring.wizards.rename.visitors.FindCallVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.KeywordParameterDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRenameParameterProcess
extends PyRenameFunctionProcess {
    private String functionName;
    private ASTEntry singleEntry;

    public PyRenameParameterProcess(KeywordParameterDefinition definition, IPythonNature nature) {
        IDefinition[] definitions;
        Assert.isNotNull((Object)definition.scope, (String)"The scope for a rename parameter must always be provided.");
        String tok = NodeUtils.getFullRepresentationString((SimpleNode)definition.call);
        int line = definition.call.beginLine;
        int col = definition.call.beginColumn;
        try {
            definitions = definition.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)tok, (IPythonNature)nature, (int)(line - 1), (int)(col - 1), (ICompletionCache)new CompletionCache()), line, col, nature);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (definitions != null && definitions.length > 0) {
            this.init((Definition)definitions[0]);
        } else {
            this.singleEntry = new ASTEntry(null);
            this.singleEntry.node = definition.ast;
        }
    }

    @Override
    protected void findReferencesToRenameOnLocalScope(RefactoringRequest request, RefactoringStatus status) {
        if (this.singleEntry == null) {
            super.findReferencesToRenameOnLocalScope(request, status);
        } else {
            this.docOccurrences.add(this.singleEntry);
        }
    }

    @Override
    protected void findReferencesToRenameOnWorkspace(RefactoringRequest request, RefactoringStatus status) {
        if (this.singleEntry == null) {
            super.findReferencesToRenameOnWorkspace(request, status);
        } else {
            this.docOccurrences.add(this.singleEntry);
        }
    }

    public PyRenameParameterProcess(Definition definition) {
        this.init(definition);
    }

    private void init(Definition definition) {
        Assert.isNotNull((Object)definition.scope, (String)"The scope for a rename parameter must always be provided.");
        FunctionDef node = definition.ast instanceof FunctionDef ? (FunctionDef)definition.ast : (FunctionDef)definition.scope.getScopeStack().peek();
        this.definition = new Definition(node.beginLine, node.beginColumn, ((NameTok)node.name).id, (SimpleNode)node, definition.scope, definition.module);
        this.functionName = ((NameTok)node.name).id;
    }

    @Override
    protected List<ASTEntry> getEntryOccurrencesInSameModule(RefactoringStatus status, String initialName, SimpleNode root) {
        List<ASTEntry> occurrences = super.getEntryOccurrencesInSameModule(status, this.functionName, root);
        return this.getParameterOccurences(occurrences, root);
    }

    @Override
    protected List<ASTEntry> getOccurrencesInOtherModule(RefactoringStatus status, String initialName, SourceModule module, PythonNature nature) {
        List<ASTEntry> occurrences = super.getOccurrencesInOtherModule(status, this.functionName, module, nature);
        return this.getParameterOccurences(occurrences, module.getAst());
    }

    private List<ASTEntry> getParameterOccurences(List<ASTEntry> occurrences, SimpleNode root) {
        ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        ArrayList<Tuple> acceptedCommentRanges = new ArrayList<Tuple>();
        for (ASTEntry entry : occurrences) {
            if (entry.node instanceof Name) {
                Name name = (Name)entry.node;
                if (name.ctx == 7) continue;
            }
            if (entry.parent != null && entry.parent.node instanceof FunctionDef && entry.node instanceof NameTok && ((NameTok)entry.node).ctx == 2) {
                this.processFunctionDef(ret, entry);
                ASTEntry parent = entry.parent;
                acceptedCommentRanges.add(new Tuple((Object)parent.node.beginLine, (Object)parent.endLine));
                continue;
            }
            if (entry.node instanceof Name) {
                this.processFoundName(root, ret, (Name)entry.node);
                continue;
            }
            if (!(entry.node instanceof NameTok)) continue;
            this.processFoundNameTok(root, ret, (NameTok)entry.node);
        }
        if (ret.size() > 0) {
            List commentOccurrences = ScopeAnalysis.getCommentOccurrences((String)this.request.initialName, (SimpleNode)root);
            for (ASTEntry commentOccurrence : commentOccurrences) {
                for (Tuple range : acceptedCommentRanges) {
                    if (commentOccurrence.node.beginLine < (Integer)range.o1 || commentOccurrence.node.beginLine > (Integer)range.o2) continue;
                    ret.add(commentOccurrence);
                }
            }
        }
        return ret;
    }

    private void processFunctionDef(List<ASTEntry> ret, ASTEntry entry) {
        FunctionDef node = (FunctionDef)entry.parent.node;
        List found = ScopeAnalysis.getLocalOccurrences((String)this.request.initialName, (SimpleNode)node);
        ret.addAll(ScopeAnalysis.getStringOccurrences((String)this.request.initialName, (SimpleNode)node));
        ret.addAll(found);
    }

    private void processFoundNameTok(SimpleNode root, List<ASTEntry> ret, NameTok name) {
        if (name.ctx == 8) {
            Call call = FindCallVisitor.findCall(name, root);
            this.processCall(ret, call);
        }
    }

    private void processFoundName(SimpleNode root, List<ASTEntry> ret, Name name) {
        if (name.ctx == 1) {
            Call call = FindCallVisitor.findCall(name, root);
            this.processCall(ret, call);
        }
    }

    private void processCall(List<ASTEntry> ret, Call call) {
        if (call == null) {
            return;
        }
        List found = ScopeAnalysis.getLocalOccurrences((String)this.request.initialName, (SimpleNode)call);
        for (ASTEntry entry2 : found) {
            if (!(entry2.node instanceof NameTok)) continue;
            NameTok name2 = (NameTok)entry2.node;
            if (name2.ctx != 3) continue;
            ret.add(entry2);
        }
    }
}

