/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalysis;
import com.python.pydev.analysis.scopeanalysis.ScopeAnalyzerVisitorForImports;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameWorkspaceRefactorProcess;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IModule;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.modules.ASTEntryWithSourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.scope.ASTEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRenameImportProcess
extends AbstractRenameWorkspaceRefactorProcess {
    public static final int TYPE_RENAME_MODULE = 1;
    public static final int TYPE_RENAME_UNRESOLVED_IMPORT = 2;
    protected int type = -1;
    protected SourceModule moduleToFind;

    public PyRenameImportProcess(Definition definition) {
        super(definition);
        this.type = definition.ast == null ? 1 : 2;
    }

    @Override
    protected void findReferencesToRenameOnLocalScope(RefactoringRequest request, RefactoringStatus status) {
        List<ASTEntry> oc = this.getOccurrencesWithScopeAnalyzer(request);
        SimpleNode root = request.getAST();
        if (oc.size() > 0) {
            oc.addAll(ScopeAnalysis.getCommentOccurrences((String)request.initialName, (SimpleNode)root));
            oc.addAll(ScopeAnalysis.getStringOccurrences((String)request.initialName, (SimpleNode)root));
        }
        this.addOccurrences(request, oc);
    }

    @Override
    protected void doCheckInitialOnWorkspace(RefactoringStatus status, RefactoringRequest request) {
        boolean wasResolved = false;
        if (this.docOccurrences.size() != 0) {
            ASTEntry entry = (ASTEntry)this.docOccurrences.iterator().next();
            Found found = (Found)entry.getAdditionalInfo("FOUND_ADDITIONAL_INFO_IN_AST_ENTRY", null);
            if (found == null) {
                throw new RuntimeException("Expecting decorated entry.");
            }
            if (found.importInfo == null) {
                throw new RuntimeException("Expecting import info from the found entry.");
            }
            if (found.importInfo.wasResolved) {
                Definition d = found.importInfo.getModuleDefinitionFromImportInfo(request.nature, (ICompletionCache)new CompletionCache());
                if (d == null || d.module == null) {
                    status.addFatalError(StringUtils.format((String)"Unable to find the definition for the module.", (Object[])new Object[0]));
                    return;
                }
                if (!(d.module instanceof SourceModule)) {
                    status.addFatalError(StringUtils.format((String)"Only source modules may be renamed (the module %s was found as a %s module)", (Object[])new Object[]{d.module.getName(), d.module.getClass()}));
                    return;
                }
                this.moduleToFind = (SourceModule)d.module;
                wasResolved = true;
                if (!(found.importInfo.mod instanceof SourceModule)) {
                    status.addFatalError(StringUtils.format((String)"Error. The module %s may not be renamed\n(Because it was found as a compiled extension).", (Object[])new Object[]{found.importInfo.mod.getName()}));
                    return;
                }
                ISystemModulesManager systemModulesManager = request.nature.getAstManager().getModulesManager().getSystemModulesManager();
                IModule systemModule = systemModulesManager.getModule(found.importInfo.mod.getName(), request.nature, true);
                if (systemModule != null) {
                    status.addFatalError(StringUtils.format((String)"Error. The module '%s' may not be renamed\nOnly project modules may be renamed\n(and it was found as being a system module).", (Object[])new Object[]{found.importInfo.mod.getName()}));
                    return;
                }
                ArrayList<ASTEntry> lst = new ArrayList<ASTEntry>();
                lst.add((ASTEntry)new ASTEntryWithSourceModule(this.moduleToFind));
                this.addOccurrences(lst, this.moduleToFind.getFile(), this.moduleToFind.getName());
            }
        }
        if (wasResolved) {
            super.doCheckInitialOnWorkspace(status, request);
        }
    }

    @Override
    protected List<ASTEntry> findReferencesOnOtherModule(RefactoringStatus status, String initialName, SourceModule module) {
        List<Object> entryOccurrences = new ArrayList<ASTEntry>();
        try {
            ScopeAnalyzerVisitorForImports visitor = new ScopeAnalyzerVisitorForImports(this.request.nature, module.getName(), (IModule)module, (IProgressMonitor)new NullProgressMonitor(), (String)this.request.ps.getCurrToken().o1, this.request.ps.getActivationTokenAndQual(true), this.moduleToFind);
            SimpleNode root = module.getAst();
            root.accept((VisitorIF)visitor);
            entryOccurrences = visitor.getEntryOccurrences();
            if (entryOccurrences.size() > 0) {
                entryOccurrences.addAll(ScopeAnalysis.getCommentOccurrences((String)this.request.initialName, (SimpleNode)root));
                entryOccurrences.addAll(ScopeAnalysis.getStringOccurrences((String)this.request.initialName, (SimpleNode)root));
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return entryOccurrences;
    }

    @Override
    protected boolean getRecheckWhereDefinitionWasFound() {
        return false;
    }
}

