/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.actions;

import com.python.pydev.actions.LabelProviderWithDecoration;
import com.python.pydev.actions.OutlineEntry;
import com.python.pydev.actions.ShowOutlineLabelProvider;
import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.python.pydev.ui.hierarchy.TreeNode;
import com.python.pydev.ui.hierarchy.TreeNodeContentProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IModule;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.DialogMemento;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.ui.dialogs.TreeSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PyOutlineSelectionDialog
extends TreeSelectionDialog {
    private boolean showParentHierarchy;
    private Label labelCtrlO;
    private PyEdit pyEdit;
    private HashMap<SimpleNode, HierarchyNodeModel> nodeToModel;
    private SimpleNode ast;
    private TreeNode<OutlineEntry> root;
    private TreeNode<OutlineEntry> rootWithParents;
    private final DialogMemento memento;
    private KeyListener ctrlOlistener;
    private int startLineIndex = -1;
    private TreeNode<OutlineEntry> initialSelection;
    private final UIJob uiJobSetRootWithParentsInput = new UIJob("Set input"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                PyOutlineSelectionDialog.this.getTreeViewer().setInput((Object)PyOutlineSelectionDialog.this.rootWithParents);
            } else {
                PyOutlineSelectionDialog.this.rootWithParents = null;
            }
            return Status.OK_STATUS;
        }
    };
    private final Job jobCalculateParents = new Job("Calculate parents"){

        public IStatus run(IProgressMonitor monitor) {
            PyOutlineSelectionDialog.this.rootWithParents = PyOutlineSelectionDialog.this.root.createCopy(null);
            if (PyOutlineSelectionDialog.this.nodeToModel == null) {
                PyOutlineSelectionDialog.this.nodeToModel = new HashMap();
                ArrayList gathered = new ArrayList();
                PyOutlineSelectionDialog.this.gatherClasses(PyOutlineSelectionDialog.this.rootWithParents, monitor, gathered);
                monitor.beginTask("Calculate parents", gathered.size() + 1);
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                IPyRefactoring2 r2 = (IPyRefactoring2)pyRefactoring;
                for (Tuple t : gathered) {
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        ClassDef classDef = (ClassDef)t.o1;
                        PySelection ps = new PySelection(PyOutlineSelectionDialog.this.pyEdit.getDocument(), classDef.name.beginLine - 1, classDef.name.beginColumn - 1);
                        try {
                            RefactoringRequest refactoringRequest = PyRefactorAction.createRefactoringRequest((IProgressMonitor)subProgressMonitor, (PyEdit)PyOutlineSelectionDialog.this.pyEdit, (PySelection)ps);
                            HierarchyNodeModel model = r2.findClassHierarchy(refactoringRequest, true);
                            PyOutlineSelectionDialog.this.nodeToModel.put(((OutlineEntry)((TreeNode)t.o2).data).node, model);
                        }
                        catch (MisconfigurationException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    finally {
                        subProgressMonitor.done();
                    }
                }
            }
            if (!monitor.isCanceled()) {
                PyOutlineSelectionDialog.this.fillHierarchy(PyOutlineSelectionDialog.this.rootWithParents);
            }
            if (!monitor.isCanceled()) {
                PyOutlineSelectionDialog.this.uiJobSetRootWithParentsInput.setPriority(10);
                PyOutlineSelectionDialog.this.uiJobSetRootWithParentsInput.schedule();
            } else {
                PyOutlineSelectionDialog.this.rootWithParents = null;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    };

    private PyOutlineSelectionDialog(Shell shell) {
        super(shell, PyOutlineSelectionDialog.createLabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider());
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.memento = CorePlugin.getDefault() != null ? new DialogMemento(this.getShell(), "com.python.pydev.actions.PyShowOutline") : null;
        this.setMessage("Filter (press enter to go to selected element)");
        this.setTitle("PyDev: Quick Outline");
        this.setAllowMultiple(false);
        this.showParentHierarchy = false;
    }

    protected static ILabelProvider createLabelProvider() {
        try {
            return new LabelProviderWithDecoration(new ShowOutlineLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        }
        catch (Throwable throwable) {
            return new ShowOutlineLabelProvider();
        }
    }

    public PyOutlineSelectionDialog(Shell shell, SimpleNode ast, HashMap<SimpleNode, HierarchyNodeModel> nodeToModel) {
        this(shell);
        this.ast = ast;
        this.nodeToModel = nodeToModel;
        this.calculateHierarchy();
        this.setInput(this.root);
    }

    public PyOutlineSelectionDialog(Shell shell, PyEdit pyEdit) {
        this(shell);
        this.pyEdit = pyEdit;
        PySelection ps = this.pyEdit.createPySelection();
        this.startLineIndex = ps.getStartLineIndex() + 1;
        this.calculateHierarchy();
        this.setInput(this.root);
        if (this.initialSelection != null) {
            this.setInitialSelections(new Object[]{this.initialSelection});
        }
    }

    public boolean close() {
        if (this.memento != null) {
            this.memento.writeSettings(this.getShell());
        }
        return super.close();
    }

    protected Point getInitialSize() {
        if (this.memento != null) {
            return this.memento.getInitialSize(super.getInitialSize(), this.getShell());
        }
        return new Point(640, 480);
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.memento != null) {
            return this.memento.getInitialLocation(initialSize, super.getInitialLocation(initialSize), this.getShell());
        }
        return new Point(250, 250);
    }

    public Control createDialogArea(Composite parent) {
        if (this.memento != null) {
            this.memento.readSettings();
        }
        Control ret = super.createDialogArea(parent);
        this.ctrlOlistener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 111 || e.keyCode == 79) && e.stateMask == 262144) {
                    PyOutlineSelectionDialog.this.toggleShowParentHierarchy();
                }
            }
        };
        this.text.addKeyListener(this.ctrlOlistener);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) {
                    PyOutlineSelectionDialog.this.okPressed();
                }
            }
        });
        this.getTreeViewer().getTree().addKeyListener(this.ctrlOlistener);
        return ret;
    }

    protected void updateShowParentHierarchyMessage() {
        if (this.showParentHierarchy) {
            this.labelCtrlO.setText("Press Ctrl+O to hide parent hierarchy.");
        } else {
            this.labelCtrlO.setText("Press Ctrl+O to show parent hierarchy.");
        }
    }

    protected int getDefaultMargins() {
        return 0;
    }

    protected int getDefaultSpacing() {
        return 0;
    }

    protected Control createButtonBar(Composite parent) {
        this.labelCtrlO = new Label(parent, 0);
        this.labelCtrlO.addKeyListener(this.ctrlOlistener);
        this.updateShowParentHierarchyMessage();
        return this.labelCtrlO;
    }

    protected void toggleShowParentHierarchy() {
        this.showParentHierarchy = !this.showParentHierarchy;
        this.updateShowParentHierarchyMessage();
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.showParentHierarchy) {
            this.calculateHierarchyWithParents();
        } else {
            this.calculateHierarchy();
            treeViewer.setInput(this.root);
        }
    }

    private void calculateHierarchy() {
        if (this.root != null) {
            return;
        }
        if (this.ast == null && this.pyEdit != null) {
            this.ast = this.pyEdit.getAST();
        }
        if (this.ast == null) {
            return;
        }
        DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.create((SimpleNode)this.ast);
        if (visitor == null) {
            return;
        }
        HashMap<ASTEntry, TreeNode<OutlineEntry>> entryToTreeNode = new HashMap<ASTEntry, TreeNode<OutlineEntry>>();
        TreeNode<Object> root = new TreeNode<Object>(null, null, null);
        Iterator it = visitor.getOutline();
        while (it.hasNext()) {
            TreeNode<OutlineEntry> n;
            ASTEntry next = (ASTEntry)it.next();
            if (next.parent != null) {
                TreeNode<Object> parent = (TreeNode<Object>)entryToTreeNode.get(next.parent);
                if (parent == null) {
                    Log.log((String)"Unexpected condition: child found before parent!");
                    parent = root;
                }
                n = new TreeNode<OutlineEntry>(parent, new OutlineEntry(next), null);
            } else {
                n = new TreeNode<OutlineEntry>(root, new OutlineEntry(next), null);
            }
            if (((OutlineEntry)n.data).node.beginLine <= this.startLineIndex) {
                this.initialSelection = n;
            }
            entryToTreeNode.put(next, n);
        }
        this.root = root;
    }

    private void calculateHierarchyWithParents() {
        if (this.rootWithParents != null) {
            this.uiJobSetRootWithParentsInput.setPriority(10);
            this.uiJobSetRootWithParentsInput.schedule();
            return;
        }
        this.calculateHierarchy();
        if (this.root == null) {
            return;
        }
        this.jobCalculateParents.setPriority(10);
        this.jobCalculateParents.schedule();
    }

    private void fillHierarchy(TreeNode<OutlineEntry> entry) {
        ArrayList copy = new ArrayList(entry.children);
        for (TreeNode<OutlineEntry> treeNode : copy) {
            HierarchyNodeModel model = this.nodeToModel.get(((OutlineEntry)treeNode.data).node);
            this.addMethods(treeNode, model);
            this.fillHierarchy(treeNode);
        }
    }

    private void addMethods(TreeNode<OutlineEntry> nextEntry, HierarchyNodeModel model) {
        if (model == null || model.parents == null) {
            return;
        }
        for (HierarchyNodeModel parent : model.parents) {
            DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.createForChildren((ClassDef)parent.ast);
            if (visitor == null) continue;
            Iterator outline = visitor.getOutline();
            while (outline.hasNext()) {
                ASTEntry entry = (ASTEntry)outline.next();
                if (entry.parent != null) continue;
                new TreeNode<OutlineEntry>(nextEntry, new OutlineEntry(entry, parent), null);
            }
            this.addMethods(nextEntry, parent);
        }
    }

    private void gatherClasses(TreeNode<OutlineEntry> entry, IProgressMonitor monitor, List<Tuple<ClassDef, TreeNode<OutlineEntry>>> gathered) {
        if (entry.children.size() == 0) {
            return;
        }
        for (TreeNode<OutlineEntry> treeNode : entry.children) {
            if (((OutlineEntry)treeNode.data).node instanceof ClassDef) {
                ClassDef classDef = (ClassDef)((OutlineEntry)treeNode.data).node;
                gathered.add((Tuple<ClassDef, TreeNode<OutlineEntry>>)new Tuple((Object)classDef, treeNode));
            }
            this.gatherClasses(treeNode, monitor, gathered);
        }
    }

    protected void configureShell(final Shell shell) {
        super.configureShell(shell);
        shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                shell.close();
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
    }

    public int open() {
        Object[] result;
        int ret = super.open();
        if (ret == 0 && (result = this.getResult()) != null && result.length > 0) {
            TreeNode n = (TreeNode)result[0];
            OutlineEntry outlineEntry = (OutlineEntry)n.data;
            if (outlineEntry.model == null) {
                Location location = new Location(NodeUtils.getNameLineDefinition((SimpleNode)outlineEntry.node) - 1, NodeUtils.getNameColDefinition((SimpleNode)outlineEntry.node) - 1);
                new PyOpenAction().showInEditor((ITextEditor)this.pyEdit, location, location);
            } else {
                SourceModule sourceModule;
                File file;
                PyOpenAction pyOpenAction = new PyOpenAction();
                IModule m = outlineEntry.model.module;
                if (m instanceof SourceModule && (file = (sourceModule = (SourceModule)m).getFile()) != null) {
                    ItemPointer p = new ItemPointer((Object)file, outlineEntry.node);
                    pyOpenAction.run(p);
                }
            }
        }
        return ret;
    }
}

