/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.concurrency.IRunnableWithMonitor;
import org.python.pydev.core.concurrency.Semaphore;
import org.python.pydev.core.log.Log;

public class RunnableAsJobsPoolThread
extends Thread {
    private final Semaphore jobsCreationSemaphore;
    private final Semaphore canRunSemaphore = new Semaphore(0L);
    private final List<Tuple<Runnable, String>> runnables = new ArrayList<Tuple<Runnable, String>>();
    private final Object lockRunnables = new Object();
    private static RunnableAsJobsPoolThread singleton;

    public RunnableAsJobsPoolThread(int maxSize) {
        this.jobsCreationSemaphore = new Semaphore(maxSize);
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            int size;
            this.canRunSemaphore.acquire();
            Tuple<Runnable, String> execute = null;
            Object object = this.lockRunnables;
            synchronized (object) {
                size = this.runnables.size();
                if (size > 0) {
                    execute = this.runnables.remove(0);
                    --size;
                }
            }
            if (execute == null) continue;
            this.jobsCreationSemaphore.acquire();
            final Runnable[] runnable = new Runnable[]{(Runnable)execute.o1};
            String name = (String)execute.o2;
            execute = null;
            if (size > 1) {
                name = String.valueOf(name) + " (" + size + " scheduled)";
            }
            Job workbenchJob = new Job(name){

                public IStatus run(IProgressMonitor monitor) {
                    Runnable r;
                    try {
                        try {
                            r = runnable[0];
                            if (r instanceof IRunnableWithMonitor) {
                                ((IRunnableWithMonitor)r).setMonitor(monitor);
                            }
                            runnable[0] = null;
                            r.run();
                        }
                        catch (RuntimeException e) {
                            if (CorePlugin.getDefault() != null) {
                                Log.log(e);
                            }
                            Object r2 = null;
                            RunnableAsJobsPoolThread.this.jobsCreationSemaphore.release();
                        }
                    }
                    finally {
                        r = null;
                        RunnableAsJobsPoolThread.this.jobsCreationSemaphore.release();
                    }
                    return Status.OK_STATUS;
                }
            };
            workbenchJob.setPriority(10);
            workbenchJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleToRun(IRunnableWithMonitor runnable, String name) {
        Object object = this.lockRunnables;
        synchronized (object) {
            this.runnables.add(new Tuple<IRunnableWithMonitor, String>(runnable, name));
        }
        this.canRunSemaphore.release();
    }

    public static synchronized RunnableAsJobsPoolThread getSingleton() {
        if (singleton == null) {
            int maxSize = 6;
            try {
                int availableProcessors = Runtime.getRuntime().availableProcessors();
                maxSize = availableProcessors <= 1 ? 3 : (int)((long)availableProcessors + Math.round(REF.log(availableProcessors, 1.4)));
            }
            catch (Throwable throwable) {}
            singleton = new RunnableAsJobsPoolThread(maxSize);
        }
        return singleton;
    }
}

