/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REF {
    private static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=][\\s]*([-\\w.]+)");
    public static char[] INVALID_FILESYSTEM_CHARS = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '=', '+', '.', ' ', '`', '~', '\'', '\"', ',', ';'};
    public static boolean IN_TESTS = false;
    public static String BOM_UTF8 = new String(new char[]{'\u00ef', '\u00bb', '\u00bf'});
    public static String BOM_UNICODE = new String(new char[]{'\ufeff'});
    public static boolean LOG_ENCODING_ERROR = true;
    public static Integer platform;
    public static int WINDOWS;
    public static int MACOS;
    public static int LINUX;
    private static final Map<File, Set<String>> alreadyReturned;
    private static Object lockTempFiles;
    private static String openDirExecutable;
    private static final String OPEN_DIR_EXEC_NOT_AVAILABLE = "NOT_AVAILABLE";

    static {
        WINDOWS = 1;
        MACOS = 2;
        LINUX = 3;
        alreadyReturned = new HashMap<File, Set<String>>();
        lockTempFiles = new Object();
        openDirExecutable = null;
    }

    public static boolean hasAttr(Object o, String attr) {
        try {
            o.getClass().getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        return true;
    }

    public static Field getAttrFromClass(Class<? extends Object> c, String attr) {
        try {
            return c.getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    public static Field getAttr(Object o, String attr) {
        try {
            return o.getClass().getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    public static Object getAttrObj(Object o, String attr) {
        return REF.getAttrObj(o, attr, false);
    }

    public static Object getAttrObj(Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        return REF.getAttrObj(o.getClass(), o, attr, raiseExceptionIfNotAvailable);
    }

    public static Object getAttrObj(Class<? extends Object> c, Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        block4: {
            try {
                Field field = REF.getAttrFromClass(c, attr);
                if (field != null) {
                    if ((field.getModifiers() & 1) == 0) {
                        field.setAccessible(true);
                    }
                    Object obj = field.get(o);
                    return obj;
                }
            }
            catch (Exception e) {
                if (!raiseExceptionIfNotAvailable) break block4;
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String getFileContents(File file) {
        return (String)REF.getFileContentsCustom(file, String.class);
    }

    public static Object getFileContentsCustom(File file, Class<? extends Object> returnType) {
        return REF.getFileContentsCustom(file, null, returnType);
    }

    public static Object getFileContentsCustom(File file, String encoding, Class<? extends Object> returnType) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            Object object = REF.getStreamContents(stream, null, null, returnType);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static String getStreamContents(InputStream stream, String encoding, IProgressMonitor monitor) {
        try {
            String string = (String)REF.getStreamContents(stream, encoding, monitor, String.class);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    private static Object getStreamContents(InputStream contentStream, String encoding, IProgressMonitor monitor, Class<? extends Object> returnType) throws IOException {
        Reader in = null;
        try {
            int BUFFER_SIZE = 2048;
            int DEFAULT_FILE_SIZE = 8 * BUFFER_SIZE;
            int available = contentStream.available();
            if (DEFAULT_FILE_SIZE < available) {
                DEFAULT_FILE_SIZE = available;
            }
            if (encoding == null) {
                in = new InputStreamReader(contentStream);
            } else {
                try {
                    in = new InputStreamReader(contentStream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    Log.log(e);
                    in = new InputStreamReader(contentStream);
                }
            }
            FastStringBuffer buffer = new FastStringBuffer(DEFAULT_FILE_SIZE);
            char[] readBuffer = new char[BUFFER_SIZE];
            int n = in.read(readBuffer);
            while (n > 0) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            if (returnType == null || returnType == FastStringBuffer.class) {
                FastStringBuffer fastStringBuffer = buffer;
                return fastStringBuffer;
            }
            if (returnType == IDocument.class) {
                Document doc;
                Document document = doc = new Document(buffer.toString());
                return document;
            }
            if (returnType == String.class) {
                String string = buffer.toString();
                return string;
            }
            throw new RuntimeException("Don't know how to handle return type: " + returnType);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static String getObjAsStr(Object o) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(o);
            stream.close();
        }
        catch (Exception e) {
            Log.log(e);
            throw new RuntimeException(e);
        }
        return new String(REF.encodeBase64(out));
    }

    public static byte[] encodeBase64(ByteArrayOutputStream out) {
        byte[] byteArray = out.toByteArray();
        return REF.encodeBase64(byteArray);
    }

    public static byte[] encodeBase64(byte[] byteArray) {
        return Base64.encodeBase64((byte[])byteArray);
    }

    public static Object readFromInputStreamAndCloseIt(ICallback<Object, ObjectInputStream> readFromFileMethod, InputStream input) {
        ObjectInputStream in = null;
        Object o = null;
        try {
            try {
                in = new ObjectInputStream(input);
                o = readFromFileMethod.call(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                input.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public static byte[] decodeBase64(String persisted) {
        return Base64.decodeBase64((byte[])persisted.getBytes());
    }

    public static void appendStrToFile(String str, String file) {
        try {
            FileOutputStream stream = new FileOutputStream(file, true);
            try {
                stream.write(str.getBytes());
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeStrToFile(String str, String file) {
        REF.writeStrToFile(str, new File(file));
    }

    public static void writeStrToFile(String str, File file) {
        REF.writeBytesToFile(str.getBytes(), file);
    }

    public static void writeBytesToFile(byte[] bytes, File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                stream.write(bytes);
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeToFile(Object o, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            REF.writeToStreamAndCloseIt(o, out);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static void writeToStreamAndCloseIt(Object o, OutputStream out) throws IOException {
        OutputStream b = null;
        b = out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out);
        try {
            try {
                ObjectOutputStream stream = new ObjectOutputStream(b);
                stream.writeObject(o);
                stream.close();
            }
            catch (Exception e) {
                Log.log(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            b.close();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object readFromFile(File file) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                Object object;
                ObjectInputStream stream = new ObjectInputStream(in);
                try {
                    Object o;
                    object = o = stream.readObject();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return object;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    public static String getFileAbsolutePath(String f) {
        return REF.getFileAbsolutePath(new File(f));
    }

    public static String getFileAbsolutePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException iOException) {
            return f.getAbsolutePath();
        }
    }

    public static Object invoke(Object obj, String name, Object ... args) {
        Method m = REF.findMethod(obj, name, args);
        return REF.invoke(obj, m, args);
    }

    public static Object invoke(Object obj, Method m, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Object obj, String name, Object ... args) {
        return REF.findMethod(obj.getClass(), name, args);
    }

    public static Method findMethod(Class<? extends Object> class_, String name, Object ... args) {
        try {
            Method[] methods;
            Method[] methodArray = methods = class_.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (method.getName().equals(name) && parameterTypes.length == args.length) {
                    int i = 0;
                    Class<?>[] classArray = parameterTypes;
                    int n3 = parameterTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> param = classArray[n4];
                        if (param.isInstance(args[i])) {
                            ++i;
                        }
                        ++n4;
                    }
                    return method;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("The method with name: " + name + " was not found (or maybe it was found but the parameters didn't match).");
    }

    public static String getValidProjectName(IProject project) {
        String name = project.getName();
        char[] cArray = INVALID_FILESYSTEM_CHARS;
        int n = INVALID_FILESYSTEM_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            name = name.replace(c, '_');
            ++n2;
        }
        return name;
    }

    public static boolean nullEq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static IDocument getDocFromFile(File f) throws IOException {
        return REF.getDocFromFile(f, true);
    }

    public static String getStringFromZip(File f, String pathInZip) throws Exception {
        return (String)REF.getCustomReturnFromZip(f, pathInZip, String.class);
    }

    public static IDocument getDocFromZip(File f, String pathInZip) throws Exception {
        return (IDocument)REF.getCustomReturnFromZip(f, pathInZip, IDocument.class);
    }

    public static Object getCustomReturnFromZip(File f, String pathInZip, Class<? extends Object> returnType) throws Exception {
        ZipFile zipFile = new ZipFile(f, 1);
        try {
            Object object;
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(pathInZip));
            try {
                object = REF.getStreamContents(inputStream, null, null, returnType);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
        finally {
            zipFile.close();
        }
    }

    public static String getStringFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (String)REF.getCustomReturnFromFile(f, loadIfNotInWorkspace, String.class);
    }

    public static IDocument getDocFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (IDocument)REF.getCustomReturnFromFile(f, loadIfNotInWorkspace, IDocument.class);
    }

    public static Object getCustomReturnFromFile(File f, boolean loadIfNotInWorkspace, Class<? extends Object> returnType) throws IOException {
        IPath path = Path.fromOSString((String)REF.getFileAbsolutePath(f));
        IDocument doc = REF.getDocFromPath(path);
        if (doc != null) {
            if (returnType == null || returnType == IDocument.class) {
                return doc;
            }
            if (returnType == String.class) {
                return doc.get();
            }
            if (returnType == FastStringBuffer.class) {
                return new FastStringBuffer(doc.get(), 16);
            }
            throw new RuntimeException("Don't know how to treat requested return type: " + returnType);
        }
        if (doc == null && loadIfNotInWorkspace) {
            FileInputStream stream = new FileInputStream(f);
            try {
                String encoding = REF.getPythonFileEncoding(f);
                Object object = REF.getStreamContents(stream, encoding, null, returnType);
                return object;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITextFileBuffer getBufferFromPath(IPath path) {
        try {
            ITextFileBuffer textFileBuffer;
            ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
            if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path, LocationKind.LOCATION)) == null) return null;
            return textFileBuffer;
        }
        catch (Throwable e) {
            try {
                ITextFileBuffer textFileBuffer;
                if (!(e instanceof ClassNotFoundException) && !(e instanceof LinkageError) && !(e instanceof NoSuchMethodException) && !(e instanceof NoSuchMethodError) && !(e instanceof NoClassDefFoundError)) throw e;
                ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
                if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path)) == null) return null;
                return textFileBuffer;
            }
            catch (Throwable throwable) {
                if (IN_TESTS) return null;
                Log.log("Unable to get doc from text file buffer");
                return null;
            }
        }
    }

    public static IDocument getDocFromPath(IPath path) {
        ITextFileBuffer buffer = REF.getBufferFromPath(path);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    public static ICallback0<IDocument> getDocOnCallbackFromResource(final IResource resource) {
        return new ICallback0<IDocument>(){
            private IDocument cache;
            private boolean calledOnce = false;

            @Override
            public IDocument call() {
                if (!this.calledOnce) {
                    this.calledOnce = true;
                    this.cache = REF.getDocFromResource(resource);
                }
                return this.cache;
            }
        };
    }

    public static IDocument getDocFromResource(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && resource instanceof IFile && resource.exists()) {
            IFile file = (IFile)resource;
            try {
                IPath path;
                IDocument doc;
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((doc = REF.getDocFromPath(path = file.getFullPath())) == null) {
                    doc = (IDocument)REF.getStreamContents(file.getContents(true), null, null, IDocument.class);
                }
                return doc;
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return null;
    }

    public static String getPythonFileEncoding(IDocument doc, String fileLocation) throws IllegalCharsetNameException {
        StringReader inputStreamReader = new StringReader(doc.get());
        return REF.getPythonFileEncoding(inputStreamReader, fileLocation);
    }

    public static String getPythonFileEncoding(File f) throws IllegalCharsetNameException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(f);
        try {
            String pythonFileEncoding;
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
            string = pythonFileEncoding = REF.getPythonFileEncoding(inputStreamReader, f.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    Log.log(e);
                }
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception e) {
            Log.log(e);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static String getPythonFileEncoding(Reader inputStreamReader, String fileLocation) throws IllegalCharsetNameException {
        block19: {
            block18: {
                ret = null;
                reader = new BufferedReader(inputStreamReader);
                lEnc = null;
                l1 = reader.readLine();
                if (l1 == null) ** GOTO lbl18
                if (!l1.startsWith(REF.BOM_UTF8)) break block18;
                try {
                    reader.close();
                }
                catch (IOException v0) {}
                return "utf-8";
            }
            try {
                try {
                    if (l1.indexOf("coding") != -1) {
                        lEnc = l1;
                    }
lbl18:
                    // 4 sources

                    if (lEnc == null) {
                        l2 = reader.readLine();
                        if (l2 != null && l2.indexOf("coding") != -1) {
                            lEnc = l2;
                        } else {
                            ret = null;
                        }
                    }
                    if (lEnc == null) break block19;
                    if ((lEnc = lEnc.trim()).length() == 0) {
                        ret = null;
                        break block19;
                    }
                    if (lEnc.charAt(0) != '#' || !(matcher = REF.ENCODING_PATTERN.matcher(lEnc)).find()) break block19;
                    ret = matcher.group(1).trim();
                }
                catch (IOException e) {
                    Log.log(e);
                    try {
                        reader.close();
                    }
                    catch (IOException v1) {}
                }
            }
            catch (Throwable var7_8) {
                try {
                    reader.close();
                }
                catch (IOException v2) {}
                throw var7_8;
            }
        }
        try {
            reader.close();
        }
        catch (IOException v3) {}
        ret = REF.getValidEncoding(ret, fileLocation);
        return ret;
    }

    static String getValidEncoding(String ret, String fileLocation) {
        block8: {
            block9: {
                block10: {
                    if (ret == null) {
                        return ret;
                    }
                    String lower = ret.trim().toLowerCase();
                    if (lower.startsWith("latin") && lower.indexOf("1") != -1) {
                        return "latin1";
                    }
                    if (lower.equals("iso-latin-1-unix")) {
                        return "latin1";
                    }
                    try {
                        if (Charset.isSupported(ret)) break block8;
                        if (!LOG_ENCODING_ERROR) break block9;
                        if (fileLocation == null || !"uft-8".equals(ret) || !fileLocation.endsWith("bad_coding.py")) break block10;
                        return null;
                    }
                    catch (IllegalCharsetNameException ex) {
                        if (LOG_ENCODING_ERROR) {
                            String msg = "The encoding found: >>" + ret + "<< on " + fileLocation + " is not a valid encoding.";
                            Log.log(4, msg, ex);
                        }
                        return null;
                    }
                }
                String msg = "The encoding found: >>" + ret + "<< on " + fileLocation + " is not a valid encoding.";
                Log.log(4, msg, new UnsupportedEncodingException(msg));
            }
            return null;
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    public static boolean hasPythonShebang(Reader inputStreamReader) throws IllegalCharsetNameException {
        block14: {
            BufferedReader reader;
            block13: {
                reader = new BufferedReader(inputStreamReader);
                String l1 = reader.readLine();
                if (l1 == null) break block13;
                if (l1.startsWith(BOM_UTF8)) {
                    l1 = l1.substring(BOM_UTF8.length());
                }
                if (!l1.startsWith("#!") || l1.indexOf("python") == -1) break block13;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                return true;
                catch (IOException e) {
                    try {
                        Log.log(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static boolean isWindowsPlatform() {
        REF.discoverPlatform();
        return platform == WINDOWS;
    }

    public static boolean isMacOsPlatform() {
        REF.discoverPlatform();
        return platform == MACOS;
    }

    private static void discoverPlatform() {
        if (platform == null) {
            try {
                String os = Platform.getOS();
                platform = os.equals("win32") ? Integer.valueOf(WINDOWS) : (os.equals("macosx") ? Integer.valueOf(MACOS) : Integer.valueOf(LINUX));
            }
            catch (NullPointerException nullPointerException) {
                String env = System.getProperty("os.name").toLowerCase();
                platform = env.indexOf("win") != -1 ? Integer.valueOf(WINDOWS) : (env.startsWith("mac os") ? Integer.valueOf(MACOS) : Integer.valueOf(LINUX));
            }
        }
    }

    public static void copyFile(String srcFilename, String dstFilename) {
        REF.copyFile(new File(srcFilename), new File(dstFilename));
    }

    public static void copyFile(File srcFilename, File dstFilename) {
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            try {
                srcChannel = new FileInputStream(srcFilename).getChannel();
                dstChannel = new FileOutputStream(dstFilename).getChannel();
                ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException e) {
                    Log.log(e);
                }
            }
            if (dstChannel != null) {
                try {
                    dstChannel.close();
                }
                catch (IOException e) {
                    Log.log(e);
                }
            }
        }
    }

    public static void copyDirectory(File srcPath, File dstPath, ICallback<Boolean, File> filter, ICallback<String, String> changeFileContents) throws IOException {
        if (srcPath.isDirectory()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                REF.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]), filter, changeFileContents);
                ++i;
            }
        } else if (srcPath.exists()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (changeFileContents == null) {
                REF.copyFile(srcPath.getAbsolutePath(), dstPath.getAbsolutePath());
            } else {
                String fileContents = REF.getFileContents(srcPath);
                fileContents = changeFileContents.call(fileContents);
                REF.writeStrToFile(fileContents, dstPath);
            }
        }
    }

    public static boolean createBackupFile(File file) {
        File parent;
        if (file != null && file.isFile() && (parent = file.getParentFile()).isDirectory()) {
            String[] list = parent.list();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(list));
            String initialName = file.getName();
            String name = initialName = String.valueOf(initialName) + ".bak";
            int i = 0;
            while (set.contains(name)) {
                name = String.valueOf(initialName) + i;
                ++i;
            }
            REF.copyFile(file.getAbsolutePath(), new File(parent, name).getAbsolutePath());
            return true;
        }
        return false;
    }

    public static double log(double a, double base) {
        return Math.log(a) / Math.log(base);
    }

    public static void print(Object ... objects) {
        System.out.println(StringUtils.join(" ", objects));
    }

    public static File getTempFileAt(File parentDir, String prefix) {
        return REF.getTempFileAt(parentDir, prefix, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFileAt(File parentDir, String prefix, String extension) {
        Object object = lockTempFiles;
        synchronized (object) {
            Assert.isTrue((boolean)parentDir.isDirectory());
            Set<String> current = alreadyReturned.get(parentDir);
            if (current == null) {
                current = new HashSet<String>();
                alreadyReturned.put(parentDir, current);
            }
            current.addAll(REF.getFilesStartingWith(parentDir, prefix));
            FastStringBuffer buf = new FastStringBuffer();
            long i = 0L;
            while (i < Long.MAX_VALUE) {
                File file;
                String v = buf.clear().append(prefix).append(i).append(extension).toString();
                if (!current.contains(v) && !(file = new File(parentDir, v)).exists()) {
                    current.add(file.getName());
                    return file;
                }
                ++i;
            }
            return null;
        }
    }

    public static HashSet<String> getFilesStartingWith(File parentDir, String prefix) {
        String[] list = parentDir.list();
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.startsWith(prefix)) {
                hashSet.add(string);
            }
            ++n2;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTempFilesAt(File parentDir, String prefix) {
        Object object = lockTempFiles;
        synchronized (object) {
            try {
                String[] list;
                Assert.isTrue((boolean)parentDir.isDirectory());
                String[] stringArray = list = parentDir.list();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string.startsWith(prefix)) {
                        String integer = string.substring(prefix.length());
                        try {
                            Integer.parseInt(integer);
                            try {
                                new File(parentDir, string).delete();
                            }
                            catch (Exception exception) {}
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++n2;
                }
                alreadyReturned.remove(parentDir);
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    public static void deleteDirectoryTree(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    REF.deleteDirectoryTree(f);
                } else {
                    REF.deleteFile(f);
                }
                ++i;
            }
        }
        if (!directory.delete()) {
            throw new IOException("Delete operation failed when deleting: " + directory);
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Delete operation failed when deleting: " + file);
        }
    }

    public static void openDirectory(File dir) {
        String executable = REF.getOpenDirectoryExecutable();
        if (executable != null) {
            try {
                if (executable.equals("kfmclient")) {
                    Runtime.getRuntime().exec(new String[]{executable, "exec", dir.toString()}, null, dir);
                } else {
                    Runtime.getRuntime().exec(new String[]{executable, dir.toString()}, null, dir);
                }
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    private static String getOpenDirectoryExecutable() {
        if (openDirExecutable == null) {
            Object env;
            if (REF.isWindowsPlatform()) {
                openDirExecutable = "explorer";
                return openDirExecutable;
            }
            if (REF.isMacOsPlatform()) {
                openDirExecutable = "open";
                return openDirExecutable;
            }
            try {
                env = System.getenv("DESKTOP_LAUNCH");
                if (env != null && ((String)env).trim().length() > 0) {
                    openDirExecutable = env;
                    return openDirExecutable;
                }
            }
            catch (Throwable throwable) {}
            try {
                env = System.getenv();
                if (env.containsKey("KDE_FULL_SESSION") || env.containsKey("KDE_MULTIHEAD")) {
                    openDirExecutable = "kfmclient";
                    return openDirExecutable;
                }
                if (env.containsKey("GNOME_DESKTOP_SESSION_ID") || env.containsKey("GNOME_KEYRING_SOCKET")) {
                    openDirExecutable = "gnome-open";
                    return openDirExecutable;
                }
            }
            catch (Throwable throwable) {}
            openDirExecutable = OPEN_DIR_EXEC_NOT_AVAILABLE;
        }
        if (openDirExecutable == OPEN_DIR_EXEC_NOT_AVAILABLE) {
            return null;
        }
        return openDirExecutable;
    }

    public static boolean getSupportsOpenDirectory() {
        return REF.getOpenDirectoryExecutable() != null;
    }

    public static File createFileFromParts(String ... parts) {
        String part0 = parts[0];
        File f = new File(part0);
        int i = 1;
        while (i < parts.length) {
            String part = parts[i];
            f = new File(f, part);
            ++i;
        }
        return f;
    }
}

