/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<X> {
    private final X[] EmptyArray;
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final boolean identity;
    private volatile X[] listeners;
    private Class<X> genericType;

    public ListenerList(Class<X> genericType) {
        this(genericType, 0);
    }

    public ListenerList(Class<X> genericType, int mode) {
        this.genericType = genericType;
        this.EmptyArray = (Object[])Array.newInstance(genericType, 0);
        this.listeners = this.EmptyArray;
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        this.identity = mode == 1;
    }

    public synchronized void add(X listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            X listener2 = this.listeners[i];
            if (this.identity ? listener == listener2 : listener.equals(listener2)) {
                return;
            }
            ++i;
        }
        Object[] newListeners = (Object[])Array.newInstance(this.genericType, oldSize + 1);
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public X[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(X listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            X listener2 = this.listeners[i];
            if (this.identity ? listener == listener2 : listener.equals(listener2)) {
                if (oldSize == 1) {
                    this.listeners = this.EmptyArray;
                } else {
                    Object[] newListeners = (Object[])Array.newInstance(this.genericType, oldSize - 1);
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = this.EmptyArray;
    }
}

