/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.REF;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaSaver<X> {
    private File dirToSaveDeltas;
    private String suffix;
    private List<DeltaCommand> commands;
    private int nCommands;
    private ICallback<X, String> readFromFileMethod;
    private ICallback<String, X> toFileMethod;

    public DeltaSaver(File dirToSaveDeltas, String extension, ICallback<X, String> readFromFileMethod, ICallback<String, X> toFileMethod) {
        this.dirToSaveDeltas = dirToSaveDeltas;
        this.suffix = "." + extension;
        this.commands = Collections.synchronizedList(new ArrayList());
        this.readFromFileMethod = readFromFileMethod;
        this.toFileMethod = toFileMethod;
        this.validateDir();
        this.loadDeltas();
    }

    private void validateDir() {
        if (!this.dirToSaveDeltas.exists()) {
            throw new RuntimeException("The path passed to save / restore deltas does not exist (" + this.dirToSaveDeltas + ")");
        }
        if (!this.dirToSaveDeltas.isDirectory()) {
            throw new RuntimeException("The path passed to save / restore deltas is not actually a directory (" + this.dirToSaveDeltas + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeltas() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<File> deltasFound = this.findDeltas();
            for (File file : deltasFound) {
                try {
                    DeltaCommand cmd = this.readFromFile(file, this.readFromFileMethod);
                    if (cmd == null || cmd.data == null) continue;
                    this.addRestoredCommand(cmd);
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
    }

    private ArrayList<File> findDeltas() {
        File[] files;
        ArrayList<File> deltasFound = new ArrayList<File>();
        File[] fileArray = files = this.dirToSaveDeltas.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isFile() && file.getName().endsWith(this.suffix)) {
                deltasFound.add(file);
            }
            ++n2;
        }
        Collections.sort(deltasFound, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String i = FullRepIterable.headAndTail(o1.getName())[0];
                String j = FullRepIterable.headAndTail(o2.getName())[0];
                return new Integer(i).compareTo(new Integer(j));
            }
        });
        return deltasFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRestoredCommand(DeltaCommand command) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            this.commands.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(DeltaCommand command) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            File file = new File(this.dirToSaveDeltas, String.valueOf(this.nCommands) + this.suffix);
            ++this.nCommands;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String write = this.toFileMethod.call(command.data);
            if (write == null) {
                Log.log("Null returned to write from data: " + command.data);
            } else {
                this.writeToFile(command, write, file);
                this.commands.add(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableDeltas() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            return this.commands.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<File> deltas = this.findDeltas();
            for (File file : deltas) {
                if (!file.exists()) continue;
                file.delete();
            }
            this.commands.clear();
            this.nCommands = 0;
        }
    }

    public void addInsertCommand(X o) {
        this.addCommand(new DeltaInsertCommand(o));
    }

    public void addDeleteCommand(X o) {
        this.addCommand(new DeltaDeleteCommand(o));
    }

    public void addUpdateCommand(X o) {
        this.addCommand(new DeltaUpdateCommand(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processDeltas(IDeltaProcessor<X> deltaProcessor) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<DeltaCommand> commandsToProcess = new ArrayList<DeltaCommand>(this.commands);
            boolean processed = false;
            for (DeltaCommand cmd : commandsToProcess) {
                try {
                    cmd.processWith(deltaProcessor);
                    processed = true;
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
            if (processed) {
                deltaProcessor.endProcessing();
            }
            this.clearAll();
        }
    }

    public void writeToFile(DeltaCommand command, String data, File file) {
        try {
            FastStringBuffer buf = new FastStringBuffer(command.getCommandFileDesc(), data.length());
            buf.append(data);
            REF.writeStrToFile(buf.toString(), file);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public DeltaCommand readFromFile(File astOutputFile, ICallback<X, String> readFromFileMethod) {
        boolean deletFile;
        block11: {
            try {
                deletFile = false;
                if (astOutputFile.exists()) break block11;
                return null;
            }
            catch (Exception e) {
                Log.log(e);
                return null;
            }
        }
        String fileContents = REF.getFileContents(astOutputFile);
        DeltaCommand o = null;
        try {
            if (fileContents.startsWith("UPD")) {
                o = new DeltaUpdateCommand(readFromFileMethod.call(fileContents.substring(3)));
            } else if (fileContents.startsWith("DEL")) {
                o = new DeltaDeleteCommand(readFromFileMethod.call(fileContents.substring(3)));
            } else if (fileContents.startsWith("INS")) {
                o = new DeltaInsertCommand(readFromFileMethod.call(fileContents.substring(3)));
            }
        }
        catch (Exception exception) {
            deletFile = true;
            o = null;
        }
        if (deletFile && astOutputFile.exists()) {
            astOutputFile.delete();
        }
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class DeltaCommand {
        public final X data;

        public DeltaCommand(X o) {
            this.data = o;
        }

        public abstract void processWith(IDeltaProcessor<X> var1);

        public abstract String getCommandFileDesc();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeltaDeleteCommand
    extends DeltaCommand {
        public DeltaDeleteCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processDelete(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "DEL";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeltaInsertCommand
    extends DeltaCommand {
        public DeltaInsertCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processInsert(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "INS";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeltaUpdateCommand
    extends DeltaCommand {
        public DeltaUpdateCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processUpdate(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "UPD";
        }
    }
}

