/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.scope;

import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterUtilsV2;

public class GetNodeForExtractLocalVisitor
extends VisitorBase {
    protected final FastStack<FastStack<SimpleNode>> contextStack = new FastStack(10);
    private int initialExtractLocalLine;
    private boolean keepGoing = true;
    private stmtType lastStmt;

    public GetNodeForExtractLocalVisitor(int initialExtractLocalLine) {
        this.initialExtractLocalLine = initialExtractLocalLine;
        this.contextStack.push((Object)new FastStack(10));
    }

    public void traverse(SimpleNode node) throws Exception {
        if (!this.keepGoing) {
            return;
        }
        boolean multiLineStmt = false;
        if (node instanceof stmtType) {
            multiLineStmt = PrettyPrinterUtilsV2.isMultiLineStmt((stmtType)node);
            if (multiLineStmt) {
                this.contextStack.push((Object)new FastStack(10));
            }
            this.lastStmt = (stmtType)node;
            node.traverse(this);
            if (multiLineStmt && this.keepGoing) {
                this.contextStack.pop();
            }
        } else {
            boolean inExpr;
            FastStack peek = (FastStack)this.contextStack.peek();
            boolean bl = inExpr = peek.size() != 0;
            if (!inExpr && node instanceof exprType) {
                peek.push((Object)node);
            }
            node.traverse(this);
            if (!inExpr && node instanceof exprType && this.keepGoing) {
                peek.pop();
            }
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        if (node instanceof stmtType) {
            return null;
        }
        if (node.beginLine >= this.initialExtractLocalLine) {
            this.keepGoing = false;
        }
        return null;
    }

    public SimpleNode getLastInContextBeforePassedLine() {
        FastStack peeked = (FastStack)this.contextStack.peek();
        if (peeked.size() > 0) {
            SimpleNode expr = (SimpleNode)peeked.peek();
            if (this.lastStmt != null) {
                if (expr.beginLine < this.lastStmt.beginLine) {
                    return expr;
                }
                return this.lastStmt;
            }
        }
        return this.lastStmt;
    }
}

