/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.MessageBox;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;
import org.python.pydev.ui.pythonpathconf.IInterpreterInfoBuilder;
import org.python.pydev.ui.pythonpathconf.IInterpreterNewCustomEntries;
import org.python.pydev.ui.pythonpathconf.PythonSelectionLibrariesDialog;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterInfo
implements IInterpreterInfo {
    private static String[] LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS = new String[]{"django"};
    public volatile String executableOrJar;
    public final List<String> libs = new ArrayList<String>();
    private final Set<String> forcedLibs = new TreeSet<String>();
    private String[] builtinsCache;
    private Map<String, File> predefinedBuiltinsCache;
    private final ISystemModulesManager modulesManager;
    public static ICallback<Boolean, Tuple<List<String>, List<String>>> configurePathsCallback = null;
    private final String version;
    private String[] envVariables;
    private Properties stringSubstitutionVariables;
    private final Set<String> predefinedCompletionsPath = new TreeSet<String>();
    private String name;
    IStringVariableManager stringVariableManagerForTests;
    private IInterpreterInfoBuilder builder;
    private final Object builderLock = new Object();
    private volatile boolean loadFinished = true;

    public String getExecutableOrJar() {
        return this.executableOrJar;
    }

    public ISystemModulesManager getModulesManager() {
        return this.modulesManager;
    }

    private IStringVariableManager getStringVariableManager() {
        if (this.stringVariableManagerForTests != null) {
            return this.stringVariableManagerForTests;
        }
        VariablesPlugin variablesPlugin = VariablesPlugin.getDefault();
        if (variablesPlugin != null) {
            return variablesPlugin.getStringVariableManager();
        }
        return null;
    }

    public List<String> getPythonPath() {
        return new ArrayList<String>(this.libs);
    }

    public InterpreterInfo(String version, String exe, Collection<String> libs0) {
        this.executableOrJar = exe;
        this.version = version;
        SystemModulesManager modulesManager = new SystemModulesManager(this);
        this.modulesManager = modulesManager;
        this.libs.addAll(libs0);
    }

    InterpreterInfo(String version, String exe, Collection<String> libs0, Collection<String> dlls) {
        this(version, exe, libs0);
    }

    InterpreterInfo(String version, String exe, List<String> libs0, List<String> dlls, List<String> forced) {
        this(version, exe, libs0, dlls, forced, null, null);
    }

    InterpreterInfo(String version, String exe, List<String> libs0, List<String> dlls, List<String> forced, List<String> envVars, Properties stringSubstitution) {
        this(version, exe, libs0, dlls);
        for (String s : forced) {
            if (this.isForcedLibToIgnore(s)) continue;
            this.forcedLibs.add(s);
        }
        if (envVars == null) {
            this.setEnvVariables(null);
        } else {
            this.setEnvVariables(envVars.toArray(new String[envVars.size()]));
        }
        this.setStringSubstitutionVariables(stringSubstitution);
        this.clearBuiltinsCache();
    }

    public boolean equals(Object o) {
        if (!(o instanceof InterpreterInfo)) {
            return false;
        }
        InterpreterInfo info = (InterpreterInfo)o;
        if (!info.executableOrJar.equals(this.executableOrJar)) {
            return false;
        }
        if (!info.libs.equals(this.libs)) {
            return false;
        }
        if (!info.forcedLibs.equals(this.forcedLibs)) {
            return false;
        }
        if (!info.predefinedCompletionsPath.equals(this.predefinedCompletionsPath)) {
            return false;
        }
        if (this.envVariables != null) {
            if (info.envVariables == null) {
                return false;
            }
            if (!Arrays.equals(this.envVariables, info.envVariables)) {
                return false;
            }
        } else if (info.envVariables != null) {
            return false;
        }
        return !(this.stringSubstitutionVariables != null ? (info.stringSubstitutionVariables == null ? this.stringSubstitutionVariables.size() != 0 : !this.stringSubstitutionVariables.equals(info.stringSubstitutionVariables)) : info.stringSubstitutionVariables != null && info.stringSubstitutionVariables.size() > 0);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InterpreterInfo fromString(String received, boolean askUserInOutPath) {
        if (received.toLowerCase().indexOf("executable") == -1) {
            throw new RuntimeException("Unable to recreate the Interpreter info (Its format changed. Please, re-create your Interpreter information).Contents found:" + received);
        }
        if (!(received = received.trim()).startsWith("<xml>")) {
            return InterpreterInfo.fromStringOld(received, askUserInOutPath);
        }
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(new ByteArrayInputStream(received.getBytes()));
            NodeList childNodes = document.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                String nodeName = item.getNodeName();
                if ("xml".equals(nodeName)) {
                    NodeList xmlNodes = item.getChildNodes();
                    String infoExecutable = null;
                    String infoName = null;
                    String infoVersion = null;
                    List<String> selection = new ArrayList<String>();
                    ArrayList<String> toAsk = new ArrayList<String>();
                    ArrayList<String> forcedLibs = new ArrayList<String>();
                    ArrayList<String> envVars = new ArrayList<String>();
                    ArrayList<String> predefinedPaths = new ArrayList<String>();
                    Properties stringSubstitutionVars = new Properties();
                    int j = 0;
                    while (j < xmlNodes.getLength()) {
                        Node xmlChild = xmlNodes.item(j);
                        String name = xmlChild.getNodeName();
                        if ("version".equals(name)) {
                            infoVersion = xmlChild.getTextContent().trim();
                        } else if ("name".equals(name)) {
                            infoName = xmlChild.getTextContent().trim();
                        } else if ("executable".equals(name)) {
                            infoExecutable = xmlChild.getTextContent().trim();
                        } else if ("lib".equals(name)) {
                            NamedNodeMap attributes = xmlChild.getAttributes();
                            Node namedItem = attributes.getNamedItem("path");
                            if (namedItem != null) {
                                String string = namedItem.getTextContent().trim();
                                if (string.equals("ins")) {
                                    if (askUserInOutPath) {
                                        toAsk.add(xmlChild.getTextContent().trim());
                                        selection.add(xmlChild.getTextContent().trim());
                                    } else {
                                        selection.add(xmlChild.getTextContent().trim());
                                    }
                                } else if (string.equals("out")) {
                                    if (askUserInOutPath) {
                                        toAsk.add(xmlChild.getTextContent().trim());
                                    } else {
                                        selection.add(xmlChild.getTextContent().trim());
                                    }
                                } else {
                                    Log.log((String)("Unexpected 'path' attribute in xml: " + string));
                                    selection.add(xmlChild.getTextContent().trim());
                                }
                            } else {
                                selection.add(xmlChild.getTextContent().trim());
                            }
                        } else if ("forced_lib".equals(name)) {
                            forcedLibs.add(xmlChild.getTextContent().trim());
                        } else if ("env_var".equals(name)) {
                            envVars.add(xmlChild.getTextContent().trim());
                        } else if ("string_substitution_var".equals(name)) {
                            NodeList stringSubstitutionVarNode = xmlChild.getChildNodes();
                            Node keyNode = InterpreterInfo.getNode(stringSubstitutionVarNode, "key");
                            Node node = InterpreterInfo.getNode(stringSubstitutionVarNode, "value");
                            stringSubstitutionVars.put(keyNode.getTextContent().trim(), node.getTextContent().trim());
                        } else if ("predefined_completion_path".equals(name)) {
                            predefinedPaths.add(xmlChild.getTextContent().trim());
                        } else if ("#text".equals(name)) {
                            if (xmlChild.getTextContent().trim().length() > 0) {
                                throw new RuntimeException("Unexpected text content: " + xmlChild.getTextContent());
                            }
                        } else {
                            throw new RuntimeException("Unexpected node: " + name + " Text content: " + xmlChild.getTextContent());
                        }
                        ++j;
                    }
                    if (askUserInOutPath) {
                        Object sp;
                        AdditionalEntries additionalEntries = new AdditionalEntries();
                        Collection<String> additionalLibraries = additionalEntries.getAdditionalLibraries();
                        InterpreterInfo.addUnique(toAsk, additionalLibraries);
                        InterpreterInfo.addUnique(selection, additionalLibraries);
                        InterpreterInfo.addUnique(forcedLibs, additionalEntries.getAdditionalBuiltins());
                        HashMap<String, String> existingEnv = new HashMap<String, String>();
                        Collection<String> additionalEnvVariables = additionalEntries.getAdditionalEnvVariables();
                        for (String var : additionalEnvVariables) {
                            sp = StringUtils.splitOnFirst((String)var, (char)'=');
                            existingEnv.put((String)((Tuple)sp).o1, (String)((Tuple)sp).o2);
                        }
                        for (String var : envVars) {
                            sp = StringUtils.splitOnFirst((String)var, (char)'=');
                            existingEnv.put((String)((Tuple)sp).o1, (String)((Tuple)sp).o2);
                        }
                        envVars.clear();
                        Set set = existingEnv.entrySet();
                        for (Map.Entry entry : set) {
                            envVars.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                        }
                        Map<String, String> map = additionalEntries.getAdditionalStringSubstitutionVariables();
                        Set<Map.Entry<String, String>> entrySet = map.entrySet();
                        for (Map.Entry<String, String> entry : entrySet) {
                            if (stringSubstitutionVars.containsKey(entry.getKey())) continue;
                            stringSubstitutionVars.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    try {
                        selection = InterpreterInfo.filterUserSelection(selection, toAsk);
                    }
                    catch (AbstractInterpreterEditor.CancelException cancelException) {
                        return null;
                    }
                    InterpreterInfo info = new InterpreterInfo(infoVersion, infoExecutable, selection, new ArrayList<String>(), forcedLibs, envVars, stringSubstitutionVars);
                    info.setName(infoName);
                    for (String s : predefinedPaths) {
                        info.addPredefinedCompletionsPath(s);
                    }
                    return info;
                }
                ++i;
            }
            throw new RuntimeException("Could not find 'xml' node as root of the document.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addUnique(Collection<String> col, Collection<String> additions) {
        for (String string : additions) {
            if (col.contains(string)) continue;
            col.add(string);
        }
    }

    private static Node getNode(NodeList nodeList, String string) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (string.equals(item.getNodeName())) {
                return item;
            }
            ++i;
        }
        throw new RuntimeException("Unable to find node: " + string);
    }

    private static InterpreterInfo fromStringOld(String received, boolean askUserInOutPath) {
        int endNameIndex;
        Tuple predefCompsPath = StringUtils.splitOnFirst((String)received, (String)"@PYDEV_PREDEF_COMPS_PATHS@");
        received = (String)predefCompsPath.o1;
        Tuple stringSubstitutionVarsSplit = StringUtils.splitOnFirst((String)received, (String)"@PYDEV_STRING_SUBST_VARS@");
        received = (String)stringSubstitutionVarsSplit.o1;
        received = received.replaceAll("\n", "").replaceAll("\r", "");
        String name = null;
        if (received.startsWith("Name:") && (endNameIndex = received.indexOf(":EndName:")) != -1) {
            name = received.substring("Name:".length(), endNameIndex);
            received = received.substring(endNameIndex + ":EndName:".length());
        }
        Tuple envVarsSplit = StringUtils.splitOnFirst((String)received, (char)'^');
        Tuple forcedSplit = StringUtils.splitOnFirst((String)((String)envVarsSplit.o1), (char)'$');
        Tuple libsSplit = StringUtils.splitOnFirst((String)((String)forcedSplit.o1), (char)'@');
        String exeAndLibs = (String)libsSplit.o1;
        String version = "2.4";
        String[] exeAndLibs1 = exeAndLibs.split("\\|");
        String exeAndVersion = exeAndLibs1[0];
        String lowerExeAndVersion = exeAndVersion.toLowerCase();
        if (lowerExeAndVersion.startsWith("version")) {
            int execut = lowerExeAndVersion.indexOf("executable");
            version = exeAndVersion.substring(0, execut).substring(7);
            exeAndVersion = exeAndVersion.substring(7 + version.length());
        }
        String executable = exeAndVersion.substring(exeAndVersion.indexOf(":") + 1, exeAndVersion.length());
        List<String> selection = new ArrayList<String>();
        ArrayList<String> toAsk = new ArrayList<String>();
        int i = 1;
        while (i < exeAndLibs1.length) {
            String trimmed = exeAndLibs1[i].trim();
            if (trimmed.length() > 0) {
                if (trimmed.endsWith("OUT_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                    } else {
                        selection.add(trimmed);
                    }
                } else if (trimmed.endsWith("INS_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                        selection.add(trimmed);
                    } else {
                        selection.add(trimmed);
                    }
                } else {
                    selection.add(trimmed);
                }
            }
            ++i;
        }
        try {
            selection = InterpreterInfo.filterUserSelection(selection, toAsk);
        }
        catch (AbstractInterpreterEditor.CancelException cancelException) {
            return null;
        }
        ArrayList<String> l1 = new ArrayList<String>();
        if (((String)libsSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)libsSplit, l1);
        }
        ArrayList<String> l2 = new ArrayList<String>();
        if (((String)forcedSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)forcedSplit, l2);
        }
        ArrayList<String> l3 = new ArrayList<String>();
        if (((String)envVarsSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)envVarsSplit, l3);
        }
        Properties p4 = null;
        if (((String)stringSubstitutionVarsSplit.o2).length() > 1) {
            p4 = PropertiesHelper.createPropertiesFromString((String)((String)stringSubstitutionVarsSplit.o2));
        }
        InterpreterInfo info = new InterpreterInfo(version, executable, selection, l1, l2, l3, p4);
        if (((String)predefCompsPath.o2).length() > 1) {
            List split = StringUtils.split((String)((String)predefCompsPath.o2), (char)'|');
            for (String s : split) {
                if ((s = s.trim()).length() <= 0) continue;
                info.addPredefinedCompletionsPath(s);
            }
        }
        info.setName(name);
        return info;
    }

    public static List<String> filterUserSelection(List<String> selection, List<String> toAsk) throws AbstractInterpreterEditor.CancelException {
        boolean result = true;
        if (ProjectModulesManager.IN_TESTS) {
            if (configurePathsCallback != null) {
                configurePathsCallback.call((Object)new Tuple(toAsk, selection));
            }
        } else if (toAsk.size() > 0) {
            PythonSelectionLibrariesDialog runnable = new PythonSelectionLibrariesDialog(selection, toAsk, true);
            try {
                RunInUiThread.sync((Runnable)runnable);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            result = runnable.getOkResult();
            if (!result) {
                throw new AbstractInterpreterEditor.CancelException();
            }
            selection = runnable.getSelection();
        }
        return selection;
    }

    private static void fillList(Tuple<String, String> forcedSplit, ArrayList<String> l2) {
        String forcedLibs = (String)forcedSplit.o2;
        for (String trimmed : StringUtils.splitAndRemoveEmptyTrimmed((String)forcedLibs, (char)'|')) {
            if ((trimmed = trimmed.trim()).length() <= 0) continue;
            l2.add(trimmed);
        }
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("<xml>\n");
        if (this.name != null) {
            buffer.append("<name>");
            buffer.append(this.name);
            buffer.append("</name>\n");
        }
        buffer.append("<version>");
        buffer.append(this.version);
        buffer.append("</version>\n");
        buffer.append("<executable>");
        buffer.append(this.executableOrJar);
        buffer.append("</executable>\n");
        Iterator<String> iter = this.libs.iterator();
        while (iter.hasNext()) {
            buffer.append("<lib>");
            buffer.append(iter.next().toString());
            buffer.append("</lib>\n");
        }
        if (this.forcedLibs.size() > 0) {
            iter = this.forcedLibs.iterator();
            while (iter.hasNext()) {
                buffer.append("<forced_lib>");
                buffer.append(iter.next().toString());
                buffer.append("</forced_lib>\n");
            }
        }
        if (this.envVariables != null) {
            String[] stringArray = this.envVariables;
            int n = this.envVariables.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                buffer.append("<env_var>");
                buffer.append(s);
                buffer.append("</env_var>\n");
                ++n2;
            }
        }
        if (this.stringSubstitutionVariables != null && this.stringSubstitutionVariables.size() > 0) {
            Set<Map.Entry<Object, Object>> entrySet = this.stringSubstitutionVariables.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                buffer.append("<string_substitution_var>");
                buffer.append("<key>");
                buffer.appendObject(entry.getKey());
                buffer.append("</key>");
                buffer.append("<value>");
                buffer.appendObject(entry.getValue());
                buffer.append("</value>");
                buffer.append("</string_substitution_var>\n");
            }
        }
        if (this.predefinedCompletionsPath.size() > 0) {
            for (String s : this.predefinedCompletionsPath) {
                buffer.append("<predefined_completion_path>");
                buffer.append(s);
                buffer.append("</predefined_completion_path>");
            }
        }
        buffer.append("</xml>");
        return buffer.toString();
    }

    public String toStringOld() {
        FastStringBuffer buffer = new FastStringBuffer();
        if (this.name != null) {
            buffer.append("Name:");
            buffer.append(this.name);
            buffer.append(":EndName:");
        }
        buffer.append("Version");
        buffer.append(this.version);
        buffer.append("Executable:");
        buffer.append(this.executableOrJar);
        Iterator<String> iter = this.libs.iterator();
        while (iter.hasNext()) {
            buffer.append("|");
            buffer.append(iter.next().toString());
        }
        buffer.append("@");
        buffer.append("$");
        if (this.forcedLibs.size() > 0) {
            iter = this.forcedLibs.iterator();
            while (iter.hasNext()) {
                buffer.append("|");
                buffer.append(iter.next().toString());
            }
        }
        if (this.envVariables != null) {
            buffer.append("^");
            String[] stringArray = this.envVariables;
            int n = this.envVariables.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                buffer.append(s);
                buffer.append("|");
                ++n2;
            }
        }
        if (this.stringSubstitutionVariables != null && this.stringSubstitutionVariables.size() > 0) {
            buffer.append("@PYDEV_STRING_SUBST_VARS@");
            buffer.append(PropertiesHelper.createStringFromProperties((Properties)this.stringSubstitutionVariables));
        }
        if (this.predefinedCompletionsPath.size() > 0) {
            buffer.append("@PYDEV_PREDEF_COMPS_PATHS@");
            for (String s : this.predefinedCompletionsPath) {
                buffer.append("|");
                buffer.append(s);
            }
        }
        return buffer.toString();
    }

    public void restoreCompiledLibs(IProgressMonitor monitor) {
        for (String lib : this.libs) {
            this.addForcedLibsFor(lib);
        }
        this.forcedLibs.add("os");
        this.forcedLibs.add("os.path");
        if (this.version.startsWith("2") || this.version.startsWith("1")) {
            this.forcedLibs.add("__builtin__");
        }
        this.forcedLibs.add("sys");
        this.forcedLibs.add("email");
        this.forcedLibs.add("hashlib");
        this.forcedLibs.add("pytest");
        int interpreterType = this.getInterpreterType();
        switch (interpreterType) {
            case 1: {
                this.forcedLibs.add("StringIO");
                this.forcedLibs.add("re");
                this.forcedLibs.add("com.ziclix.python.sql");
                break;
            }
            case 0: {
                this.forcedLibs.add("OpenGL");
                this.forcedLibs.add("wxPython");
                this.forcedLibs.add("wx");
                this.forcedLibs.add("numpy");
                this.forcedLibs.add("scipy");
                this.forcedLibs.add("Image");
                this.forcedLibs.add("_ast");
                this.forcedLibs.add("_bisect");
                this.forcedLibs.add("_bytesio");
                this.forcedLibs.add("_codecs");
                this.forcedLibs.add("_codecs_cn");
                this.forcedLibs.add("_codecs_hk");
                this.forcedLibs.add("_codecs_iso2022");
                this.forcedLibs.add("_codecs_jp");
                this.forcedLibs.add("_codecs_kr");
                this.forcedLibs.add("_codecs_tw");
                this.forcedLibs.add("_collections");
                this.forcedLibs.add("_csv");
                this.forcedLibs.add("_fileio");
                this.forcedLibs.add("_functools");
                this.forcedLibs.add("_heapq");
                this.forcedLibs.add("_hotshot");
                this.forcedLibs.add("_json");
                this.forcedLibs.add("_locale");
                this.forcedLibs.add("_lsprof");
                this.forcedLibs.add("_md5");
                this.forcedLibs.add("_multibytecodec");
                this.forcedLibs.add("_random");
                this.forcedLibs.add("_sha");
                this.forcedLibs.add("_sha256");
                this.forcedLibs.add("_sha512");
                this.forcedLibs.add("_sre");
                this.forcedLibs.add("_struct");
                this.forcedLibs.add("_subprocess");
                this.forcedLibs.add("_symtable");
                this.forcedLibs.add("_warnings");
                this.forcedLibs.add("_weakref");
                this.forcedLibs.add("_winreg");
                this.forcedLibs.add("array");
                this.forcedLibs.add("audioop");
                this.forcedLibs.add("binascii");
                this.forcedLibs.add("cPickle");
                this.forcedLibs.add("cStringIO");
                this.forcedLibs.add("cmath");
                this.forcedLibs.add("datetime");
                this.forcedLibs.add("errno");
                this.forcedLibs.add("exceptions");
                this.forcedLibs.add("future_builtins");
                this.forcedLibs.add("gc");
                this.forcedLibs.add("imageop");
                this.forcedLibs.add("imp");
                this.forcedLibs.add("itertools");
                this.forcedLibs.add("marshal");
                this.forcedLibs.add("math");
                this.forcedLibs.add("mmap");
                this.forcedLibs.add("msvcrt");
                this.forcedLibs.add("nt");
                this.forcedLibs.add("operator");
                this.forcedLibs.add("parser");
                this.forcedLibs.add("signal");
                this.forcedLibs.add("socket");
                this.forcedLibs.add("strop");
                this.forcedLibs.add("sys");
                this.forcedLibs.add("thread");
                this.forcedLibs.add("time");
                this.forcedLibs.add("xxsubtype");
                this.forcedLibs.add("zipimport");
                this.forcedLibs.add("zlib");
                break;
            }
            case 2: {
                this.forcedLibs.add("System");
                this.forcedLibs.add("Microsoft");
                this.forcedLibs.add("clr");
                this.forcedLibs.add("IEHost.Execute");
                this.forcedLibs.add("Microsoft.Aspnet.Snapin");
                this.forcedLibs.add("Microsoft.Build.BuildEngine");
                this.forcedLibs.add("Microsoft.Build.Conversion");
                this.forcedLibs.add("Microsoft.Build.Framework");
                this.forcedLibs.add("Microsoft.Build.Tasks");
                this.forcedLibs.add("Microsoft.Build.Tasks.Deployment.Bootstrapper");
                this.forcedLibs.add("Microsoft.Build.Tasks.Deployment.ManifestUtilities");
                this.forcedLibs.add("Microsoft.Build.Tasks.Hosting");
                this.forcedLibs.add("Microsoft.Build.Tasks.Windows");
                this.forcedLibs.add("Microsoft.Build.Utilities");
                this.forcedLibs.add("Microsoft.CLRAdmin");
                this.forcedLibs.add("Microsoft.CSharp");
                this.forcedLibs.add("Microsoft.Data.Entity.Build.Tasks");
                this.forcedLibs.add("Microsoft.IE");
                this.forcedLibs.add("Microsoft.Ink");
                this.forcedLibs.add("Microsoft.Ink.TextInput");
                this.forcedLibs.add("Microsoft.JScript");
                this.forcedLibs.add("Microsoft.JScript.Vsa");
                this.forcedLibs.add("Microsoft.ManagementConsole");
                this.forcedLibs.add("Microsoft.ManagementConsole.Advanced");
                this.forcedLibs.add("Microsoft.ManagementConsole.Internal");
                this.forcedLibs.add("Microsoft.ServiceModel.Channels.Mail");
                this.forcedLibs.add("Microsoft.ServiceModel.Channels.Mail.ExchangeWebService");
                this.forcedLibs.add("Microsoft.ServiceModel.Channels.Mail.ExchangeWebService.Exchange2007");
                this.forcedLibs.add("Microsoft.ServiceModel.Channels.Mail.WindowsMobile");
                this.forcedLibs.add("Microsoft.SqlServer.Server");
                this.forcedLibs.add("Microsoft.StylusInput");
                this.forcedLibs.add("Microsoft.StylusInput.PluginData");
                this.forcedLibs.add("Microsoft.VisualBasic");
                this.forcedLibs.add("Microsoft.VisualBasic.ApplicationServices");
                this.forcedLibs.add("Microsoft.VisualBasic.Compatibility.VB6");
                this.forcedLibs.add("Microsoft.VisualBasic.CompilerServices");
                this.forcedLibs.add("Microsoft.VisualBasic.Devices");
                this.forcedLibs.add("Microsoft.VisualBasic.FileIO");
                this.forcedLibs.add("Microsoft.VisualBasic.Logging");
                this.forcedLibs.add("Microsoft.VisualBasic.MyServices");
                this.forcedLibs.add("Microsoft.VisualBasic.MyServices.Internal");
                this.forcedLibs.add("Microsoft.VisualBasic.Vsa");
                this.forcedLibs.add("Microsoft.VisualC");
                this.forcedLibs.add("Microsoft.VisualC.StlClr");
                this.forcedLibs.add("Microsoft.VisualC.StlClr.Generic");
                this.forcedLibs.add("Microsoft.Vsa");
                this.forcedLibs.add("Microsoft.Vsa.Vb.CodeDOM");
                this.forcedLibs.add("Microsoft.Win32");
                this.forcedLibs.add("Microsoft.Win32.SafeHandles");
                this.forcedLibs.add("Microsoft.Windows.Themes");
                this.forcedLibs.add("Microsoft.WindowsCE.Forms");
                this.forcedLibs.add("Microsoft.WindowsMobile.DirectX");
                this.forcedLibs.add("Microsoft.WindowsMobile.DirectX.Direct3D");
                this.forcedLibs.add("Microsoft_VsaVb");
                this.forcedLibs.add("RegCode");
                this.forcedLibs.add("System");
                this.forcedLibs.add("System.AddIn");
                this.forcedLibs.add("System.AddIn.Contract");
                this.forcedLibs.add("System.AddIn.Contract.Automation");
                this.forcedLibs.add("System.AddIn.Contract.Collections");
                this.forcedLibs.add("System.AddIn.Hosting");
                this.forcedLibs.add("System.AddIn.Pipeline");
                this.forcedLibs.add("System.CodeDom");
                this.forcedLibs.add("System.CodeDom.Compiler");
                this.forcedLibs.add("System.Collections");
                this.forcedLibs.add("System.Collections.Generic");
                this.forcedLibs.add("System.Collections.ObjectModel");
                this.forcedLibs.add("System.Collections.Specialized");
                this.forcedLibs.add("System.ComponentModel");
                this.forcedLibs.add("System.ComponentModel.DataAnnotations");
                this.forcedLibs.add("System.ComponentModel.Design");
                this.forcedLibs.add("System.ComponentModel.Design.Data");
                this.forcedLibs.add("System.ComponentModel.Design.Serialization");
                this.forcedLibs.add("System.Configuration");
                this.forcedLibs.add("System.Configuration.Assemblies");
                this.forcedLibs.add("System.Configuration.Install");
                this.forcedLibs.add("System.Configuration.Internal");
                this.forcedLibs.add("System.Configuration.Provider");
                this.forcedLibs.add("System.Data");
                this.forcedLibs.add("System.Data.Common");
                this.forcedLibs.add("System.Data.Common.CommandTrees");
                this.forcedLibs.add("System.Data.Design");
                this.forcedLibs.add("System.Data.Entity.Design");
                this.forcedLibs.add("System.Data.Entity.Design.AspNet");
                this.forcedLibs.add("System.Data.EntityClient");
                this.forcedLibs.add("System.Data.Linq");
                this.forcedLibs.add("System.Data.Linq.Mapping");
                this.forcedLibs.add("System.Data.Linq.SqlClient");
                this.forcedLibs.add("System.Data.Linq.SqlClient.Implementation");
                this.forcedLibs.add("System.Data.Mapping");
                this.forcedLibs.add("System.Data.Metadata.Edm");
                this.forcedLibs.add("System.Data.Objects");
                this.forcedLibs.add("System.Data.Objects.DataClasses");
                this.forcedLibs.add("System.Data.Odbc");
                this.forcedLibs.add("System.Data.OleDb");
                this.forcedLibs.add("System.Data.OracleClient");
                this.forcedLibs.add("System.Data.Services");
                this.forcedLibs.add("System.Data.Services.Client");
                this.forcedLibs.add("System.Data.Services.Common");
                this.forcedLibs.add("System.Data.Services.Design");
                this.forcedLibs.add("System.Data.Services.Internal");
                this.forcedLibs.add("System.Data.Sql");
                this.forcedLibs.add("System.Data.SqlClient");
                this.forcedLibs.add("System.Data.SqlTypes");
                this.forcedLibs.add("System.Deployment.Application");
                this.forcedLibs.add("System.Deployment.Internal");
                this.forcedLibs.add("System.Diagnostics");
                this.forcedLibs.add("System.Diagnostics.CodeAnalysis");
                this.forcedLibs.add("System.Diagnostics.Design");
                this.forcedLibs.add("System.Diagnostics.Eventing");
                this.forcedLibs.add("System.Diagnostics.Eventing.Reader");
                this.forcedLibs.add("System.Diagnostics.PerformanceData");
                this.forcedLibs.add("System.Diagnostics.SymbolStore");
                this.forcedLibs.add("System.DirectoryServices");
                this.forcedLibs.add("System.DirectoryServices.AccountManagement");
                this.forcedLibs.add("System.DirectoryServices.ActiveDirectory");
                this.forcedLibs.add("System.DirectoryServices.Protocols");
                this.forcedLibs.add("System.Drawing");
                this.forcedLibs.add("System.Drawing.Design");
                this.forcedLibs.add("System.Drawing.Drawing2D");
                this.forcedLibs.add("System.Drawing.Imaging");
                this.forcedLibs.add("System.Drawing.Printing");
                this.forcedLibs.add("System.Drawing.Text");
                this.forcedLibs.add("System.EnterpriseServices");
                this.forcedLibs.add("System.EnterpriseServices.CompensatingResourceManager");
                this.forcedLibs.add("System.EnterpriseServices.Internal");
                this.forcedLibs.add("System.Globalization");
                this.forcedLibs.add("System.IdentityModel.Claims");
                this.forcedLibs.add("System.IdentityModel.Policy");
                this.forcedLibs.add("System.IdentityModel.Selectors");
                this.forcedLibs.add("System.IdentityModel.Tokens");
                this.forcedLibs.add("System.IO");
                this.forcedLibs.add("System.IO.Compression");
                this.forcedLibs.add("System.IO.IsolatedStorage");
                this.forcedLibs.add("System.IO.Log");
                this.forcedLibs.add("System.IO.Packaging");
                this.forcedLibs.add("System.IO.Pipes");
                this.forcedLibs.add("System.IO.Ports");
                this.forcedLibs.add("System.Linq");
                this.forcedLibs.add("System.Linq.Expressions");
                this.forcedLibs.add("System.Management");
                this.forcedLibs.add("System.Management.Instrumentation");
                this.forcedLibs.add("System.Media");
                this.forcedLibs.add("System.Messaging");
                this.forcedLibs.add("System.Messaging.Design");
                this.forcedLibs.add("System.Net");
                this.forcedLibs.add("System.Net.Cache");
                this.forcedLibs.add("System.Net.Configuration");
                this.forcedLibs.add("System.Net.Mail");
                this.forcedLibs.add("System.Net.Mime");
                this.forcedLibs.add("System.Net.NetworkInformation");
                this.forcedLibs.add("System.Net.PeerToPeer");
                this.forcedLibs.add("System.Net.PeerToPeer.Collaboration");
                this.forcedLibs.add("System.Net.Security");
                this.forcedLibs.add("System.Net.Sockets");
                this.forcedLibs.add("System.Printing");
                this.forcedLibs.add("System.Printing.IndexedProperties");
                this.forcedLibs.add("System.Printing.Interop");
                this.forcedLibs.add("System.Reflection");
                this.forcedLibs.add("System.Reflection.Emit");
                this.forcedLibs.add("System.Resources");
                this.forcedLibs.add("System.Resources.Tools");
                this.forcedLibs.add("System.Runtime");
                this.forcedLibs.add("System.Runtime.CompilerServices");
                this.forcedLibs.add("System.Runtime.ConstrainedExecution");
                this.forcedLibs.add("System.Runtime.Hosting");
                this.forcedLibs.add("System.Runtime.InteropServices");
                this.forcedLibs.add("System.Runtime.InteropServices.ComTypes");
                this.forcedLibs.add("System.Runtime.InteropServices.CustomMarshalers");
                this.forcedLibs.add("System.Runtime.InteropServices.Expando");
                this.forcedLibs.add("System.Runtime.Remoting");
                this.forcedLibs.add("System.Runtime.Remoting.Activation");
                this.forcedLibs.add("System.Runtime.Remoting.Channels");
                this.forcedLibs.add("System.Runtime.Remoting.Channels.Http");
                this.forcedLibs.add("System.Runtime.Remoting.Channels.Ipc");
                this.forcedLibs.add("System.Runtime.Remoting.Channels.Tcp");
                this.forcedLibs.add("System.Runtime.Remoting.Contexts");
                this.forcedLibs.add("System.Runtime.Remoting.Lifetime");
                this.forcedLibs.add("System.Runtime.Remoting.Messaging");
                this.forcedLibs.add("System.Runtime.Remoting.Metadata");
                this.forcedLibs.add("System.Runtime.Remoting.MetadataServices");
                this.forcedLibs.add("System.Runtime.Remoting.Proxies");
                this.forcedLibs.add("System.Runtime.Remoting.Services");
                this.forcedLibs.add("System.Runtime.Serialization");
                this.forcedLibs.add("System.Runtime.Serialization.Configuration");
                this.forcedLibs.add("System.Runtime.Serialization.Formatters");
                this.forcedLibs.add("System.Runtime.Serialization.Formatters.Binary");
                this.forcedLibs.add("System.Runtime.Serialization.Formatters.Soap");
                this.forcedLibs.add("System.Runtime.Serialization.Json");
                this.forcedLibs.add("System.Runtime.Versioning");
                this.forcedLibs.add("System.Security");
                this.forcedLibs.add("System.Security.AccessControl");
                this.forcedLibs.add("System.Security.Authentication");
                this.forcedLibs.add("System.Security.Authentication.ExtendedProtection");
                this.forcedLibs.add("System.Security.Authentication.ExtendedProtection.Configuration");
                this.forcedLibs.add("System.Security.Cryptography");
                this.forcedLibs.add("System.Security.Cryptography.Pkcs");
                this.forcedLibs.add("System.Security.Cryptography.X509Certificates");
                this.forcedLibs.add("System.Security.Cryptography.Xml");
                this.forcedLibs.add("System.Security.Permissions");
                this.forcedLibs.add("System.Security.Policy");
                this.forcedLibs.add("System.Security.Principal");
                this.forcedLibs.add("System.Security.RightsManagement");
                this.forcedLibs.add("System.ServiceModel");
                this.forcedLibs.add("System.ServiceModel.Activation");
                this.forcedLibs.add("System.ServiceModel.Activation.Configuration");
                this.forcedLibs.add("System.ServiceModel.Channels");
                this.forcedLibs.add("System.ServiceModel.ComIntegration");
                this.forcedLibs.add("System.ServiceModel.Configuration");
                this.forcedLibs.add("System.ServiceModel.Description");
                this.forcedLibs.add("System.ServiceModel.Diagnostics");
                this.forcedLibs.add("System.ServiceModel.Dispatcher");
                this.forcedLibs.add("System.ServiceModel.Install.Configuration");
                this.forcedLibs.add("System.ServiceModel.Internal");
                this.forcedLibs.add("System.ServiceModel.MsmqIntegration");
                this.forcedLibs.add("System.ServiceModel.PeerResolvers");
                this.forcedLibs.add("System.ServiceModel.Persistence");
                this.forcedLibs.add("System.ServiceModel.Security");
                this.forcedLibs.add("System.ServiceModel.Security.Tokens");
                this.forcedLibs.add("System.ServiceModel.Syndication");
                this.forcedLibs.add("System.ServiceModel.Web");
                this.forcedLibs.add("System.ServiceProcess");
                this.forcedLibs.add("System.ServiceProcess.Design");
                this.forcedLibs.add("System.Speech.AudioFormat");
                this.forcedLibs.add("System.Speech.Recognition");
                this.forcedLibs.add("System.Speech.Recognition.SrgsGrammar");
                this.forcedLibs.add("System.Speech.Synthesis");
                this.forcedLibs.add("System.Speech.Synthesis.TtsEngine");
                this.forcedLibs.add("System.Text");
                this.forcedLibs.add("System.Text.RegularExpressions");
                this.forcedLibs.add("System.Threading");
                this.forcedLibs.add("System.Timers");
                this.forcedLibs.add("System.Transactions");
                this.forcedLibs.add("System.Transactions.Configuration");
                this.forcedLibs.add("System.Web");
                this.forcedLibs.add("System.Web.ApplicationServices");
                this.forcedLibs.add("System.Web.Caching");
                this.forcedLibs.add("System.Web.ClientServices");
                this.forcedLibs.add("System.Web.ClientServices.Providers");
                this.forcedLibs.add("System.Web.Compilation");
                this.forcedLibs.add("System.Web.Configuration");
                this.forcedLibs.add("System.Web.Configuration.Internal");
                this.forcedLibs.add("System.Web.DynamicData");
                this.forcedLibs.add("System.Web.DynamicData.Design");
                this.forcedLibs.add("System.Web.DynamicData.ModelProviders");
                this.forcedLibs.add("System.Web.Handlers");
                this.forcedLibs.add("System.Web.Hosting");
                this.forcedLibs.add("System.Web.Mail");
                this.forcedLibs.add("System.Web.Management");
                this.forcedLibs.add("System.Web.Mobile");
                this.forcedLibs.add("System.Web.Profile");
                this.forcedLibs.add("System.Web.Query.Dynamic");
                this.forcedLibs.add("System.Web.RegularExpressions");
                this.forcedLibs.add("System.Web.Routing");
                this.forcedLibs.add("System.Web.Script.Serialization");
                this.forcedLibs.add("System.Web.Script.Services");
                this.forcedLibs.add("System.Web.Security");
                this.forcedLibs.add("System.Web.Services");
                this.forcedLibs.add("System.Web.Services.Configuration");
                this.forcedLibs.add("System.Web.Services.Description");
                this.forcedLibs.add("System.Web.Services.Discovery");
                this.forcedLibs.add("System.Web.Services.Protocols");
                this.forcedLibs.add("System.Web.SessionState");
                this.forcedLibs.add("System.Web.UI");
                this.forcedLibs.add("System.Web.UI.Adapters");
                this.forcedLibs.add("System.Web.UI.Design");
                this.forcedLibs.add("System.Web.UI.Design.MobileControls");
                this.forcedLibs.add("System.Web.UI.Design.MobileControls.Converters");
                this.forcedLibs.add("System.Web.UI.Design.WebControls");
                this.forcedLibs.add("System.Web.UI.Design.WebControls.WebParts");
                this.forcedLibs.add("System.Web.UI.MobileControls");
                this.forcedLibs.add("System.Web.UI.MobileControls.Adapters");
                this.forcedLibs.add("System.Web.UI.MobileControls.Adapters.XhtmlAdapters");
                this.forcedLibs.add("System.Web.UI.WebControls");
                this.forcedLibs.add("System.Web.UI.WebControls.Adapters");
                this.forcedLibs.add("System.Web.UI.WebControls.WebParts");
                this.forcedLibs.add("System.Web.Util");
                this.forcedLibs.add("System.Windows");
                this.forcedLibs.add("System.Windows.Annotations");
                this.forcedLibs.add("System.Windows.Annotations.Storage");
                this.forcedLibs.add("System.Windows.Automation");
                this.forcedLibs.add("System.Windows.Automation.Peers");
                this.forcedLibs.add("System.Windows.Automation.Provider");
                this.forcedLibs.add("System.Windows.Automation.Text");
                this.forcedLibs.add("System.Windows.Controls");
                this.forcedLibs.add("System.Windows.Controls.Primitives");
                this.forcedLibs.add("System.Windows.Converters");
                this.forcedLibs.add("System.Windows.Data");
                this.forcedLibs.add("System.Windows.Documents");
                this.forcedLibs.add("System.Windows.Documents.Serialization");
                this.forcedLibs.add("System.Windows.Forms");
                this.forcedLibs.add("System.Windows.Forms.ComponentModel.Com2Interop");
                this.forcedLibs.add("System.Windows.Forms.Design");
                this.forcedLibs.add("System.Windows.Forms.Design.Behavior");
                this.forcedLibs.add("System.Windows.Forms.Integration");
                this.forcedLibs.add("System.Windows.Forms.Layout");
                this.forcedLibs.add("System.Windows.Forms.PropertyGridInternal");
                this.forcedLibs.add("System.Windows.Forms.VisualStyles");
                this.forcedLibs.add("System.Windows.Ink");
                this.forcedLibs.add("System.Windows.Ink.AnalysisCore");
                this.forcedLibs.add("System.Windows.Input");
                this.forcedLibs.add("System.Windows.Input.StylusPlugIns");
                this.forcedLibs.add("System.Windows.Interop");
                this.forcedLibs.add("System.Windows.Markup");
                this.forcedLibs.add("System.Windows.Markup.Localizer");
                this.forcedLibs.add("System.Windows.Markup.Primitives");
                this.forcedLibs.add("System.Windows.Media");
                this.forcedLibs.add("System.Windows.Media.Animation");
                this.forcedLibs.add("System.Windows.Media.Converters");
                this.forcedLibs.add("System.Windows.Media.Effects");
                this.forcedLibs.add("System.Windows.Media.Imaging");
                this.forcedLibs.add("System.Windows.Media.Media3D");
                this.forcedLibs.add("System.Windows.Media.Media3D.Converters");
                this.forcedLibs.add("System.Windows.Media.TextFormatting");
                this.forcedLibs.add("System.Windows.Navigation");
                this.forcedLibs.add("System.Windows.Resources");
                this.forcedLibs.add("System.Windows.Shapes");
                this.forcedLibs.add("System.Windows.Threading");
                this.forcedLibs.add("System.Windows.Xps");
                this.forcedLibs.add("System.Windows.Xps.Packaging");
                this.forcedLibs.add("System.Windows.Xps.Serialization");
                this.forcedLibs.add("System.Workflow.Activities");
                this.forcedLibs.add("System.Workflow.Activities.Configuration");
                this.forcedLibs.add("System.Workflow.Activities.Rules");
                this.forcedLibs.add("System.Workflow.Activities.Rules.Design");
                this.forcedLibs.add("System.Workflow.ComponentModel");
                this.forcedLibs.add("System.Workflow.ComponentModel.Compiler");
                this.forcedLibs.add("System.Workflow.ComponentModel.Design");
                this.forcedLibs.add("System.Workflow.ComponentModel.Serialization");
                this.forcedLibs.add("System.Workflow.Runtime");
                this.forcedLibs.add("System.Workflow.Runtime.Configuration");
                this.forcedLibs.add("System.Workflow.Runtime.DebugEngine");
                this.forcedLibs.add("System.Workflow.Runtime.Hosting");
                this.forcedLibs.add("System.Workflow.Runtime.Tracking");
                this.forcedLibs.add("System.Xml");
                this.forcedLibs.add("System.Xml.Linq");
                this.forcedLibs.add("System.Xml.Schema");
                this.forcedLibs.add("System.Xml.Serialization");
                this.forcedLibs.add("System.Xml.Serialization.Advanced");
                this.forcedLibs.add("System.Xml.Serialization.Configuration");
                this.forcedLibs.add("System.Xml.XPath");
                this.forcedLibs.add("System.Xml.Xsl");
                this.forcedLibs.add("System.Xml.Xsl.Runtime");
                this.forcedLibs.add("UIAutomationClientsideProviders");
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to treat: " + interpreterType);
            }
        }
        this.clearBuiltinsCache();
    }

    private void addForcedLibsFor(String lib) {
        File file = new File(lib);
        if (file.exists()) {
            if (file.isDirectory()) {
                File werkzeug = new File(file, "werkzeug");
                if (werkzeug.isDirectory()) {
                    this.forcedLibs.add("werkzeug");
                }
            } else {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    if (zipFile.getEntry("werkzeug/__init__.py") != null) {
                        this.forcedLibs.add("werkzeug");
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void clearBuiltinsCache() {
        this.builtinsCache = null;
        this.predefinedBuiltinsCache = null;
    }

    private void restorePythonpath(String path, IProgressMonitor monitor) {
        this.getModulesManager().changePythonPath(path, null, monitor);
    }

    public void restorePythonpath(IProgressMonitor monitor) {
        FastStringBuffer buffer = new FastStringBuffer();
        for (String folder : this.libs) {
            buffer.append(folder);
            buffer.append("|");
        }
        this.restorePythonpath(buffer.toString(), monitor);
    }

    public int getInterpreterType() {
        if (InterpreterInfo.isJythonExecutable(this.executableOrJar)) {
            return 1;
        }
        if (InterpreterInfo.isIronpythonExecutable(this.executableOrJar)) {
            return 2;
        }
        return 0;
    }

    public static boolean isJythonExecutable(String executable) {
        if (executable.endsWith("\"")) {
            return executable.endsWith(".jar\"");
        }
        return executable.endsWith(".jar");
    }

    public static boolean isIronpythonExecutable(String executable) {
        File file = new File(executable);
        return file.getName().startsWith("ipy");
    }

    public static String getExeAsFileSystemValidPath(String executableOrJar) {
        return StringUtils.getExeAsFileSystemValidPath((String)executableOrJar);
    }

    public String getExeAsFileSystemValidPath() {
        return InterpreterInfo.getExeAsFileSystemValidPath(this.executableOrJar);
    }

    public String getVersion() {
        return this.version;
    }

    public int getGrammarVersion() {
        return PythonNature.getGrammarVersionFromStr(this.version);
    }

    public String[] getBuiltins() {
        if (this.builtinsCache == null) {
            HashSet<String> set = new HashSet<String>(this.forcedLibs);
            this.builtinsCache = set.toArray(new String[0]);
        }
        return this.builtinsCache;
    }

    public void addForcedLib(String forcedLib) {
        if (this.isForcedLibToIgnore(forcedLib)) {
            return;
        }
        this.forcedLibs.add(forcedLib);
        this.clearBuiltinsCache();
    }

    private boolean isForcedLibToIgnore(String forcedLib) {
        if (forcedLib == null) {
            return true;
        }
        String[] stringArray = LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS;
        int n = LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (forcedLib.equals(s) || forcedLib.startsWith(String.valueOf(s) + ".")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeForcedLib(String forcedLib) {
        this.forcedLibs.remove(forcedLib);
        this.clearBuiltinsCache();
    }

    public Iterator<String> forcedLibsIterator() {
        return this.forcedLibs.iterator();
    }

    public void setEnvVariables(String[] env) {
        if (env != null) {
            ArrayList<String> lst = new ArrayList<String>();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Tuple sp = StringUtils.splitOnFirst((String)s, (char)'=');
                if (((String)sp.o1).length() != 0 && ((String)sp.o2).length() != 0 && !InterpreterInfo.checkIfPythonPathEnvVarAndWarnIfIs((String)sp.o1)) {
                    lst.add(s);
                }
                ++n2;
            }
            Collections.sort(lst);
            env = lst.toArray(new String[lst.size()]);
        }
        if (env != null && env.length == 0) {
            env = null;
        }
        this.envVariables = env;
    }

    public String[] getEnvVariables() {
        return this.envVariables;
    }

    public String[] updateEnv(String[] env) {
        return this.updateEnv(env, null);
    }

    public String[] updateEnv(String[] env, Set<String> keysThatShouldNotBeUpdated) {
        if (this.envVariables == null || this.envVariables.length == 0) {
            return env;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InterpreterInfo.fillMapWithEnv(env, hashMap, null, null);
        InterpreterInfo.fillMapWithEnv(this.envVariables, hashMap, keysThatShouldNotBeUpdated, this.getStringVariableManager());
        String[] ret = InterpreterInfo.createEnvWithMap(hashMap);
        return ret;
    }

    public static String[] createEnvWithMap(Map<String, String> hashMap) {
        Set<Map.Entry<String, String>> entrySet = hashMap.entrySet();
        String[] ret = new String[entrySet.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            ret[i] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
            ++i;
        }
        return ret;
    }

    public static void fillMapWithEnv(String[] env, HashMap<String, String> hashMap, Set<String> keysThatShouldNotBeUpdated, IStringVariableManager manager) {
        if (env == null || env.length == 0) {
            return;
        }
        if (keysThatShouldNotBeUpdated == null) {
            keysThatShouldNotBeUpdated = Collections.emptySet();
        }
        String[] stringArray = env;
        int n = env.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Tuple sp = StringUtils.splitOnFirst((String)s, (char)'=');
            if (((String)sp.o1).length() != 0 && ((String)sp.o2).length() != 0 && !keysThatShouldNotBeUpdated.contains(sp.o1)) {
                String value = (String)sp.o2;
                if (manager != null) {
                    try {
                        value = manager.performStringSubstitution(value, false);
                    }
                    catch (CoreException coreException) {}
                }
                hashMap.put((String)sp.o1, value);
            }
            ++n2;
        }
    }

    public static void removePythonPathFromEnvMapWithWarning(HashMap<String, String> map) {
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            String key = next.getKey();
            if (!InterpreterInfo.checkIfPythonPathEnvVarAndWarnIfIs(key)) continue;
            it.remove();
        }
    }

    public static boolean checkIfPythonPathEnvVarAndWarnIfIs(String key) {
        String keyPlatformDependent;
        boolean isPythonPath = false;
        boolean win32 = REF.isWindowsPlatform();
        if (win32) {
            key = key.toUpperCase();
        }
        if ((keyPlatformDependent = key).equals("PYTHONPATH") || keyPlatformDependent.equals("CLASSPATH") || keyPlatformDependent.equals("JYTHONPATH") || keyPlatformDependent.equals("IRONPYTHONPATH")) {
            final String msg = "Ignoring " + keyPlatformDependent + " specified in the interpreter info.\n" + "It's managed depending on the project and other configurations and cannot be directly specified in the interpreter.";
            try {
                RunInUiThread.async((Runnable)new Runnable(){

                    public void run() {
                        MessageBox message = new MessageBox(PyAction.getShell(), 34);
                        message.setText("Ignoring " + keyPlatformDependent);
                        message.setMessage(msg);
                        message.open();
                    }
                });
            }
            catch (Throwable throwable) {}
            Log.log((int)2, (String)msg, null);
            isPythonPath = true;
        }
        return isPythonPath;
    }

    public InterpreterInfo makeCopy() {
        return InterpreterInfo.fromString(this.toString(), false);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.executableOrJar;
    }

    public String getNameForUI() {
        if (this.name != null) {
            return String.valueOf(this.name) + "  (" + this.executableOrJar + ")";
        }
        return this.executableOrJar;
    }

    public boolean matchNameBackwardCompatible(String interpreter) {
        if (this.name != null && interpreter.equals(this.name)) {
            return true;
        }
        if (REF.isWindowsPlatform()) {
            return interpreter.equalsIgnoreCase(this.executableOrJar);
        }
        return interpreter.equals(this.executableOrJar);
    }

    public void setStringSubstitutionVariables(Properties stringSubstitutionOriginal) {
        this.stringSubstitutionVariables = stringSubstitutionOriginal == null ? null : stringSubstitutionOriginal;
    }

    public Properties getStringSubstitutionVariables() {
        return this.stringSubstitutionVariables;
    }

    public void addPredefinedCompletionsPath(String path) {
        this.predefinedCompletionsPath.add(path);
        this.clearBuiltinsCache();
    }

    public List<String> getPredefinedCompletionsPath() {
        return new ArrayList<String>(this.predefinedCompletionsPath);
    }

    public File getPredefinedModule(String moduleName) {
        if (this.predefinedBuiltinsCache == null) {
            this.predefinedBuiltinsCache = new HashMap<String, File>();
            for (String s : this.getPredefinedCompletionsPath()) {
                File[] predefs;
                File f = new File(s);
                if (!f.exists()) continue;
                File[] fileArray = predefs = f.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pypredef");
                    }
                });
                int n = predefs.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String n3 = file.getName();
                    String modName = n3.substring(0, n3.length() - ".pypredef".length());
                    this.predefinedBuiltinsCache.put(modName, file);
                    ++n2;
                }
            }
        }
        return this.predefinedBuiltinsCache.get(moduleName);
    }

    public void removePredefinedCompletionPath(String item) {
        this.predefinedCompletionsPath.remove(item);
        this.clearBuiltinsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBuilding() {
        Object object = this.builderLock;
        synchronized (object) {
            if (this.builder == null) {
                IInterpreterInfoBuilder builder = (IInterpreterInfoBuilder)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_interpreter_info_builder", (boolean)false);
                if (builder != null) {
                    builder.setInfo(this);
                    this.builder = builder;
                } else if (!ProjectModulesManager.IN_TESTS) {
                    Log.log((String)"Could not get internal extension for: org.python.pydev.pydev_interpreter_info_builder");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBuilding() {
        Object object = this.builderLock;
        synchronized (object) {
            if (this.builder != null) {
                this.builder.dispose();
                this.builder = null;
            }
        }
    }

    public void setLoadFinished(boolean b) {
        this.loadFinished = b;
    }

    public boolean getLoadFinished() {
        return this.loadFinished;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdditionalEntries
    implements IInterpreterNewCustomEntries {
        private final List<IInterpreterNewCustomEntries> fParticipants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_new_custom_entries");

        AdditionalEntries() {
        }

        @Override
        public Collection<String> getAdditionalLibraries() {
            final ArrayList<String> additions = new ArrayList<String>();
            for (final IInterpreterNewCustomEntries newEntriesProvider : this.fParticipants) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        additions.addAll(newEntriesProvider.getAdditionalLibraries());
                    }
                });
            }
            return additions;
        }

        @Override
        public Collection<String> getAdditionalEnvVariables() {
            final ArrayList<String> additions = new ArrayList<String>();
            for (final IInterpreterNewCustomEntries newEntriesProvider : this.fParticipants) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        additions.addAll(newEntriesProvider.getAdditionalEnvVariables());
                    }
                });
            }
            return additions;
        }

        @Override
        public Collection<String> getAdditionalBuiltins() {
            final ArrayList<String> additions = new ArrayList<String>();
            for (final IInterpreterNewCustomEntries newEntriesProvider : this.fParticipants) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        additions.addAll(newEntriesProvider.getAdditionalBuiltins());
                    }
                });
            }
            return additions;
        }

        @Override
        public Map<String, String> getAdditionalStringSubstitutionVariables() {
            final HashMap<String, String> additions = new HashMap<String, String>();
            for (final IInterpreterNewCustomEntries newEntriesProvider : this.fParticipants) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        additions.putAll(newEntriesProvider.getAdditionalStringSubstitutionVariables());
                    }
                });
            }
            return additions;
        }
    }
}

