/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.plugin.StatusInfo;
import org.python.pydev.ui.dialogs.ArrayContentProvider;
import org.python.pydev.utils.PyFilteredTree;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TreeViewer fTreeViewer;
    private static final int WIDGET_HEIGHT = 250;
    private static final int WIDGET_WIDTH = 300;
    private String natureId;
    private PatternFilter patternFilter;
    private PyFilteredTree filteredTree;

    public ProjectSelectionDialog(Shell parentShell, String natureId) {
        super(parentShell);
        this.setTitle("Select project");
        this.setMessage("Select project");
        this.natureId = natureId;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.patternFilter = new PatternFilter();
        this.filteredTree = PyFilteredTree.create(composite, this.patternFilter, true);
        this.fTreeViewer = this.filteredTree.getViewer();
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTreeViewer.getTree().setLayoutData((Object)data);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTreeViewer.getControl().setFont(font);
        if (this.natureId != null) {
            this.fTreeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IProject) {
                        IProject project = (IProject)element;
                        try {
                            return project.isOpen() && project.hasNature(ProjectSelectionDialog.this.natureId);
                        }
                        catch (CoreException coreException) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        IProject[] input = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fTreeViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus(new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }
}

