/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;
import org.python.pydev.editor.actions.PyAction;

public abstract class PyContainerAction
implements IObjectActionDelegate {
    protected List<IContainer> selectedContainers;

    protected boolean getRefreshBeforeExecute() {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.selectedContainers = null;
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        for (Object o : selections) {
            IAdaptable adaptable;
            IContainer container;
            if (o instanceof IContainer) {
                containers.add((IContainer)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (container = (IContainer)(adaptable = (IAdaptable)o).getAdapter(IContainer.class)) == null) continue;
            containers.add(container);
        }
        this.selectedContainers = containers;
    }

    public void run(IAction action) {
        if (this.selectedContainers == null) {
            return;
        }
        if (!this.confirmRun()) {
            return;
        }
        this.beforeRun();
        final Integer[] nChanged = new Integer[]{0};
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(PyAction.getShell());
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    for (IContainer next : PyContainerAction.this.selectedContainers) {
                        if (PyContainerAction.this.getRefreshBeforeExecute()) {
                            try {
                                next.refreshLocal(2, monitor);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                        nChanged[0] = nChanged[0] + PyContainerAction.this.doActionOnContainer(next, monitor);
                    }
                }
            };
            boolean fork = !this.needsUIThread();
            monitorDialog.run(fork, true, operation);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        this.afterRun(nChanged[0]);
    }

    protected void beforeRun() {
    }

    protected abstract boolean confirmRun();

    protected boolean needsUIThread() {
        return false;
    }

    protected abstract void afterRun(int var1);

    protected abstract int doActionOnContainer(IContainer var1, IProgressMonitor var2);
}

