/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.MenuManagerCopiedToAddCreateMenuWithMenuParent;
import org.python.pydev.ui.ViewPartWithOrientation;

public class SetOrientationAction
extends Action {
    private WeakReference<ViewPartWithOrientation> view;

    public SetOrientationAction(ViewPartWithOrientation view) {
        this.view = new WeakReference<ViewPartWithOrientation>(view);
        this.setMenuCreator(new SetOrientationMenuCreator());
        this.setText("Orientation");
        this.setToolTipText("Update orientation");
    }

    public static interface IActionsMenu {
        public void add(IAction var1);
    }

    public class SetOrientationActionImpl
    extends Action {
        private ViewPartWithOrientation viewPartWithOrientation;
        private int setsValue;

        public SetOrientationActionImpl(ViewPartWithOrientation viewPartWithOrientation, String text, int setsValue) {
            this.setText(text);
            this.viewPartWithOrientation = viewPartWithOrientation;
            this.setsValue = setsValue;
            this.setChecked(this.setsValue == viewPartWithOrientation.getOrientationPreferenceValue());
        }

        public void run() {
            PydevPrefs.getPreferenceStore().setValue(this.viewPartWithOrientation.getOrientationPreferencesKey(), this.setsValue);
        }
    }

    public class SetOrientationMenuCreator
    implements IMenuCreator {
        private Menu fMenu;

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            MenuManagerCopiedToAddCreateMenuWithMenuParent manager = new MenuManagerCopiedToAddCreateMenuWithMenuParent();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(final IMenuManager manager2) {
                    SetOrientationMenuCreator.this.fillMenuManager(new IActionsMenu(){

                        public void add(IAction action) {
                            manager2.add(action);
                        }
                    });
                }
            });
            this.fMenu = manager.createContextMenu(parent);
            return this.fMenu;
        }

        public void fillMenuManager(IActionsMenu actionsMenu) {
            if (SetOrientationAction.this.view == null) {
                return;
            }
            ViewPartWithOrientation viewPartWithOrientation = (ViewPartWithOrientation)((Object)SetOrientationAction.this.view.get());
            if (viewPartWithOrientation == null) {
                return;
            }
            actionsMenu.add((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Automatic", 0));
            actionsMenu.add((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Horizontal", 1));
            actionsMenu.add((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Vertical", 2));
        }
    }
}

