/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.runners.SimpleIronpythonRunner;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.runners.SimpleRunner;

public class UniversalRunner {
    public static AbstractRunner getRunner(IPythonNature nature) {
        try {
            int interpreterType = nature.getInterpreterType();
            switch (interpreterType) {
                case 0: {
                    return new PythonRunner(nature);
                }
                case 1: {
                    return new JythonRunner(nature);
                }
                case 2: {
                    return new IronPythonRunner(nature);
                }
            }
            throw new RuntimeException("Interpreter type " + interpreterType + "not recognized");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractRunner {
        protected IPythonNature nature;

        public AbstractRunner(IPythonNature nature) {
            this.nature = nature;
        }

        public abstract String[] getCommandLine(List<String> var1);

        public Tuple<String, String> runCodeAndGetOutput(String code, String[] args, File workingDir, IProgressMonitor monitor) {
            if (args == null) {
                args = new String[]{};
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("-c");
            cmd.add(code);
            cmd.addAll(Arrays.asList(args));
            return new SimpleRunner().runAndGetOutput(this.getCommandLine(cmd), workingDir, this.nature, monitor, null);
        }

        public Tuple<String, String> runScriptAndGetOutput(String script, String[] args, File workingDir, IProgressMonitor monitor) {
            if (args == null) {
                args = new String[]{};
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(script);
            cmd.addAll(Arrays.asList(args));
            return new SimpleRunner().runAndGetOutput(this.getCommandLine(cmd), workingDir, this.nature, monitor, null);
        }

        public Tuple<Process, String> createProcess(String script, String[] args, File workingDir, IProgressMonitor monitor) {
            File file = new File(script);
            if (!file.exists()) {
                throw new RuntimeException("The script passed for execution (" + script + ") does not exist.");
            }
            if (args == null) {
                args = new String[]{};
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(script);
            cmd.addAll(Arrays.asList(args));
            return new SimpleRunner().run(this.getCommandLine(cmd), workingDir, this.nature, monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IronPythonRunner
    extends AbstractRunner {
        public IronPythonRunner(IPythonNature nature) {
            super(nature);
        }

        @Override
        public String[] getCommandLine(List<String> argumentsAfterPython) {
            try {
                argumentsAfterPython.add(0, "-u");
                return SimpleIronpythonRunner.preparePythonCallParameters(this.nature.getProjectInterpreter().getExecutableOrJar(), argumentsAfterPython.get(0), argumentsAfterPython.subList(1, argumentsAfterPython.size()).toArray(new String[0]), false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JythonRunner
    extends AbstractRunner {
        public JythonRunner(IPythonNature nature) {
            super(nature);
        }

        @Override
        public String[] getCommandLine(List<String> argumentsAfterPython) {
            try {
                return SimpleJythonRunner.makeExecutableCommandStr(this.nature.getProjectInterpreter().getExecutableOrJar(), argumentsAfterPython.get(0), "", argumentsAfterPython.subList(1, argumentsAfterPython.size()).toArray(new String[0]));
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PythonRunner
    extends AbstractRunner {
        public PythonRunner(IPythonNature nature) {
            super(nature);
        }

        @Override
        public String[] getCommandLine(List<String> argumentsAfterPython) {
            String interpreter;
            try {
                interpreter = this.nature.getProjectInterpreter().getExecutableOrJar();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't get the interpreter", e);
            }
            argumentsAfterPython.add(0, "-u");
            argumentsAfterPython.add(0, interpreter);
            return argumentsAfterPython.toArray(new String[argumentsAfterPython.size()]);
        }
    }
}

