/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.editor.codecompletion.revisited.SystemASTManager;
import org.python.pydev.plugin.nature.AbstractPythonNature;

public class SystemPythonNature
extends AbstractPythonNature
implements IPythonNature {
    private final IInterpreterManager manager;
    public final IInterpreterInfo info;
    private SystemASTManager systemASTManager;

    public SystemPythonNature(IInterpreterManager manager) throws MisconfigurationException {
        this(manager, manager.getDefaultInterpreterInfo(false));
    }

    public SystemPythonNature(IInterpreterManager manager, IInterpreterInfo info) {
        this.info = info;
        this.manager = manager;
    }

    public boolean isResourceInPythonpathProjectSources(IResource resource, boolean addExternal) throws MisconfigurationException {
        return super.isResourceInPythonpath(resource);
    }

    public boolean isResourceInPythonpathProjectSources(String resource, boolean addExternal) throws MisconfigurationException {
        return super.isResourceInPythonpath(resource);
    }

    public String resolveModuleOnlyInProjectSources(IResource fileAbsolutePath, boolean addExternal) throws CoreException, MisconfigurationException {
        return super.resolveModule(fileAbsolutePath);
    }

    public String resolveModuleOnlyInProjectSources(String fileAbsolutePath, boolean addExternal) throws CoreException, MisconfigurationException {
        return super.resolveModule(new File(fileAbsolutePath));
    }

    public String getVersion() throws CoreException {
        String version;
        if (this.info != null && (version = this.info.getVersion()) != null && version.startsWith("3")) {
            switch (this.manager.getInterpreterType()) {
                case 0: {
                    return "python 3.0";
                }
                case 1: {
                    return "jython 3.0";
                }
                case 2: {
                    return "python 3.0";
                }
            }
            throw new RuntimeException("Not python nor jython nor iron python?");
        }
        switch (this.manager.getInterpreterType()) {
            case 0: {
                return "python 2.7";
            }
            case 1: {
                return "jython 2.6";
            }
            case 2: {
                return "python 2.7";
            }
        }
        throw new RuntimeException("Not python nor jython nor iron python?");
    }

    public String getDefaultVersion() {
        try {
            return this.getVersion();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void setVersion(String version, String interpreter) throws CoreException {
        throw new RuntimeException("Not Implemented: the system nature is read-only.");
    }

    public int getInterpreterType() throws CoreException {
        return this.manager.getInterpreterType();
    }

    public File getCompletionsCacheDir() {
        throw new RuntimeException("Not Implemented");
    }

    public void saveAstManager() {
        throw new RuntimeException("Not Implemented: system nature is only transient.");
    }

    public IPythonPathNature getPythonPathNature() {
        return new SystemPythonPathNature();
    }

    public String resolveModule(String file) throws MisconfigurationException {
        if (this.info == null) {
            return null;
        }
        return this.info.getModulesManager().resolveModule(file);
    }

    public ICodeCompletionASTManager getAstManager() {
        if (this.systemASTManager == null) {
            this.systemASTManager = new SystemASTManager(this.manager, this, this.info);
        }
        return this.systemASTManager;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return null;
    }

    public void setProject(IProject project) {
    }

    public void rebuildPath() {
        throw new RuntimeException("Not Implemented");
    }

    public void rebuildPath(String defaultSelectedInterpreter, IProgressMonitor monitor) {
        throw new RuntimeException("Not Implemented");
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        return this.manager;
    }

    public IToken[] getBuiltinCompletions() {
        if (!this.isOkToUse()) {
            return null;
        }
        return this.manager.getBuiltinCompletions(this.info.getName());
    }

    public void clearBuiltinCompletions() {
        this.manager.clearBuiltinCompletions(this.info.getName());
    }

    public IModule getBuiltinMod() {
        if (!this.isOkToUse()) {
            return null;
        }
        return this.manager.getBuiltinMod(this.info.getName());
    }

    public void clearBuiltinMod() {
        this.manager.clearBuiltinMod(this.info.getName());
    }

    public int getGrammarVersion() throws MisconfigurationException {
        IInterpreterInfo info = this.info;
        if (info != null) {
            return info.getGrammarVersion();
        }
        return 13;
    }

    public IInterpreterInfo getProjectInterpreter() throws MisconfigurationException {
        return this.info;
    }

    public boolean isOkToUse() {
        return this.manager != null && this.info != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SystemPythonPathNature
    implements IPythonPathNature {
        private SystemPythonPathNature() {
        }

        public void setVariableSubstitution(Map<String, String> variableSubstitution) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public void setProjectSourcePath(String newSourcePath) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public void setProjectExternalSourcePath(String newExternalSourcePath) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public void setProject(IProject project, IPythonNature nature) {
            throw new RuntimeException("Not implemented");
        }

        public Map<String, String> getVariableSubstitution(boolean addInterpreterInfoSubstitutions) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
            return this.getVariableSubstitution();
        }

        public Map<String, String> getVariableSubstitution() throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
            Properties stringSubstitutionVariables = SystemPythonNature.this.info.getStringSubstitutionVariables();
            HashMap<String, String> variableSubstitution = stringSubstitutionVariables == null ? new HashMap<String, String>() : PropertiesHelper.createMapFromProperties((Properties)stringSubstitutionVariables);
            return variableSubstitution;
        }

        public Set<String> getProjectSourcePathSet(boolean replaceVariables) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public String getProjectSourcePath(boolean replaceVariables) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public List<String> getProjectExternalSourcePathAsList(boolean replaceVariables) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public String getProjectExternalSourcePath(boolean replaceVariables) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public String getOnlyProjectPythonPathStr(boolean addExternal) throws CoreException {
            throw new RuntimeException("Not implemented");
        }

        public IPythonNature getNature() {
            return SystemPythonNature.this;
        }

        public List<String> getCompleteProjectPythonPath(IInterpreterInfo interpreter, IInterpreterManager info) {
            return interpreter.getPythonPath();
        }

        public void clearCaches() {
        }
    }
}

