/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.plugin.nature.IPythonNatureStore;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.PythonPathNature;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PythonNatureStore
implements IResourceChangeListener,
IPythonNatureStore {
    private static final String STORE_FILE_NAME = ".pydevproject";
    private volatile IProject project = null;
    private volatile IFile xmlFile = null;
    private volatile String lastLoadedContents = null;
    private volatile boolean loaded = false;
    private volatile Document document = null;
    private static final boolean TRACE_PYTHON_NATURE_STORE = false;
    private StringBuffer indent = new StringBuffer();
    private volatile boolean inInit;

    PythonNatureStore() {
    }

    public String getLastLoadedContents() {
        return this.lastLoadedContents;
    }

    private void traceFunc(String func, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProject(IProject project) {
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (project == null) {
                if (this.project == null) {
                    return;
                }
                this.traceFunc("setProject: null", new Object[0]);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this.project = null;
                this.xmlFile = null;
                this.document = null;
            } else {
                this.traceFunc("setProject - ", project.getName());
                try {
                    this.project = project;
                    this.xmlFile = project.getFile(STORE_FILE_NAME);
                    try {
                        this.loadFromFile();
                    }
                    catch (CoreException e) {
                        throw new RuntimeException("Error loading project: " + project, e);
                    }
                    if (!ProjectModulesManager.IN_TESTS) {
                        project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
                    }
                }
                finally {
                    this.loaded = true;
                }
                this.traceFunc("END setProject - ", project.getName());
            }
        }
    }

    private synchronized void checkLoad(String function) {
        if (!this.loaded) {
            RuntimeException e = new RuntimeException(StringUtils.format((String)"%s still not loaded and '%s' already called.", (Object[])new Object[]{this.xmlFile, function}));
            Log.log((Throwable)e);
        }
    }

    @Override
    public synchronized String getPathProperty(QualifiedName key) throws CoreException {
        if (this.project == null) {
            return "";
        }
        this.checkLoad("getPathProperty");
        String ret = this.getPathStringFromArray(this.getPathPropertyFromXml(key));
        this.traceFunc("END getPathProperty - ", key, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, String> getMapProperty(QualifiedName key) throws CoreException {
        if (this.project == null) {
            return null;
        }
        this.checkLoad("getMapProperty");
        String[] keyAndValues = null;
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                Node propertyNode = this.findPropertyNodeInXml("pydev_variables_property", key);
                if (propertyNode != null) {
                    keyAndValues = this.getChildValuesWithType(propertyNode, "key", "value");
                }
            }
            catch (Exception e) {
                this.traceFunc("END getMapProperty (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Map<String, String> ret = null;
        if (keyAndValues != null) {
            ret = this.getMapStringFromArray(keyAndValues);
        }
        this.traceFunc("END getMapProperty - ", key, ret);
        return ret;
    }

    @Override
    public synchronized void setPathProperty(QualifiedName key, String value) throws CoreException {
        this.checkLoad("setPathProperty");
        this.setPathPropertyToXml(key, this.getArrayFromPathString(value), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setMapProperty(QualifiedName key, Map<String, String> value) throws CoreException {
        this.checkLoad("setMapProperty");
        this.traceFunc("setMapProperty", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                boolean store = true;
                Node oldChild = this.findPropertyNodeInXml("pydev_variables_property", key);
                if (oldChild != null && (value == null || value.size() == 0)) {
                    this.getRootNodeInXml().removeChild(oldChild);
                } else if (value != null && value.size() > 0) {
                    Element property = this.document.createElement("pydev_variables_property");
                    Attr propertyName = this.document.createAttribute("name");
                    propertyName.setNodeValue(this.getKeyString(key));
                    property.getAttributes().setNamedItem(propertyName);
                    Set<Map.Entry<String, String>> entrySet = value.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        Element childKey = this.document.createElement("key");
                        this.setTextContent(entry.getKey(), childKey);
                        property.appendChild(childKey);
                        Element childValue = this.document.createElement("value");
                        this.setTextContent(entry.getValue(), childValue);
                        property.appendChild(childValue);
                    }
                    if (oldChild == null) {
                        this.getRootNodeInXml().appendChild(property);
                    } else {
                        this.getRootNodeInXml().replaceChild(property, oldChild);
                    }
                } else {
                    store = false;
                }
                if (store) {
                    this.doStore();
                }
            }
            catch (Exception e) {
                this.traceFunc("END setMapProperty (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        this.traceFunc("END setMapProperty", new Object[0]);
    }

    private synchronized boolean loadFromFile() throws CoreException {
        String fileContents;
        File file;
        DocumentBuilder parser;
        block12: {
            block10: {
                block11: {
                    if (this.project == null) {
                        return false;
                    }
                    this.traceFunc("loadFromFile", new Object[0]);
                    try {
                        parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    }
                    catch (ParserConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                    file = this.getRawXmlFileLocation();
                    try {
                        if (file != null && file.exists()) break block10;
                        if (this.document == null) break block11;
                        this.doStore();
                        return true;
                    }
                    catch (Exception e) {
                        this.handleProblemInXmlDocument(parser, file, e);
                        this.traceFunc("END loadFromFile", new Object[0]);
                        return false;
                    }
                }
                this.createAndSetInMemoryDocument(parser);
                this.doStore();
                return true;
            }
            fileContents = REF.getFileContents((File)file);
            if (this.lastLoadedContents == null || !fileContents.equals(this.lastLoadedContents)) break block12;
            return false;
        }
        this.lastLoadedContents = fileContents;
        try {
            this.document = parser.parse(new ByteArrayInputStream(fileContents.getBytes()));
        }
        catch (Exception e) {
            this.handleProblemInXmlDocument(parser, file, e);
        }
        return true;
    }

    private void handleProblemInXmlDocument(DocumentBuilder parser, File file, Exception e) throws CoreException {
        Log.log((String)("Error loading contents from .pydevproject: " + file), (Throwable)e);
        try {
            REF.createBackupFile((File)file);
        }
        catch (Exception exception) {
            Log.log((String)("Error creating backup for: " + file), (Throwable)e);
        }
        this.createAndSetInMemoryDocument(parser);
        this.doStore();
    }

    private void createAndSetInMemoryDocument(DocumentBuilder parser) throws CoreException {
        this.document = parser.newDocument();
        ProcessingInstruction version = this.document.createProcessingInstruction("eclipse-pydev", "version=\"1.0\"");
        this.document.appendChild(version);
        Element configRootElement = this.document.createElement("pydev_project");
        this.document.appendChild(configRootElement);
        this.migrateProperty(PythonNature.getPythonProjectVersionQualifiedName());
        this.migratePath(PythonPathNature.getProjectSourcePathQualifiedName());
        this.migratePath(PythonPathNature.getProjectExternalSourcePathQualifiedName());
    }

    private File getRawXmlFileLocation() {
        IPath rawLocation = this.xmlFile.getRawLocation();
        File file = null;
        if (rawLocation != null) {
            file = rawLocation.toFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void migrateProperty(QualifiedName key) throws CoreException {
        this.traceFunc("migrateProperty", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            String propertyVal = this.project.getPersistentProperty(key);
            if (propertyVal != null) {
                this.setPropertyToXml(key, propertyVal, false);
                this.project.setPersistentProperty(key, null);
            }
        }
        this.traceFunc("END migrateProperty", new Object[0]);
    }

    private synchronized void migratePath(QualifiedName key) throws CoreException {
        this.traceFunc("migratePath", new Object[0]);
        String[] propertyVal = this.getArrayFromPathString(this.project.getPersistentProperty(key));
        if (propertyVal != null) {
            this.setPathPropertyToXml(key, propertyVal, false);
            this.project.setPersistentProperty(key, null);
        }
        this.traceFunc("END migratePath", new Object[0]);
    }

    private synchronized Node getRootNodeInXml() throws MisconfigurationException {
        this.traceFunc("getRootNodeInXml", new Object[0]);
        if (this.document == null) {
            throw new MisconfigurationException("Found null XML document. Please check if " + this.xmlFile + " is a valid XML file.");
        }
        NodeList nodeList = this.document.getElementsByTagName("pydev_project");
        Node ret = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            ret = nodeList.item(0);
        }
        this.traceFunc("END getRootNodeInXml -- ", ret);
        if (ret != null) {
            return ret;
        }
        throw new RuntimeException(StringUtils.format((String)"Error. Unable to get the %s tag by its name. Project: %s", (Object[])new Object[]{"pydev_project", this.project}));
    }

    private synchronized String getKeyString(QualifiedName key) {
        this.traceFunc("getKeyString", new Object[0]);
        String keyString = key.getQualifier() != null ? key.getQualifier() : "";
        String ret = String.valueOf(keyString) + "." + key.getLocalName();
        this.traceFunc("END getKeyString", new Object[0]);
        return ret;
    }

    private synchronized Node findPropertyNodeInXml(String type, QualifiedName key) throws MisconfigurationException {
        this.traceFunc("findPropertyNodeInXml", new Object[0]);
        Node root = this.getRootNodeInXml();
        NodeList childNodes = root.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            String keyString = this.getKeyString(key);
            int i = 0;
            while (i < childNodes.getLength()) {
                String name;
                Node namedItem;
                NamedNodeMap attrs;
                Node child = childNodes.item(i);
                if (child.getNodeName().equals(type) && (attrs = child.getAttributes()) != null && attrs.getLength() > 0 && (namedItem = attrs.getNamedItem("name")) != null && (name = namedItem.getNodeValue()) != null && name.equals(keyString)) {
                    this.traceFunc("END findPropertyNodeInXml - ", child);
                    return child;
                }
                ++i;
            }
        }
        this.traceFunc("END findPropertyNodeInXml (null)", new Object[0]);
        return null;
    }

    private String[] getChildValuesWithType(Node node, String ... type) {
        this.traceFunc("getChildValuesWithType", new Object[0]);
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                String nodeName = child.getNodeName();
                String[] stringArray = type;
                int n = type.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if (nodeName.equals(t)) {
                        result.add(this.getTextContent(child));
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
            String[] retval = new String[result.size()];
            this.traceFunc("END getChildValuesWithType", new Object[0]);
            return result.toArray(retval);
        }
        this.traceFunc("END getChildValuesWithType (null)", new Object[0]);
        return null;
    }

    private void addChildValuesWithType(Node node, String type, String[] values) {
        this.traceFunc("addChildValuesWithType", new Object[0]);
        assert (node != null);
        assert (values != null);
        assert (type != null);
        int i = 0;
        while (i < values.length) {
            Element child = this.document.createElement(type);
            this.setTextContent(values[i], child);
            node.appendChild(child);
            ++i;
        }
        this.traceFunc("END addChildValuesWithType", new Object[0]);
    }

    private String getPathStringFromArray(String[] pathArray) {
        this.traceFunc("getPathStringFromArray", new Object[0]);
        if (pathArray != null) {
            FastStringBuffer s = new FastStringBuffer();
            int i = 0;
            while (i < pathArray.length) {
                if (i > 0) {
                    s.append('|');
                }
                s.append(pathArray[i]);
                ++i;
            }
            this.traceFunc("END getPathStringFromArray", new Object[0]);
            return s.toString();
        }
        this.traceFunc("END getPathStringFromArray (null)", new Object[0]);
        return null;
    }

    private Map<String, String> getMapStringFromArray(String[] pathArray) {
        this.traceFunc("getMapStringFromArray", new Object[0]);
        if (pathArray != null) {
            HashMap<String, String> ret = new HashMap<String, String>();
            int i = 0;
            while (i < pathArray.length - 1) {
                String key = pathArray[i];
                String val = pathArray[i + 1];
                ret.put(key, val);
                i += 2;
            }
            return ret;
        }
        this.traceFunc("END getMapStringFromArray (null)", new Object[0]);
        return null;
    }

    private String[] getArrayFromPathString(String pathString) {
        this.traceFunc("getArrayFromPathString", new Object[0]);
        if (pathString != null) {
            this.traceFunc("END getArrayFromPathString", new Object[0]);
            return pathString.split("\\|");
        }
        this.traceFunc("END getArrayFromPathString (null)", new Object[0]);
        return null;
    }

    @Override
    public synchronized String getPropertyFromXml(QualifiedName key) {
        if (this.project == null) {
            return "";
        }
        this.traceFunc("getPropertyFromXml - ", key);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            this.checkLoad("getPropertyFromXml");
            try {
                Node propertyNode = this.findPropertyNodeInXml("pydev_property", key);
                if (propertyNode != null) {
                    String ret = this.getTextContent(propertyNode);
                    this.traceFunc("END getPropertyFromXml -- ", ret);
                    return ret;
                }
                this.traceFunc("END getPropertyFromXml (null)", new Object[0]);
                return null;
            }
            catch (Exception e) {
                this.traceFunc("END getPropertyFromXml (EXCEPTION)", new Object[0]);
                throw new RuntimeException("Error on document:" + this.document + " project:" + this.project, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setPropertyToXml(QualifiedName key, String value, boolean store) throws CoreException {
        this.traceFunc(StringUtils.format((String)"setPropertyToXml key:%s value:%s store:%s", (Object[])new Object[]{key, value, store}), new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (store) {
                this.checkLoad("setPropertyToXml");
            }
            try {
                Node child = this.findPropertyNodeInXml("pydev_property", key);
                if (child != null) {
                    if (value == null) {
                        this.getRootNodeInXml().removeChild(child);
                    } else {
                        this.setTextContent(value, child);
                    }
                } else if (value != null) {
                    Element property = this.document.createElement("pydev_property");
                    Attr propertyName = this.document.createAttribute("name");
                    propertyName.setNodeValue(this.getKeyString(key));
                    property.getAttributes().setNamedItem(propertyName);
                    this.setTextContent(value, property);
                    this.getRootNodeInXml().appendChild(property);
                } else {
                    store = false;
                }
                if (store) {
                    this.doStore();
                }
            }
            catch (Exception e) {
                this.traceFunc("END setPropertyToXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        this.traceFunc("END setPropertyToXml", new Object[0]);
    }

    private void setTextContent(String textContent, Node self) throws DOMException {
        Node child;
        this.traceFunc("setTextContent", new Object[0]);
        while ((child = self.getFirstChild()) != null) {
            self.removeChild(child);
        }
        if (textContent != null && textContent.length() != 0) {
            self.appendChild(this.document.createTextNode(textContent));
        }
        this.traceFunc("END setTextContent", new Object[0]);
    }

    private String getTextContent(Node self) throws DOMException {
        this.traceFunc("getTextContent", new Object[0]);
        FastStringBuffer fBufferStr = new FastStringBuffer();
        Node child = self.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                String nodeValue;
                if (this.hasTextContent(child) && (nodeValue = child.getNodeValue()) != null) {
                    this.traceFunc("END getTextContent - ", nodeValue);
                    return nodeValue;
                }
                this.traceFunc("END getTextContent - EMPTY", new Object[0]);
                return "";
            }
            fBufferStr.clear();
            this.getTextContent(fBufferStr, self);
            this.traceFunc("END getTextContent - ", fBufferStr);
            return fBufferStr.toString();
        }
        this.traceFunc("END getTextContent - EMPTY", new Object[0]);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getTextContent(FastStringBuffer buf, Node self) throws DOMException {
        this.traceFunc("getTextContent", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            Node child = self.getFirstChild();
            while (child != null) {
                if (this.hasTextContent(child)) {
                    this.getTextContent(buf, child);
                }
                child = child.getNextSibling();
            }
        }
        this.traceFunc("END getTextContent", new Object[0]);
    }

    private boolean hasTextContent(Node child) {
        this.traceFunc("hasTextContent", new Object[0]);
        boolean ret = child.getNodeType() != 8 && child.getNodeType() != 7;
        this.traceFunc("END hasTextContent ", ret);
        return ret;
    }

    private String[] getPathPropertyFromXml(QualifiedName key) throws CoreException {
        this.traceFunc("getPathPropertyFromXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                Node propertyNode = this.findPropertyNodeInXml("pydev_pathproperty", key);
                if (propertyNode != null) {
                    this.traceFunc("END getPathPropertyFromXml", new Object[0]);
                    return this.getChildValuesWithType(propertyNode, "path");
                }
                this.traceFunc("END getPathPropertyFromXml (null)", new Object[0]);
                return null;
            }
            catch (Exception e) {
                this.traceFunc("END getPathPropertyFromXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPathPropertyToXml(QualifiedName key, String[] paths, boolean store) throws CoreException {
        this.traceFunc("setPathPropertyToXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                Node oldChild = this.findPropertyNodeInXml("pydev_pathproperty", key);
                if (paths != null) {
                    ArrayList<String> pathsList = new ArrayList<String>();
                    String[] stringArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        if (p != null && p.length() > 0) {
                            pathsList.add(p);
                        }
                        ++n2;
                    }
                    paths = pathsList.toArray(new String[0]);
                }
                if (oldChild != null && (paths == null || paths.length == 0)) {
                    this.getRootNodeInXml().removeChild(oldChild);
                } else if (paths != null) {
                    Element property = this.document.createElement("pydev_pathproperty");
                    Attr propertyName = this.document.createAttribute("name");
                    propertyName.setNodeValue(this.getKeyString(key));
                    property.getAttributes().setNamedItem(propertyName);
                    this.addChildValuesWithType(property, "path", paths);
                    if (oldChild == null) {
                        this.getRootNodeInXml().appendChild(property);
                    } else {
                        this.getRootNodeInXml().replaceChild(property, oldChild);
                    }
                } else {
                    store = false;
                }
                if (store) {
                    this.doStore();
                }
            }
            catch (Exception e) {
                this.traceFunc("END setPathPropertyToXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        this.traceFunc("END setPathPropertyToXml", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeDocument(Document doc) throws IOException, TransformerException {
        this.traceFunc("serializeDocument", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            this.traceFunc("END serializeDocument", new Object[0]);
            return s.toByteArray();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        PythonNature nature;
        if (this.project == null) {
            return;
        }
        this.traceFunc("resourceChanged -- ", this.project.getName());
        if (this.inInit) {
            this.traceFunc("END resourceChanged (inInit)", new Object[0]);
            return;
        }
        boolean doRebuild = false;
        if (!this.project.isOpen()) {
            this.traceFunc("END resourceChanged (!open)", new Object[0]);
            return;
        }
        IResourceDelta eventDelta = event.getDelta();
        if (eventDelta == null) {
            this.traceFunc("END resourceChanged (eventDelta == null)", new Object[0]);
            return;
        }
        IResourceDelta delta = eventDelta.findMember(this.xmlFile.getFullPath());
        if (delta != null) {
            try {
                if (this.loadFromFile()) {
                    doRebuild = true;
                }
            }
            catch (CoreException e) {
                this.traceFunc("END resourceChanged (EXCEPTION)", new Object[0]);
                throw new RuntimeException(e);
            }
        }
        if (doRebuild && (nature = PythonNature.getPythonNature(this.project)) != null) {
            nature.rebuildPath();
        }
        this.traceFunc("END resourceChanged -- rebuilt:", doRebuild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IStatus doStore() {
        if (this.project == null) {
            return Status.OK_STATUS;
        }
        this.traceFunc("doStore", new Object[0]);
        if (this.inInit) {
            this.traceFunc("END doStore (inInit)", new Object[0]);
            return Status.OK_STATUS;
        }
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (this.document == null) {
                this.traceFunc("END doStore (document == null)", new Object[0]);
                return new Status(4, "PythonNatureStore.doStore", -2, "document == null", (Throwable)new RuntimeException("document == null"));
            }
            File file = this.getRawXmlFileLocation();
            try {
                String str;
                this.lastLoadedContents = str = new String(this.serializeDocument(this.document));
                if (file == null) {
                    if (!ProjectModulesManager.IN_TESTS) {
                        Log.log((String)"Error: xml file should only be null in tests (when no workspace is available)");
                    }
                    return Status.OK_STATUS;
                }
                REF.writeStrToFile((String)str, (File)file);
            }
            catch (Exception e) {
                Log.log((String)("Unable to write contents of file: " + file), (Throwable)e);
            }
            this.traceFunc("END doStore", new Object[0]);
            return Status.OK_STATUS;
        }
    }

    @Override
    public void startInit() {
        this.inInit = true;
    }

    @Override
    public void endInit() {
        this.inInit = false;
        this.doStore();
    }
}

