/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.outline.AbstractOutlineFilterAction;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;

public class OutlineHideFieldsAction
extends AbstractOutlineFilterAction {
    private static final String PREF_HIDE_FIELDS = "org.python.pydev.OUTLINE_HIDE_FIELDS";

    public OutlineHideFieldsAction(PyOutlinePage page, ImageCache imageCache) {
        super("Hide Fields", page, imageCache, PREF_HIDE_FIELDS, "icons/fields_co.gif");
    }

    protected ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ParsedItem) {
                    SimpleNode parentToken;
                    ASTEntryWithChildren ast;
                    ParsedItem parentItem;
                    ParsedItem item = (ParsedItem)element;
                    ASTEntryWithChildren astThis = item.getAstThis();
                    if (astThis == null) {
                        return true;
                    }
                    SimpleNode token = astThis.node;
                    if (token instanceof Attribute) {
                        return false;
                    }
                    if (token instanceof Name && parentElement instanceof ParsedItem && (parentItem = (ParsedItem)parentElement) != null && (ast = parentItem.getAstThis()) != null && (parentToken = ast.node) instanceof ClassDef) {
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

