/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;

public class Definition
implements IDefinition {
    public final int line;
    public final int col;
    public final String value;
    public final IModule module;
    public final SimpleNode ast;
    public final ILocalScope scope;
    public final boolean foundAsLocal;

    public Definition(int line, int col, String value, SimpleNode ast, ILocalScope scope, IModule module) {
        this(line, col, value, ast, scope, module, false);
    }

    public Definition(int line, int col, String value, SimpleNode ast, ILocalScope scope, IModule module, boolean foundAsLocal) {
        Assert.isNotNull((Object)value, (String)"Invalid value.");
        Assert.isNotNull((Object)module, (String)"Invalid Module.");
        this.line = line;
        this.col = col;
        this.value = value;
        this.ast = ast;
        this.scope = scope;
        this.module = module;
        this.foundAsLocal = foundAsLocal;
    }

    public Definition(IToken tok, ILocalScope scope, IModule module) {
        this(tok, scope, module, false);
    }

    public Definition(IToken tok, ILocalScope scope, IModule module, boolean foundAsLocal) {
        Assert.isNotNull((Object)tok, (String)"Invalid value.");
        Assert.isNotNull((Object)module, (String)"Invalid Module.");
        this.line = tok.getLineDefinition();
        this.col = tok.getColDefinition();
        this.value = tok.getRepresentation();
        this.ast = tok instanceof SourceToken ? ((SourceToken)tok).getAst() : null;
        this.scope = scope;
        this.module = module;
        this.foundAsLocal = foundAsLocal;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer("Definition=", 30 + this.value.length());
        buffer.append(this.value);
        buffer.append(" line=");
        buffer.append(this.line);
        buffer.append(" col=");
        buffer.append(this.col);
        buffer.append(" module=");
        if (this.module != null) {
            buffer.appendObject((Object)this.module.getName());
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition d = (Definition)obj;
        if (!this.value.equals(d.value)) {
            return false;
        }
        if (this.col != d.col) {
            return false;
        }
        if (this.line != d.line) {
            return false;
        }
        if (this.scope == d.scope) {
            return true;
        }
        if (this.scope == null || d.scope == null) {
            return false;
        }
        return this.scope.equals(d.scope);
    }

    public int hashCode() {
        return this.value.hashCode() + this.col + this.line;
    }

    public IModule getModule() {
        return this.module;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getDocstring(IPythonNature nature, ICompletionCache cache) {
        if (this.ast != null) {
            return NodeUtils.getNodeDocString((SimpleNode)this.ast);
        }
        if (this.value == null || this.value.trim().length() == 0) {
            return this.module.getDocString();
        }
        if (nature != null) {
            IToken[] globalTokens;
            ICodeCompletionASTManager manager = nature.getAstManager();
            String[] headAndTail = FullRepIterable.headAndTail((String)this.value);
            String actToken = headAndTail[0];
            String qualifier = headAndTail[1];
            IToken[] iTokenArray = globalTokens = this.module.getGlobalTokens((ICompletionState)new CompletionState(this.line, this.col, actToken, nature, qualifier, cache), manager);
            int n = globalTokens.length;
            int n2 = 0;
            while (n2 < n) {
                IToken iToken = iTokenArray[n2];
                String rep = iToken.getRepresentation();
                if (this.value.equals(rep) || qualifier.equals(rep)) {
                    return iToken.getDocStr();
                }
                ++n2;
            }
        }
        return null;
    }
}

