/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.ModulesKeyForJava;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModulesManagerWithBuild
extends ModulesManager
implements IDeltaProcessor<ModulesKey> {
    public static boolean IN_TESTS = false;
    protected volatile DeltaSaver<ModulesKey> deltaSaver;
    protected static ICallback<ModulesKey, String> readFromFileMethod = new ICallback<ModulesKey, String>(){

        public ModulesKey call(String arg) {
            List split = StringUtils.split((String)arg, (char)'|');
            if (split.size() == 1) {
                return new ModulesKey((String)split.get(0), null);
            }
            if (split.size() == 2) {
                return new ModulesKey((String)split.get(0), new File((String)split.get(1)));
            }
            return null;
        }
    };
    protected static ICallback<String, ModulesKey> toFileMethod = new ICallback<String, ModulesKey>(){

        public String call(ModulesKey arg) {
            FastStringBuffer buf = new FastStringBuffer();
            buf.append(arg.name);
            if (arg.file != null) {
                buf.append("|");
                buf.append(arg.file.toString());
            }
            return buf.toString();
        }
    };

    public void processUpdate(ModulesKey data) {
        throw new RuntimeException("Not impl");
    }

    public void processDelete(ModulesKey key) {
        this.doRemoveSingleModule(key);
    }

    public void processInsert(ModulesKey key) {
        this.addModule(key);
    }

    @Override
    public void doRemoveSingleModule(ModulesKey key) {
        super.doRemoveSingleModule(key);
        if (this.deltaSaver != null && !IN_TESTS) {
            this.deltaSaver.addDeleteCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    @Override
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        super.doAddSingleModule(key, n);
        if (!(this.deltaSaver == null || IN_TESTS || key instanceof ModulesKeyForZip || key instanceof ModulesKeyForJava)) {
            this.deltaSaver.addInsertCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    private void checkDeltaSize() {
        if (this.deltaSaver != null && this.deltaSaver.availableDeltas() > 100) {
            this.endProcessing();
            this.deltaSaver.clearAll();
        }
    }

    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.removeModulesBelow(file, project, monitor);
        } else if (file.getName().startsWith("__init__.")) {
            this.removeModulesBelow(file.getParentFile(), project, monitor);
        } else {
            this.removeModulesWithFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesWithFile(File file) {
        if (file == null) {
            return;
        }
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (key.file == null || !key.file.equals(file)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesBelow(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        String absolutePath = REF.getFileAbsolutePath((File)file);
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (key.file == null || !REF.getFileAbsolutePath((File)key.file).startsWith(absolutePath)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildModule(File f, ICallback0<IDocument> doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        String m = this.pythonPathHelper.resolveModule(REF.getFileAbsolutePath((File)f));
        if (m != null) {
            this.addModule(new ModulesKey(m, f));
        } else if (f != null) {
            Object object = this.modulesKeysLock;
            synchronized (object) {
                HashSet<ModulesKey> toRemove = new HashSet<ModulesKey>();
                for (ModulesKey key : this.modulesKeys.keySet()) {
                    if (key.file == null || !key.file.equals(f)) continue;
                    toRemove.add(key);
                }
                this.removeThem(toRemove);
            }
        }
    }
}

