/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.SelectionKeeper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.plugin.preferences.PyCodeFormatterPage;

public class PyFormatStd
extends PyAction
implements IFormatter {
    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            PySelection ps = new PySelection((ITextEditor)pyEdit);
            try {
                int[] regionsToFormat = null;
                if (ps.getSelLength() > 0) {
                    int startLineIndex = ps.getStartLineIndex();
                    int endLineIndex = ps.getEndLineIndex();
                    regionsToFormat = new int[endLineIndex - startLineIndex + 1];
                    int i = startLineIndex;
                    int j = 0;
                    while (i <= endLineIndex) {
                        regionsToFormat[j] = i++;
                        ++j;
                    }
                }
                this.applyFormatAction(pyEdit, ps, regionsToFormat, true);
            }
            catch (SyntaxErrorException e) {
                pyEdit.getStatusLineManager().setErrorMessage(e.getMessage());
            }
        }
        catch (Exception e) {
            PyFormatStd.beep(e);
        }
    }

    public void applyFormatAction(PyEdit pyEdit, PySelection ps, int[] regionsToFormat, boolean throwSyntaxError) throws BadLocationException, SyntaxErrorException {
        IFormatter participant = this.getFormatter();
        IDocument doc = ps.getDoc();
        SelectionKeeper selectionKeeper = new SelectionKeeper(ps);
        DocumentRewriteSession session = null;
        try {
            if (regionsToFormat == null || regionsToFormat.length == 0) {
                if (doc instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext = (IDocumentExtension4)doc;
                    session = ext.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
                }
                participant.formatAll(doc, (IPyEdit)pyEdit, true, throwSyntaxError);
            } else {
                if (doc instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext = (IDocumentExtension4)doc;
                    session = ext.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                }
                participant.formatSelection(doc, regionsToFormat, (IPyEdit)pyEdit, ps);
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)doc).stopRewriteSession(session);
            }
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)doc).stopRewriteSession(session);
        }
        selectionKeeper.restoreSelection(pyEdit.getSelectionProvider(), doc);
    }

    public IFormatter getFormatter() {
        IFormatter participant = (IFormatter)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_formatter", (boolean)false);
        if (participant == null) {
            participant = this;
        }
        return participant;
    }

    public void formatSelection(IDocument doc, int[] regionsForSave, IPyEdit edit, PySelection ps) {
        FormatStd formatStd = PyFormatStd.getFormat();
        this.formatSelection(doc, regionsForSave, edit, ps, formatStd);
    }

    public void formatSelection(IDocument doc, int[] regionsForSave, IPyEdit edit, PySelection ps, FormatStd formatStd) {
        Document formatted;
        ArrayList<Tuple3> replaces = new ArrayList<Tuple3>();
        String docContents = doc.get();
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        try {
            formatted = new Document(this.formatAll(formatStd, true, docContents, delimiter));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            return;
        }
        try {
            int[] nArray = regionsForSave;
            int n = regionsForSave.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                IRegion r = doc.getLineInformation(i);
                int iStart = r.getOffset();
                int iEnd = r.getOffset() + r.getLength();
                String line = PySelection.getLine((IDocument)formatted, (int)i);
                replaces.add(new Tuple3((Object)iStart, (Object)(iEnd - iStart), (Object)line));
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
            return;
        }
        Collections.reverse(replaces);
        for (Tuple3 tup : replaces) {
            try {
                doc.replace(((Integer)tup.o1).intValue(), ((Integer)tup.o2).intValue(), (String)tup.o3);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
        if (formatStd.addNewLineAtEndOfFile) {
            try {
                char lastChar;
                int len = doc.getLength();
                if (len > 0 && (lastChar = doc.getChar(len - 1)) != '\r' && lastChar != '\n') {
                    doc.replace(len, 0, PySelection.getDelimiter((IDocument)doc));
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void formatAll(IDocument doc, IPyEdit edit, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        FormatStd formatStd = PyFormatStd.getFormat();
        this.formatAll(doc, edit, isOpenedFile, formatStd, throwSyntaxError);
    }

    public void formatAll(IDocument doc, IPyEdit edit, boolean isOpenedFile, FormatStd formatStd, boolean throwSyntaxError) throws SyntaxErrorException {
        String d = doc.get();
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        String formatted = this.formatAll(formatStd, throwSyntaxError, d, delimiter);
        String contents = doc.get();
        if (contents.equals(formatted)) {
            return;
        }
        if (!isOpenedFile) {
            doc.set(formatted);
        } else {
            int contentsLen = contents.length();
            int minorLen = contentsLen > formatted.length() ? formatted.length() : contentsLen;
            int applyFrom = 0;
            while (applyFrom < minorLen) {
                if (contents.charAt(applyFrom) != formatted.charAt(applyFrom)) break;
                ++applyFrom;
            }
            try {
                doc.replace(applyFrom, contentsLen - applyFrom, formatted.substring(applyFrom));
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
    }

    private String formatAll(FormatStd formatStd, boolean throwSyntaxError, String d, String delimiter) throws SyntaxErrorException {
        String formatted = this.formatStr(d, formatStd, delimiter, throwSyntaxError);
        if (formatStd.addNewLineAtEndOfFile) {
            try {
                char lastChar;
                int len = formatted.length();
                if (len > 0 && (lastChar = formatted.charAt(len - 1)) != '\r' && lastChar != '\n') {
                    formatted = String.valueOf(formatted) + delimiter;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        return formatted;
    }

    public static FormatStd getFormat() {
        FormatStd formatStd = new FormatStd();
        formatStd.assignWithSpaceInsideParens = PyCodeFormatterPage.useAssignWithSpacesInsideParenthesis();
        formatStd.operatorsWithSpace = PyCodeFormatterPage.useOperatorsWithSpace();
        formatStd.parametersWithSpace = PyCodeFormatterPage.useSpaceForParentesis();
        formatStd.spaceAfterComma = PyCodeFormatterPage.useSpaceAfterComma();
        formatStd.addNewLineAtEndOfFile = PyCodeFormatterPage.getAddNewLineAtEndOfFile();
        formatStd.trimLines = PyCodeFormatterPage.getTrimLines();
        formatStd.trimMultilineLiterals = PyCodeFormatterPage.getTrimMultilineLiterals();
        return formatStd;
    }

    String formatStr(String str, FormatStd std, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        return this.formatStr(str, std, 0, delimiter, throwSyntaxError);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String formatStr(String str, FormatStd std, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        char[] cs = str.toCharArray();
        FastStringBuffer buf = new FastStringBuffer();
        ParsingUtils parsingUtils = ParsingUtils.create((Object)cs, (boolean)throwSyntaxError);
        char lastChar = '\u0000';
        int i = 0;
        while (i < cs.length) {
            char c = cs[i];
            block0 : switch (c) {
                case '\"': 
                case '\'': {
                    i = parsingUtils.eatLiterals(buf, i, std.trimMultilineLiterals);
                    break;
                }
                case '#': {
                    i = parsingUtils.eatComments(buf, i);
                    break;
                }
                case ',': {
                    i = this.formatForComma(std, cs, buf, i);
                    break;
                }
                case '(': {
                    i = this.formatForPar(parsingUtils, cs, i, std, buf, parensLevel + 1, delimiter, throwSyntaxError);
                    break;
                }
                case '*': {
                    boolean isOperator = false;
                    int j = buf.length() - 1;
                    while (j >= 0) {
                        char localC = buf.charAt(j);
                        if (Character.isWhitespace(localC)) {
                            --j;
                            continue;
                        }
                        if (localC != '(') {
                            // empty if block
                        }
                        if (Character.isJavaIdentifierPart(localC)) {
                            FastStringBuffer localBufToCheckWildImport = new FastStringBuffer();
                            while (Character.isJavaIdentifierPart(localC)) {
                                localBufToCheckWildImport.append(localC);
                                if (--j < 0) break;
                                localC = buf.charAt(j);
                            }
                            String reversed = localBufToCheckWildImport.reverse().toString();
                            if (!reversed.equals("import") && !reversed.equals("lambda")) {
                                isOperator = true;
                            }
                        }
                        if (localC != '\'' && localC != ')' && localC != ']') break;
                        isOperator = true;
                        break;
                    }
                    if (!isOperator) {
                        buf.append('*');
                        break;
                    }
                }
                case '+': 
                case '-': {
                    if (c == '-' || c == '+') {
                        FastStringBuffer localBufToCheckNumber = new FastStringBuffer();
                        boolean started = false;
                        for (int j = buf.length() - 1; j >= 0; --j) {
                            char localC = buf.charAt(j);
                            if (localC == ' ' || localC == '\t') {
                                if (started) break;
                                continue;
                            }
                            started = true;
                            if (!Character.isJavaIdentifierPart(localC) && localC != '.') break;
                            localBufToCheckNumber.append(localC);
                        }
                        boolean isExponential = true;
                        String partialNumber = localBufToCheckNumber.reverse().toString();
                        int partialLen = partialNumber.length();
                        if (partialLen < 2 || !Character.isDigit(partialNumber.charAt(0))) {
                            isExponential = false;
                        } else if (partialNumber.charAt(partialLen - 1) != 'e' && partialNumber.charAt(partialLen - 1) != 'E') {
                            isExponential = false;
                        }
                        if (isExponential) {
                            buf.rightTrim();
                            buf.append(c);
                            int initial = i;
                            while (++i < cs.length && (c = cs[i]) == ' ' || c == '\t') {
                            }
                            if (i <= initial) break;
                            --i;
                            break;
                        }
                    }
                }
                case '!': 
                case '%': 
                case '&': 
                case '/': 
                case '<': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
                }
                case '=': {
                    if (i < cs.length - 1 && cs[i + 1] == '=') {
                        i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                        c = cs[i];
                        break;
                    }
                    while (true) {
                        if (buf.length() <= 0 || buf.lastChar() != ' ') {
                            boolean surroundWithSpaces = std.operatorsWithSpace;
                            if (parensLevel > 0) {
                                surroundWithSpaces = std.assignWithSpaceInsideParens;
                            }
                            if (surroundWithSpaces) {
                                buf.append(' ');
                            }
                            buf.append('=');
                            if (surroundWithSpaces) {
                                buf.append(' ');
                            }
                            i = parsingUtils.eatWhitespaces(null, i + 1);
                            break block0;
                        }
                        buf.deleteLast();
                    }
                }
                default: {
                    if (c == '\r' || c == '\n') {
                        if (lastChar == ',' && std.spaceAfterComma && buf.lastChar() == ' ') {
                            buf.deleteLast();
                        }
                        if (std.trimLines) {
                            buf.rightTrim();
                        }
                    }
                    buf.append(c);
                }
            }
            lastChar = c;
            ++i;
        }
        if (parensLevel == 0 && std.trimLines) {
            buf.rightTrim();
        }
        return buf.toString();
    }

    private int handleOperator(FormatStd std, char[] cs, FastStringBuffer buf, ParsingUtils parsingUtils, int i, char c) {
        boolean isUnaryWithContents = true;
        boolean isUnary = false;
        boolean changeWhitespacesBefore = true;
        if (c == '~' || c == '+' || c == '-') {
            String trimmedLastWord = buf.getLastWord().trim();
            boolean bl = isUnary = trimmedLastWord.length() == 0 || PySelection.ALL_KEYWORD_TOKENS.contains(trimmedLastWord);
            if (!isUnary) {
                Iterator iterator = buf.reverseIterator().iterator();
                while (iterator.hasNext()) {
                    char itChar = ((Character)iterator.next()).charValue();
                    if (itChar == ' ' || itChar == '\t') continue;
                    if (itChar == '=' || itChar == ',') {
                        isUnary = true;
                    }
                    switch (itChar) {
                        case '[': 
                        case '{': {
                            changeWhitespacesBefore = false;
                        }
                        case '(': 
                        case ':': {
                            isUnaryWithContents = false;
                        }
                        case '!': 
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '^': 
                        case '|': 
                        case '~': {
                            isUnary = true;
                        }
                    }
                    break;
                }
            } else {
                boolean bl2 = isUnaryWithContents = buf.length() > 0;
            }
        }
        if (!isUnary) {
            Iterator itChar = buf.reverseIterator().iterator();
            while (itChar.hasNext()) {
                char ch = ((Character)itChar.next()).charValue();
                if (!Character.isWhitespace(ch)) break;
                if (ch != '\r' && ch != '\n') continue;
                changeWhitespacesBefore = false;
                break;
            }
        }
        if (changeWhitespacesBefore) {
            while (buf.length() > 0 && (buf.lastChar() == ' ' || buf.lastChar() == ' ')) {
                buf.deleteLast();
            }
        }
        boolean surroundWithSpaces = std.operatorsWithSpace;
        if (changeWhitespacesBefore && isUnaryWithContents && surroundWithSpaces) {
            buf.append(' ');
        }
        char localC = c;
        char prev = '\u0000';
        boolean backOne = true;
        while (this.isOperatorPart(localC, prev)) {
            buf.append(localC);
            prev = localC;
            if (++i == cs.length) break;
            localC = cs[i];
            if (localC != 61) continue;
            buf.append(localC);
            backOne = false;
            break;
        }
        if (backOne) {
            --i;
        }
        if (!isUnary && surroundWithSpaces) {
            buf.append(' ');
        }
        i = parsingUtils.eatWhitespaces(null, i + 1);
        return i;
    }

    private boolean isOperatorPart(char c, char prev) {
        switch (c) {
            case '+': 
            case '-': 
            case '~': {
                return prev == '\u0000';
            }
        }
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private int formatForPar(ParsingUtils parsingUtils, char[] cs, int i, FormatStd std, FastStringBuffer buf, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        int j;
        int start;
        int c = 32;
        FastStringBuffer locBuf = new FastStringBuffer();
        int end = start = (j = i + 1);
        while (j < cs.length && (c = cs[j]) != 41) {
            ++j;
            if (c == 39 || c == 34) {
                end = j = parsingUtils.eatLiterals(null, j - 1, std.trimMultilineLiterals) + 1;
                continue;
            }
            if (c == 35) {
                end = j = parsingUtils.eatComments(null, j - 1) + 1;
                continue;
            }
            if (c == 40) {
                if (end > start) {
                    locBuf.append(cs, start, end - start);
                    start = end;
                }
                start = j = this.formatForPar(parsingUtils, cs, j - 1, std, locBuf, parensLevel + 1, delimiter, throwSyntaxError) + 1;
                continue;
            }
            end = j;
        }
        if (end > start) {
            locBuf.append(cs, start, end - start);
            start = end;
        }
        if (c == 41) {
            FastStringBuffer buf1 = new FastStringBuffer();
            if (locBuf.indexOf('\n') != -1 || locBuf.indexOf('\r') != -1) {
                char c1;
                int k = locBuf.length();
                while (k > 0 && (c1 = locBuf.charAt(k - 1)) != '\n' && c1 != '\r') {
                    buf1.insert(0, c1);
                    --k;
                }
            }
            String formatStr = this.formatStr(this.trim(locBuf).toString(), std, parensLevel, delimiter, throwSyntaxError);
            FastStringBuffer formatStrBuf = this.trim(new FastStringBuffer(formatStr, 10));
            String closing = ")";
            if (buf1.length() > 0 && PySelection.containsOnlyWhitespaces((String)buf1.toString())) {
                formatStrBuf.append(buf1);
            } else if (std.parametersWithSpace) {
                closing = " )";
            }
            if (std.parametersWithSpace) {
                if (formatStrBuf.length() == 0) {
                    buf.append("()");
                } else {
                    buf.append("( ");
                    buf.append(formatStrBuf);
                    buf.append(closing);
                }
            } else {
                buf.append('(');
                buf.append(formatStrBuf);
                buf.append(closing);
            }
            return j;
        }
        if (throwSyntaxError) {
            throw new SyntaxErrorException("No closing ')' found.");
        }
        buf.append('(');
        buf.append(locBuf);
        return j;
    }

    private FastStringBuffer trim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.firstChar() == ' ' || locBuf.firstChar() == '\t')) {
            locBuf.deleteCharAt(0);
        }
        this.rtrim(locBuf);
        return locBuf;
    }

    private FastStringBuffer rtrim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.lastChar() == ' ' || locBuf.lastChar() == '\t')) {
            locBuf.deleteLast();
        }
        return locBuf;
    }

    private int formatForComma(FormatStd std, char[] cs, FastStringBuffer buf, int i) {
        while (i < cs.length - 1 && cs[i + 1] == ' ') {
            ++i;
        }
        if (std.spaceAfterComma) {
            buf.append(", ");
        } else {
            buf.append(',');
        }
        return i;
    }

    public static class FormatStd {
        public boolean spaceAfterComma;
        public boolean parametersWithSpace;
        public boolean assignWithSpaceInsideParens;
        public boolean operatorsWithSpace;
        public boolean addNewLineAtEndOfFile;
        public boolean trimLines;
        public boolean trimMultilineLiterals;
    }
}

